/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.warnings;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.ui.swing.warnings.LibraryFileAdder;
import org.limewire.ui.swing.warnings.LibraryWarningDialog;

public class LibraryWarningController {
    private final Provider<LibraryWarningDialog> libraryWarningPanel;
    private final LibraryFileAdder libraryFileAdder;

    @Inject
    public LibraryWarningController(Provider<LibraryWarningDialog> libraryCategoryWarning, LibraryFileAdder libraryFileAdder) {
        this.libraryWarningPanel = libraryCategoryWarning;
        this.libraryFileAdder = libraryFileAdder;
    }

    public void addFiles(LocalFileList fileList, List<File> files) {
        int directoryCount = 0;
        for (File file : files) {
            if (fileList.isDirectoryAllowed(file) && ++directoryCount > 1) break;
        }
        if (directoryCount > 0) {
            LibraryWarningDialog panel = this.libraryWarningPanel.get();
            panel.initialize(fileList, files);
        } else {
            this.libraryFileAdder.addFilesInner(fileList, files, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return true;
                }
            });
        }
    }
}

