/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.magnet.MagnetLink;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.search.DefaultSearchInfo;
import org.limewire.ui.swing.search.SearchHandler;
import org.limewire.ui.swing.util.DownloadExceptionHandler;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.MagnetHandler;
import org.limewire.ui.swing.util.SwingUtils;

@LazySingleton
class MagnetHandlerImpl
implements MagnetHandler {
    private final DownloadListManager downloadListManager;
    private final SearchHandler searchHandler;
    private final Provider<DownloadExceptionHandler> downloadExceptionHandler;

    @Inject
    MagnetHandlerImpl(SearchHandler searchHandler, DownloadListManager downloadListManager, Provider<DownloadExceptionHandler> downloadExceptionHandler) {
        this.downloadListManager = downloadListManager;
        this.searchHandler = searchHandler;
        this.downloadExceptionHandler = downloadExceptionHandler;
    }

    @Override
    public void handleMagnet(final MagnetLink magnet) {
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                if (magnet.isDownloadable()) {
                    MagnetHandlerImpl.this.downloadMagnet(MagnetHandlerImpl.this.downloadListManager, MagnetHandlerImpl.this.downloadExceptionHandler, magnet);
                } else if (magnet.isKeywordTopicOnly()) {
                    MagnetHandlerImpl.this.searchHandler.doSearch(DefaultSearchInfo.createKeywordSearch(magnet.getQueryString(), SearchCategory.ALL));
                } else {
                    FocusJOptionPane.showMessageDialog(GuiUtils.getMainFrame(), I18n.tr("Invalid magnet option."), I18n.tr("Open Link"), 1);
                }
            }
        });
    }

    private void downloadMagnet(final DownloadListManager downloadListManager, Provider<DownloadExceptionHandler> downloadExceptionHandler, final MagnetLink magnet) {
        try {
            downloadListManager.addDownload(magnet, null, false);
        }
        catch (DownloadException e1) {
            downloadExceptionHandler.get().handleDownloadException(new DownloadAction(){

                @Override
                public void download(File saveFile, boolean overwrite) throws DownloadException {
                    downloadListManager.addDownload(magnet, saveFile, overwrite);
                }

                @Override
                public void downloadCanceled(DownloadException ignored) {
                }
            }, e1, true);
        }
    }
}

