/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.statusbar;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

@Singleton
class SharedFileCountPanel
extends JXButton {
    @Resource
    private Font font;
    @Resource
    private Color foreground;
    @InspectablePrimitive(value="bottom share button clicked", category=DataCategory.USAGE)
    private int shareButtonClicked = 0;

    @Inject
    SharedFileCountPanel(SharedFileListManager shareListManager) {
        super(I18n.tr("Sharing {0} files", shareListManager.getSharedFileCount()));
        GuiUtils.assignResources(this);
        this.setFont(this.font);
        this.setForeground(this.foreground);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SharedFileCountPanel.this.shareButtonClicked++;
            }
        });
    }

    @Inject
    void register(SharedFileListManager shareListManager) {
        shareListManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("sharedFileCount")) {
                    SharedFileCountPanel.this.setText(I18n.trn("Sharing {0} file", "Sharing {0} files", ((Integer)evt.getNewValue()).intValue()));
                }
            }
        });
    }
}

