/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.settings;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import org.limewire.core.api.Category;
import org.limewire.core.settings.LimeProps;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.FileArraySetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.FloatSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class SwingUiSettings
extends LimeProps {
    public static final FileArraySetting VISTA_WARN_DIRECTORIES = FACTORY.createFileArraySetting("VISTA_WARN_DIRECTORIES", new File[0]);
    public static final BooleanSetting REMEMBER_ME_CHECKED = FACTORY.createBooleanSetting("REMEMBER_ME_XMPP", true);
    public static final StringArraySetting PRO_ADS = FACTORY.createRemoteStringArraySetting("PRO_ADS", new String[]{I18nMarker.marktr("For Turbo-Charged searches get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&21", "0.111111", I18nMarker.marktr("Support LimeWire's peer-to-peer development. Get PRO."), "http://www.limewire.com/index.jsp/pro&22", "0.111111", I18nMarker.marktr("Purchase LimeWire PRO to help us make downloads faster."), "http://www.limewire.com/index.jsp/pro&23", "0.111111", I18nMarker.marktr("For Turbo-Charged downloads get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&24", "0.111111", I18nMarker.marktr("Support open networks. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&25", "0.111111", I18nMarker.marktr("Support open source and open protocols. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&26", "0.111111", I18nMarker.marktr("For Turbo-Charged performance get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&27", "0.111111", I18nMarker.marktr("Keep the Internet open. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&28", "0.111111", I18nMarker.marktr("Developing LimeWire costs real money. Get PRO."), "http://www.limewire.com/index.jsp/pro&29", "0.111111"}, "UpdateSettings.proAds");
    public static final BooleanSetting SHOW_CLASSIC_REMINDER = FACTORY.createBooleanSetting("SHOW_CLASSIC_SEARCH_REMINDER", true);
    public static final BooleanSetting GROUP_SIMILAR_RESULTS_ENABLED = FACTORY.createBooleanSetting("GROUP_SIMILAR_RESULTS_ENABLED", true);
    public static final BooleanSetting SHOW_FRIEND_SUGGESTIONS = FACTORY.createBooleanSetting("SHOW_FRIEND_SUGGESTIONS", true);
    public static final BooleanSetting KEEP_SEARCH_HISTORY = FACTORY.createBooleanSetting("KEEP_SEARCH_HISTORY", true);
    public static final IntSetting DEFAULT_SEARCH_CATEGORY_ID = FACTORY.createIntSetting("DEFAULT_SEARCH_CATEGORY_ID", -1);
    public static final IntSetting SEARCH_VIEW_TYPE_ID = FACTORY.createIntSetting("SEARCH_VIEW_TYPE_ID", -1);
    public static final BooleanSetting AUTO_RENAME_DUPLICATE_FILES = FACTORY.createBooleanSetting("AUTO_RENAME_DUPLICATE_FILES", true);
    @InspectionPoint(value="application positions set", category=DataCategory.USAGE)
    public static final BooleanSetting POSITIONS_SET = FACTORY.createBooleanSetting("POSITIONS_SET", false);
    @InspectionPoint(value="application width", category=DataCategory.USAGE)
    public static final IntSetting APP_WIDTH = FACTORY.createIntSetting("APP_WIDTH_V5", 1024);
    @InspectionPoint(value="application height", category=DataCategory.USAGE)
    public static final IntSetting APP_HEIGHT = FACTORY.createIntSetting("APP_HEIGHT_V5", 768);
    public static final IntSetting WINDOW_X = FACTORY.createIntSetting("WINDOW_X_V5", 0).setAlwaysSave(true);
    public static final IntSetting WINDOW_Y = FACTORY.createIntSetting("WINDOW_Y_V5", 0).setAlwaysSave(true);
    @InspectionPoint(value="is application maximized", category=DataCategory.USAGE)
    public static final BooleanSetting MAXIMIZE_WINDOW = FACTORY.createBooleanSetting("MAXIMIZE_WINDOW_V5", false);
    public static final BooleanSetting MINIMIZE_TO_TRAY = FACTORY.createBooleanSetting("MINIMIZE_TO_TRAY", OSUtils.supportsTray());
    public static final BooleanSetting HANDLE_MAGNETS = FACTORY.createBooleanSetting("HANDLE_MAGNETS", true);
    public static final BooleanSetting HANDLE_TORRENTS = FACTORY.createBooleanSetting("HANDLE_TORRENTS", true);
    public static final BooleanSetting WARN_FILE_ASSOCIATION_CHANGES = FACTORY.createBooleanSetting("WARN_FILE_ASSOCIATION_CHANGES", true);
    public static final FileSetting LAST_FILECHOOSER_DIRECTORY = FACTORY.createFileSetting("LAST_FILECHOOSER_DIR", SwingUiSettings.getDefaultLastFileChooserDir()).setAlwaysSave(true);
    public static final BooleanSetting USAGE_STATS = FACTORY.createBooleanSetting("USAGE_STATS", false);
    public static final BooleanSetting PRELOAD_NATIVE_ICONS = FACTORY.createBooleanSetting("PRELOAD_NATIVE_ICONS", true);
    public static final BooleanSetting SHOW_NOTIFICATIONS = FACTORY.createBooleanSetting("SHOW_NOTIFICATIONS", true);
    public static final BooleanSetting PLAY_NOTIFICATION_SOUND = FACTORY.createBooleanSetting("PLAY_NOTIFICATION_SOUND", false);
    public static final StringSetting USER_DEFINED_JABBER_SERVICENAME = (StringSetting)FACTORY.createStringSetting("CUSTOM_JABBER_SERVICENAME", "").setPrivate(true);
    public static final StringSetting XMPP_AUTO_LOGIN = (StringSetting)FACTORY.createStringSetting("XMPP_AUTO_LOGIN", "").setPrivate(true);
    public static final BooleanSetting OFFLINE_COLLAPSED = FACTORY.createBooleanSetting("OFFLINE_CONTACTS_COLLAPSED", true);
    public static final BooleanSetting ONLINE_COLLAPSED = FACTORY.createBooleanSetting("ONLINE_CONTACTS_COLLAPSED", false);
    @InspectionPoint(value="player enabled", category=DataCategory.USAGE)
    public static final BooleanSetting PLAYER_ENABLED = FACTORY.createBooleanSetting("PLAYER_ENABLED", true);
    public static final FloatSetting PLAYER_VOLUME = FACTORY.createFloatSetting("PLAYER_VOLUME", 0.5f, 0.0f, 1.0f);
    public static final BooleanSetting VIDEO_FIT_TO_SCREEN = FACTORY.createBooleanSetting("VIDEO_FIT_TO_SCREEN", false);
    public static final BooleanSetting SHOW_LIBRARY_OVERLAY_MESSAGE = FACTORY.createBooleanSetting("SHOW_LIBRARY_OVERLAY_MESSAGE", true);
    public static final BooleanSetting SHOW_SHARING_OVERLAY_MESSAGE = FACTORY.createBooleanSetting("SHOW_SHARING_OVERLAY_MESSAGE", true);
    @InspectionPoint(value="library filters showing", category=DataCategory.USAGE)
    public static final BooleanSetting SHOW_LIBRARY_FILTERS = FACTORY.createBooleanSetting("SHOW_LIBRARY_FILTERS", true);
    public static final BooleanSetting RESOLVE_CONNECTION_HOSTNAMES = FACTORY.createBooleanSetting("RESOLVE_CONNECTION_HOSTNAMES", true);
    public static final IntSetting BOTTOM_TRAY_SIZE = FACTORY.createIntSetting("DOWNLOAD_TRAY_SIZE", 0);
    public static final BooleanSetting HIDE_BOTTOM_TRAY_WHEN_NO_TRANSFERS = FACTORY.createBooleanSetting("HIDE_BOTTOM_TRAY_WHEN_NO_TRANSFERS", true);
    public static final BooleanSetting SHOW_TOTAL_BANDWIDTH = FACTORY.createBooleanSetting("SHOW_TOTAL_BANDWIDTH", false);
    public static final BooleanSetting CATEGORY_AUDIO_DEFAULT = FACTORY.createBooleanSetting("MANAGE_AUDIO_FILES", true);
    public static final BooleanSetting CATEGORY_VIDEO_DEFAULT = FACTORY.createBooleanSetting("MANAGE_VIDEO_FILES", true);
    public static final BooleanSetting CATEGORY_IMAGES_DEFAULT = FACTORY.createBooleanSetting("MANAGE_IMAGES_FILES", true);
    public static final BooleanSetting CATEGORY_DOCUMENTS_DEFAULT = FACTORY.createBooleanSetting("MANAGE_DOCUMENTS_FILES", false);
    public static final BooleanSetting CATEGORY_PROGRAMS_DEFAULT = FACTORY.createBooleanSetting("MANAGE_PROGRAMS_FILES", false);
    public static final BooleanSetting SHOW_STORE_COMPONENTS = FACTORY.createBooleanSetting("SHOW_STORE_COMPONENTS", false);
    public static final BooleanSetting SHOW_TRANSFERS_TRAY = FACTORY.createBooleanSetting("ALWAYS_SHOW_DOWNLOADS_TRAY", false);
    public static final BooleanSetting DOWNLOAD_SORT_ASCENDING = FACTORY.createBooleanSetting("DOWNLOAD_SORT_ASCENDING", false);
    public static final StringSetting DOWNLOAD_SORT_KEY = FACTORY.createStringSetting("DOWNLOAD_SORT_KEY", "ORDER_ADDED");
    public static final BooleanSetting UPLOAD_SORT_ASCENDING = FACTORY.createBooleanSetting("UPLOAD_SORT_ASCENDING", true);
    public static final StringSetting UPLOAD_SORT_KEY = FACTORY.createStringSetting("UPLOAD_SORT_KEY", "ORDER_STARTED");
    public static final BooleanSetting HIDE_DOWNLOAD_DANGEROUS = FACTORY.createBooleanSetting("HIDE_DOWNLOAD_DANGEROUS", true);
    public static final BooleanSetting HIDE_DOWNLOAD_SCAN_FAILED = FACTORY.createBooleanSetting("HIDE_DOWNLOAD_SCAN_FAILED", true);
    public static final BooleanSetting HIDE_DOWNLOAD_THREAT_FOUND = FACTORY.createBooleanSetting("HIDE_DOWNLOAD_THREAT_FOUND", true);
    public static final BooleanSetting WARN_DOWNLOAD_DANGEROUS = FACTORY.createBooleanSetting("WARN_DOWNLOAD_DANGEROUS", true);
    public static final BooleanSetting WARN_DOWNLOAD_SCAN_FAILED = FACTORY.createBooleanSetting("WARN_DOWNLOAD_SCAN_FAILED", true);
    public static final BooleanSetting WARN_DOWNLOAD_THREAT_FOUND = FACTORY.createBooleanSetting("WARN_DOWNLOAD_THREAT_FOUND", true);

    private SwingUiSettings() {
    }

    private static File getDefaultLastFileChooserDir() {
        File defaultDirectory = CommonUtils.getUserHomeDir();
        if (defaultDirectory == null || !defaultDirectory.exists()) {
            defaultDirectory = CommonUtils.getCurrentDirectory();
        }
        return defaultDirectory;
    }

    public static Collection<Category> getDefaultSelectedCategories() {
        ImmutableList.Builder<Category> builder = ImmutableList.builder();
        if (((Boolean)CATEGORY_AUDIO_DEFAULT.get()).booleanValue()) {
            builder.add(Category.AUDIO);
        }
        if (((Boolean)CATEGORY_DOCUMENTS_DEFAULT.get()).booleanValue()) {
            builder.add(Category.DOCUMENT);
        }
        if (((Boolean)CATEGORY_IMAGES_DEFAULT.get()).booleanValue()) {
            builder.add(Category.IMAGE);
        }
        if (((Boolean)CATEGORY_PROGRAMS_DEFAULT.get()).booleanValue()) {
            builder.add(Category.PROGRAM);
        }
        if (((Boolean)CATEGORY_VIDEO_DEFAULT.get()).booleanValue()) {
            builder.add(Category.VIDEO);
        }
        return builder.build();
    }

    @InspectableContainer
    private static class LazyInspectableContainer {
        @InspectionPoint(value="search view", category=DataCategory.USAGE)
        private static final Inspectable searchViewType = new Inspectable(){

            @Override
            public Object inspect() {
                return SEARCH_VIEW_TYPE_ID.get() == 1 ? "table" : "list";
            }
        };

        private LazyInspectableContainer() {
        }
    }
}

