/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class PiecesGrid
extends JXPanel {
    private int rows = -1;
    private int columns = -1;
    private Paint[] gridFillPaint = null;
    private final Map<Integer, Paint> borderPaintMap = new HashMap<Integer, Paint>();

    public PiecesGrid() {
        this.init();
    }

    public PiecesGrid(int r, int c) {
        this.resizeGrid(r, c);
        this.init();
    }

    private void init() {
        this.setBackgroundPainter(new GridPainter());
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if ((e.getModifiers() & 2) == 0) {
                    return;
                }
                int newRows = PiecesGrid.this.rows;
                int newColumns = PiecesGrid.this.columns;
                if (e.getUnitsToScroll() < 0) {
                    if (PiecesGrid.this.columns > 4) {
                        newColumns = PiecesGrid.this.columns - 1;
                    }
                    if (PiecesGrid.this.rows > 4) {
                        newRows = PiecesGrid.this.rows - 1;
                    }
                } else if (e.getUnitsToScroll() > 0) {
                    if (PiecesGrid.this.columns < 200) {
                        newColumns = PiecesGrid.this.columns + 1;
                    }
                    if (PiecesGrid.this.rows < 200) {
                        newRows = PiecesGrid.this.rows + 1;
                    }
                }
                PiecesGrid.this.resizeGrid(newRows, newColumns);
            }
        });
    }

    void resizeGrid(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.gridFillPaint = new Paint[rows * columns];
    }

    public void clear() {
        this.clearFillPaints();
        this.clearBorderPaints();
    }

    public void clearFillPaints() {
        this.gridFillPaint = new Paint[this.rows * this.columns];
    }

    public void clearBorderPaints() {
        this.borderPaintMap.clear();
    }

    boolean hasGrid() {
        return this.gridFillPaint != null;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getCellCount() {
        return this.gridFillPaint.length;
    }

    public void setCellFillPaint(int cell, Paint paint) {
        this.gridFillPaint[cell] = paint;
    }

    public void setCellBorderPaint(int cell, Paint paint) {
        this.borderPaintMap.put(cell, paint);
    }

    public Paint getCellFillPaint(int cell) {
        return this.gridFillPaint[cell];
    }

    public Paint getCellBorderPaint(int cell) {
        return this.borderPaintMap.get(cell);
    }

    @Override
    public void repaint() {
        Painter painter = this.getBackgroundPainter();
        if (painter instanceof AbstractPainter) {
            ((AbstractPainter)painter).clearCache();
        }
        super.repaint();
    }

    public int getInnerMargin() {
        Painter painter = this.getBackgroundPainter();
        if (painter instanceof GridPainter) {
            ((GridPainter)painter).marginUpdated = false;
            return ((GridPainter)painter).marginX;
        }
        return 0;
    }

    public boolean isMarginUpdated() {
        Painter painter = this.getBackgroundPainter();
        if (painter instanceof GridPainter) {
            return ((GridPainter)painter).marginUpdated;
        }
        return false;
    }

    private static class GridPainter
    extends AbstractPainter<PiecesGrid> {
        protected int marginX = 0;
        protected boolean marginUpdated = false;

        GridPainter() {
            this.setCacheable(true);
            this.setAntialiasing(true);
        }

        @Override
        protected void doPaint(Graphics2D g, PiecesGrid grid, int width, int height) {
            int i;
            if (!grid.hasGrid()) {
                g.setPaint(Color.BLACK);
                g.drawRect(0, 0, width - 1, height - 1);
                return;
            }
            int columns = grid.getColumns();
            int rows = grid.getRows();
            int cellWidth = (width - 2) / columns;
            int cellHeight = (height - 2) / rows;
            int actualTableWidth = cellWidth * columns;
            int actualTableHeight = cellHeight * rows;
            int alignOffsetX = Math.round(grid.getAlignmentX() * (float)(width - actualTableWidth));
            int alignOffsetY = Math.round(grid.getAlignmentY() * (float)(height - actualTableHeight));
            if (this.marginX != alignOffsetX) {
                this.marginX = alignOffsetX;
                this.marginUpdated = true;
            }
            int cellRow = 0;
            for (i = 0; i < grid.getCellCount(); ++i) {
                Paint cellPaint = grid.getCellFillPaint(i);
                int cellColumn = i % columns;
                if (i != 0 && i % columns == 0) {
                    ++cellRow;
                }
                g.setPaint(cellPaint);
                g.fillRect(cellColumn * cellWidth + 1 + alignOffsetX, cellRow * cellHeight + 1 + alignOffsetY, cellWidth, cellHeight);
                Paint borderPaint = grid.getCellBorderPaint(i);
                if (borderPaint != null) {
                    g.setPaint(borderPaint);
                    g.drawRect(cellColumn * cellWidth + 1 + alignOffsetX, cellRow * cellHeight + 1 + alignOffsetY, cellWidth - 2, cellHeight - 2);
                }
                g.setPaint(Color.BLACK);
            }
            g.setPaint(Color.BLACK);
            g.drawRect(0 + alignOffsetX, 0 + alignOffsetY, actualTableWidth, actualTableHeight);
            for (i = 1; i < columns; ++i) {
                g.drawLine(i * cellWidth + alignOffsetX, 0 + alignOffsetY, i * cellWidth + alignOffsetX, actualTableHeight + alignOffsetY);
            }
            for (i = 1; i < rows; ++i) {
                g.drawLine(0 + alignOffsetX, i * cellHeight + alignOffsetY, actualTableWidth + alignOffsetX, i * cellHeight + alignOffsetY);
            }
        }
    }
}

