/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.util.PaintUtils;
import org.limewire.ui.swing.util.GuiUtils;

public class SearchTabPainter<X>
extends AbstractPainter<X> {
    private final Paint topBevelBackground;
    private final Paint topBevelBorder;
    private final boolean raiseBottomClip;
    private Paint background;
    private Area tabAreaCache = null;
    private int tabWidthCache = 0;
    private int tabHeightCache = 0;

    public SearchTabPainter(Paint topBevelBackground, Paint topBevelBorder, Paint background) {
        this(topBevelBackground, topBevelBorder, background, false);
    }

    public SearchTabPainter(Paint topBevelBackground, Paint topBevelBorder, Paint background, boolean raiseBottomClip) {
        GuiUtils.assignResources(this);
        this.setAntialiasing(true);
        this.setCacheable(true);
        this.topBevelBackground = topBevelBackground;
        this.topBevelBorder = topBevelBorder;
        this.raiseBottomClip = raiseBottomClip;
        this.background = background;
    }

    private void cacheTabArea(int width, int height) {
        if (this.tabWidthCache == width && this.tabHeightCache == height) {
            return;
        }
        this.background = PaintUtils.resizeGradient(this.background, 0, height);
        Area compound = new Area(new RoundRectangle2D.Float(10.0f, 3.0f, width - 1 - 20, height - 1, 20.0f, 20.0f));
        compound.add(new Area(new Rectangle2D.Float(0.0f, height - 10 - 1, width - 1, height - 1)));
        compound.subtract(new Area(new Arc2D.Float(-10.0f, height - 1 - 21, 20.0f, 20.0f, 270.0f, 90.0f, 2)));
        compound.subtract(new Area(new Arc2D.Float(width - 1 - 10, height - 1 - 21, 20.0f, 20.0f, 360.0f, 270.0f, 2)));
        this.tabAreaCache = compound;
        this.tabWidthCache = width;
        this.tabHeightCache = height;
    }

    @Override
    protected void doPaint(Graphics2D g, X object, int width, int height) {
        this.cacheTabArea(width, height);
        if (this.raiseBottomClip) {
            g.setClip(0, 0, width, height - 1);
        }
        g.setPaint(this.topBevelBackground);
        g.fillRoundRect(10, 0, width - 2 - 20, 20, 20, 20);
        g.setPaint(this.topBevelBorder);
        g.drawRoundRect(10, 0, width - 2 - 20, 20, 20, 20);
        g.setPaint(this.background);
        g.fill(this.tabAreaCache);
        if (!this.raiseBottomClip) {
            g.setPaint(new Color(202, 202, 202));
            g.drawLine(0, height - 2, 0, height - 2);
            g.drawLine(width - 1, height - 2, width - 1, height - 2);
            g.setPaint(new Color(171, 171, 171));
            g.drawLine(1, height - 2, 1, height - 2);
            g.drawLine(width - 2, height - 2, width - 2, height - 2);
        }
    }
}

