/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.limewire.ui.swing.components.PromptPasswordField;
import org.limewire.ui.swing.components.PromptTextField;

public class BasicTextFieldPromptPainter<X extends JTextField>
extends AbstractPainter<X> {
    private final Paint promptForeground;

    public BasicTextFieldPromptPainter(Paint promptForeground) {
        this.promptForeground = promptForeground;
        this.setAntialiasing(true);
    }

    @Override
    protected void doPaint(Graphics2D g, X object, int width, int height) {
        g.setPaint(this.promptForeground);
        g.setFont(((Component)object).getFont());
        int dot = ((JTextComponent)object).getCaret().getDot();
        Rectangle r = null;
        try {
            r = ((JTextComponent)object).modelToView(dot);
        }
        catch (BadLocationException e) {
            return;
        }
        int x = r.x;
        int y = r.y + r.height - 3;
        g.drawString(BasicTextFieldPromptPainter.getPromptText(object), x, y);
    }

    private static String getPromptText(Object object) {
        if (object instanceof PromptTextField) {
            return ((PromptTextField)object).getPromptText();
        }
        if (object instanceof PromptPasswordField) {
            return ((PromptPasswordField)object).getPromptText();
        }
        throw new IllegalArgumentException("Prompt painter does not yet support " + object.getClass());
    }
}

