/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentSettingsAnnotation;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.actions.CancelDialogAction;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class BitTorrentOptionPanel
extends OptionPanel {
    private final Provider<TorrentManager> torrentManager;
    private final TorrentManagerSettings torrentSettings;
    private final JRadioButton uploadTorrentsForeverButton;
    private final JRadioButton uploadTorrentsControlButton;
    private final SpinnerNumberModel seedRatioModel;
    private final JLabel seedRatioLabel;
    private final JSpinner seedRatioSpinner;
    private final SpinnerNumberModel seedTimeModel;
    private final JLabel seedTimeLabel;
    private final JSpinner seedTimeSpinner;
    private final JCheckBox chooseTorrentsCheckBox;

    @Inject
    public BitTorrentOptionPanel(Provider<TorrentManager> torrentManager, @TorrentSettingsAnnotation TorrentManagerSettings torrentSettings) {
        this.torrentManager = torrentManager;
        this.torrentSettings = torrentSettings;
        this.setLayout(new MigLayout("fill"));
        this.setOpaque(false);
        this.uploadTorrentsForeverButton = new JRadioButton(I18n.tr("Upload torrents forever"));
        this.uploadTorrentsForeverButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BitTorrentOptionPanel.this.updateState(BitTorrentOptionPanel.this.uploadTorrentsForeverButton.isSelected());
            }
        });
        this.uploadTorrentsControlButton = new JRadioButton(I18n.tr("Upload torrents until either of the following:"));
        this.uploadTorrentsControlButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BitTorrentOptionPanel.this.updateState(BitTorrentOptionPanel.this.uploadTorrentsForeverButton.isSelected());
            }
        });
        this.uploadTorrentsForeverButton.setOpaque(false);
        this.uploadTorrentsControlButton.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.uploadTorrentsForeverButton);
        buttonGroup.add(this.uploadTorrentsControlButton);
        this.seedRatioModel = new SpinnerNumberModel(BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.get().doubleValue(), ((Float)BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getMinValue()).doubleValue(), ((Float)BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getMaxValue()).doubleValue(), 0.05);
        this.seedRatioSpinner = new JSpinner(this.seedRatioModel);
        this.seedRatioSpinner.setPreferredSize(new Dimension(50, 20));
        this.seedRatioSpinner.setMaximumSize(new Dimension(60, 20));
        this.seedTimeModel = new SpinnerNumberModel(this.getDays(BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.get()), this.getDays((Integer)BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.getMinValue()), this.getDays((Integer)BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.getMaxValue()), 0.05);
        this.seedTimeSpinner = new JSpinner(this.seedTimeModel);
        this.seedTimeSpinner.setPreferredSize(new Dimension(50, 20));
        this.seedTimeSpinner.setMaximumSize(new Dimension(60, 20));
        this.seedRatioLabel = new JLabel(I18n.tr("Ratio:"));
        this.seedTimeLabel = new JLabel(I18n.tr("Maximum days:"));
        this.chooseTorrentsCheckBox = new JCheckBox(I18n.tr("Let me choose files to download when starting a torrent"));
        this.chooseTorrentsCheckBox.setOpaque(false);
        if (torrentManager.get().isValid()) {
            this.add((Component)this.uploadTorrentsForeverButton, "span 3, wrap");
            this.add((Component)this.uploadTorrentsControlButton, "span 3, wrap");
            this.add((Component)this.seedRatioLabel, "gapleft 20");
            this.add((Component)this.seedRatioSpinner, "span, wrap");
            this.add((Component)this.seedTimeLabel, "gapleft 20");
            this.add((Component)this.seedTimeSpinner, "span, wrap");
            this.add((Component)this.chooseTorrentsCheckBox, "span, gaptop 10, gapbottom 5, wrap");
        } else {
            this.add((Component)new MultiLineLabel(I18n.tr("There was an error loading bittorrent. You will not be able to use bittorrent capabilities until this is resolved."), 500), "wrap");
        }
        this.add((Component)new JButton(new OKDialogAction()), "span, tag ok, alignx right, split 2");
        this.add((Component)new JButton(new CancelDialogAction()), "tag cancel");
    }

    @Override
    boolean applyOptions() {
        BittorrentSettings.UPLOAD_TORRENTS_FOREVER.setValue(this.uploadTorrentsForeverButton.isSelected());
        if (!this.uploadTorrentsForeverButton.isSelected()) {
            BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.setValue(this.seedRatioModel.getNumber().floatValue());
            BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.setValue(Double.valueOf(Math.ceil((Double)this.seedTimeSpinner.getValue() * 60.0 * 60.0 * 24.0)).intValue());
        }
        BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.setValue(this.chooseTorrentsCheckBox.isSelected());
        if (this.torrentManager.get().isInitialized() && this.torrentManager.get().isValid()) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    ((TorrentManager)BitTorrentOptionPanel.this.torrentManager.get()).setTorrentManagerSettings(BitTorrentOptionPanel.this.torrentSettings);
                }
            });
        }
        return false;
    }

    @Override
    boolean hasChanged() {
        return BittorrentSettings.UPLOAD_TORRENTS_FOREVER.getValue() != this.uploadTorrentsForeverButton.isSelected() || ((Float)this.seedRatioSpinner.getValue()).floatValue() != BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.getValue() || Double.valueOf(Math.ceil((Double)this.seedTimeSpinner.getValue() * 60.0 * 60.0 * 24.0)).intValue() != BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.getValue() || this.chooseTorrentsCheckBox.isSelected() != BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.getValue();
    }

    @Override
    public void initOptions() {
        boolean auto = BittorrentSettings.UPLOAD_TORRENTS_FOREVER.getValue();
        if (auto) {
            this.uploadTorrentsForeverButton.setSelected(true);
        } else {
            this.uploadTorrentsControlButton.setSelected(true);
        }
        this.seedRatioSpinner.setValue(BittorrentSettings.LIBTORRENT_SEED_RATIO_LIMIT.get().doubleValue());
        this.seedTimeSpinner.setValue(this.getDays(BittorrentSettings.LIBTORRENT_SEED_TIME_LIMIT.get()));
        this.chooseTorrentsCheckBox.setSelected(BittorrentSettings.TORRENT_SHOW_POPUP_BEFORE_DOWNLOADING.getValue());
    }

    private double getDays(Integer integer) {
        return integer.doubleValue() / 86400.0;
    }

    private void updateState(boolean uploadForever) {
        this.seedRatioLabel.setEnabled(!uploadForever);
        this.seedRatioSpinner.setEnabled(!uploadForever);
        this.seedTimeLabel.setEnabled(!uploadForever);
        this.seedTimeSpinner.setEnabled(!uploadForever);
    }
}

