/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.limewire.ui.swing.options.FilteringOptionPanel;
import org.limewire.ui.swing.options.ListeningPortsOptionPanel;
import org.limewire.ui.swing.options.NetworkInterfaceOptionPanel;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.PerformanceOptionPanel;
import org.limewire.ui.swing.options.ProxyOptionPanel;
import org.limewire.ui.swing.options.SystemOptionPanel;
import org.limewire.ui.swing.util.I18n;

public class AdvancedOptionPanel
extends OptionPanel {
    public static final int MULTI_LINE_LABEL_WIDTH = 440;
    private static final String SYSTEM = I18n.tr("System");
    private static final String LISTENING_PORTS = I18n.tr("Listening Ports");
    private static final String PROXY = I18n.tr("Proxy");
    private static final String NETWORK_INTERFACE = I18n.tr("Network Interface");
    private static final String PERFORMANCE = I18n.tr("Performance");
    private static final String FILTERING = I18n.tr("Filtering");
    private final CardLayout cardLayout;
    private final JPanel cardPanel;
    private final JList list;
    private final Map<String, Provider<? extends OptionPanel>> providers = new HashMap<String, Provider<? extends OptionPanel>>();
    private final Map<String, OptionPanel> panels = new HashMap<String, OptionPanel>();

    @Inject
    public AdvancedOptionPanel(Provider<ListeningPortsOptionPanel> firewallOptionPanel, Provider<ProxyOptionPanel> proxyOptionPanel, Provider<NetworkInterfaceOptionPanel> networkInterfaceOptionPanel, Provider<PerformanceOptionPanel> performanceOptionPanel, Provider<FilteringOptionPanel> filteringOptionPanel, Provider<SystemOptionPanel> systemOptionPanel) {
        this.providers.put(SYSTEM, systemOptionPanel);
        this.providers.put(LISTENING_PORTS, firewallOptionPanel);
        this.providers.put(PROXY, proxyOptionPanel);
        this.providers.put(NETWORK_INTERFACE, networkInterfaceOptionPanel);
        this.providers.put(PERFORMANCE, performanceOptionPanel);
        this.providers.put(FILTERING, filteringOptionPanel);
        this.setLayout(new MigLayout("insets 15, fill, gapy 10", "[][grow]", "[][]"));
        this.list = new JList();
        this.list.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.list.setSelectionMode(0);
        this.list.setPreferredSize(new Dimension(150, 500));
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel();
        this.cardPanel.setOpaque(false);
        this.cardPanel.setLayout(this.cardLayout);
        this.createPanel(SYSTEM);
        this.createList();
        this.add((Component)new JLabel(I18n.tr("We recommend you don't touch these unless you really know what you're doing.")), "span 2, wrap");
        this.add((Component)this.list, "growy");
        this.add((Component)this.cardPanel, "grow");
        this.list.setSelectedIndex(0);
    }

    @Inject
    void register() {
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String name = (String)AdvancedOptionPanel.this.list.getModel().getElementAt(AdvancedOptionPanel.this.list.getSelectedIndex());
                if (!AdvancedOptionPanel.this.panels.containsKey(name)) {
                    AdvancedOptionPanel.this.createPanel(name);
                }
                AdvancedOptionPanel.this.cardLayout.show(AdvancedOptionPanel.this.cardPanel, name);
            }
        });
    }

    private void createPanel(String id) {
        this.panels.put(id, this.providers.get(id).get());
        this.cardPanel.add((Component)this.panels.get(id), id);
        this.panels.get(id).initOptions();
    }

    private void createList() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(SYSTEM);
        model.addElement(LISTENING_PORTS);
        model.addElement(PROXY);
        model.addElement(NETWORK_INTERFACE);
        model.addElement(PERFORMANCE);
        model.addElement(FILTERING);
        this.list.setModel(model);
    }

    @Override
    boolean applyOptions() {
        boolean restartRequired = false;
        for (OptionPanel panel : this.panels.values()) {
            restartRequired |= panel.applyOptions();
        }
        return restartRequired;
    }

    @Override
    boolean hasChanged() {
        for (OptionPanel panel : this.panels.values()) {
            if (!panel.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initOptions() {
        for (OptionPanel panel : this.panels.values()) {
            panel.initOptions();
        }
    }
}

