/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventUtils;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.ActionLabel;
import org.limewire.ui.swing.components.LimeComboBox;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.components.decorators.ComboBoxDecorator;
import org.limewire.ui.swing.friends.actions.BrowseFriendsAction;
import org.limewire.ui.swing.friends.actions.FriendServiceItem;
import org.limewire.ui.swing.friends.actions.LoginAction;
import org.limewire.ui.swing.friends.actions.LogoutAction;
import org.limewire.ui.swing.friends.login.AutoLoginService;
import org.limewire.ui.swing.friends.refresh.AllFriendsRefreshManager;
import org.limewire.ui.swing.friends.refresh.BrowseRefreshStatus;
import org.limewire.ui.swing.friends.refresh.BrowseRefreshStatusListener;
import org.limewire.ui.swing.listener.ActionHandListener;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.PainterUtils;
import org.limewire.ui.swing.util.SwingUtils;

public class FriendsButton
extends LimeComboBox {
    @Resource
    private Icon friendOnlineIcon;
    @Resource
    private Icon friendOfflineIcon;
    @Resource
    private Icon friendOnlineSelectedIcon;
    @Resource
    private Icon friendOfflineSelectedIcon;
    @Resource
    private Icon friendLoadingIcon;
    @Resource
    private Icon friendLoadingSelectedIcon;
    @Resource
    private Icon friendNewFilesIcon;
    @Resource
    private Icon friendNewFilesSelectedIcon;
    @Resource
    private Color borderForeground = PainterUtils.TRASPARENT;
    @Resource
    private Color borderInsideRightForeground = PainterUtils.TRASPARENT;
    @Resource
    private Color borderInsideBottomForeground = PainterUtils.TRASPARENT;
    @Resource
    private Color dividerForeground = PainterUtils.TRASPARENT;
    @Resource
    private Font menuFont;
    @Resource
    private Color menuForeground;
    @Resource
    private Font browseNotificationFont;
    @Resource
    private Icon browseNotificationIcon;
    private boolean newResultsAvailable = false;
    private final BusyPainter busyPainter;
    private Timer busy;
    private final JPopupMenu menu;
    private final Provider<FriendServiceItem> serviceItemProvider;
    private final Provider<BrowseFriendsAction> browseFriendsActionProvider;
    private final Provider<LoginAction> loginActionProvider;
    private final Provider<LogoutAction> logoutActionProvider;
    private final AutoLoginService autoLoginService;
    private final EventBean<FriendConnectionEvent> friendConnectionEventBean;
    private final AllFriendsRefreshManager allFriendsRefreshManager;

    @Inject
    public FriendsButton(ComboBoxDecorator comboBoxDecorator, Provider<FriendServiceItem> serviceItemProvider, Provider<BrowseFriendsAction> browseFriendsActionProvider, Provider<LoginAction> loginActionProvider, Provider<LogoutAction> logoutActionProvider, AutoLoginService autoLoginService, EventBean<FriendConnectionEvent> friendConnectionEventBean, AllFriendsRefreshManager allFriendsRefreshManager, ButtonDecorator decorator) {
        this.serviceItemProvider = serviceItemProvider;
        this.browseFriendsActionProvider = browseFriendsActionProvider;
        this.loginActionProvider = loginActionProvider;
        this.logoutActionProvider = logoutActionProvider;
        this.autoLoginService = autoLoginService;
        this.friendConnectionEventBean = friendConnectionEventBean;
        this.allFriendsRefreshManager = allFriendsRefreshManager;
        GuiUtils.assignResources(this);
        this.setText(I18n.tr("Friends"));
        decorator.decorateDropDownHeaderButton(this);
        this.busyPainter = new BusyPainter(){

            @Override
            protected void init(Shape point, Shape trajectory, Color b, Color h) {
                super.init(1.getScaledDefaultPoint(8), 1.getScaledDefaultTrajectory(8), Color.decode("#acacac"), Color.decode("#545454"));
            }
        };
        final Painter<JXButton> originalPainter = this.getForegroundPainter();
        this.setForegroundPainter((Painter<JXButton>)new AbstractPainter<JXButton>(){

            @Override
            protected void doPaint(Graphics2D g, JXButton object, int width, int height) {
                originalPainter.paint(g, object, width, height);
                if (FriendsButton.this.busy != null) {
                    g.translate(26, 16);
                    FriendsButton.this.busyPainter.paint(g, object, width, height);
                    g.translate(-26, -26);
                }
            }
        });
        this.addMouseListener(new ActionHandListener());
        this.menu = new JPopupMenu();
        this.overrideMenuNoRestyle(this.menu);
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                FriendsButton.this.menu.removeAll();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                FriendsButton.this.menu.removeAll();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                FriendsButton.this.populateMenu();
            }
        });
        this.menu.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(1, 1, 3, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                JComponent serviceItem = (JComponent)((JComponent)FriendsButton.this.menu.getComponent(0)).getComponent(0);
                if (!serviceItem.isVisible()) {
                    g.setColor(FriendsButton.this.dividerForeground);
                } else {
                    g.setColor(serviceItem.getBackground());
                }
                int dividerWidth = FriendsButton.this.getWidth() - 2;
                g.drawLine(0, 0, dividerWidth, 0);
                g.setColor(FriendsButton.this.borderForeground);
                g.drawLine(0, 0, 0, height - 1);
                g.drawLine(0, height - 1, width - 1, height - 1);
                g.drawLine(width - 1, height - 1, width - 1, 0);
                g.drawLine(dividerWidth + 1, 0, width - 1, 0);
                g.setColor(FriendsButton.this.borderInsideRightForeground);
                g.drawLine(width - 2, height - 2, width - 2, 1);
                g.drawLine(width - 1, height - 1, width - 1, height - 1);
                g.setColor(FriendsButton.this.borderInsideBottomForeground);
                g.drawLine(1, height - 2, width - 2, height - 2);
                g.drawLine(0, height - 1, 0, height - 1);
            }
        });
        this.setPopupPosition(new Point(0, -1));
    }

    private void populateMenu() {
        JLabel browseFriendMenuItem;
        boolean loggingIn;
        this.menu.add(this.wrapItemForSelection(this.serviceItemProvider.get()));
        FriendConnection friendConnection = (FriendConnection)EventUtils.getSource(this.friendConnectionEventBean);
        boolean signedIn = friendConnection != null && friendConnection.isLoggedIn();
        boolean bl = loggingIn = this.autoLoginService.isAttemptingLogin() || friendConnection != null && friendConnection.isLoggingIn();
        if (signedIn) {
            browseFriendMenuItem = new ActionLabel(this.browseFriendsActionProvider.get());
        } else {
            browseFriendMenuItem = new JLabel(I18n.tr(BrowseFriendsAction.DISPLAY_TEXT));
            browseFriendMenuItem.setEnabled(false);
        }
        this.menu.add(this.decorateItem(browseFriendMenuItem));
        if (this.newResultsAvailable) {
            browseFriendMenuItem.setFont(this.browseNotificationFont);
            browseFriendMenuItem.setIcon(this.browseNotificationIcon);
            browseFriendMenuItem.setIconTextGap(2);
        }
        if (signedIn) {
            this.menu.add(this.decorateItem(new ActionLabel(this.logoutActionProvider.get())));
        } else {
            JLabel loginMenuItem;
            if (loggingIn) {
                loginMenuItem = new JLabel(I18n.tr(LoginAction.DISPLAY_TEXT));
                loginMenuItem.setEnabled(false);
            } else {
                loginMenuItem = new ActionLabel(this.loginActionProvider.get());
            }
            this.menu.add(this.decorateItem(loginMenuItem));
        }
    }

    private JComponent decorateItem(JComponent comp) {
        this.attachListeners(comp);
        comp.setFont(this.menuFont);
        comp.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        if (comp.isEnabled()) {
            comp.setForeground(this.menuForeground);
        }
        return this.wrapItemForSelection(comp);
    }

    private void setIconFromEvent(FriendConnectionEvent event) {
        FriendConnectionEvent.Type eventType;
        FriendConnectionEvent.Type type = eventType = event == null ? null : (FriendConnectionEvent.Type)((Object)event.getType());
        if (eventType == null) {
            eventType = FriendConnectionEvent.Type.DISCONNECTED;
        }
        this.updateIcons(eventType);
    }

    private void updateIcons(FriendConnectionEvent.Type eventType) {
        switch (eventType) {
            case CONNECT_FAILED: 
            case DISCONNECTED: {
                this.newResultsAvailable = false;
                this.setIcon(this.friendOfflineIcon);
                this.setPressedIcon(this.friendOfflineSelectedIcon);
                this.stopAnimation();
                break;
            }
            case CONNECTED: {
                if (this.newResultsAvailable) {
                    this.setIcon(this.friendNewFilesIcon);
                    this.setPressedIcon(this.friendNewFilesSelectedIcon);
                } else {
                    this.setIcon(this.friendOnlineIcon);
                    this.setPressedIcon(this.friendOnlineSelectedIcon);
                }
                this.stopAnimation();
                break;
            }
            case CONNECTING: {
                this.setIcon(this.friendLoadingIcon);
                this.setPressedIcon(this.friendLoadingSelectedIcon);
                this.startAnimation();
            }
        }
    }

    @Inject
    void register(final EventBean<FriendConnectionEvent> connectBean, ListenerSupport<FriendConnectionEvent> connectionSupport) {
        this.setIconFromEvent(connectBean.getLastEvent());
        connectionSupport.addListener(new EventListener<FriendConnectionEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendConnectionEvent event) {
                FriendsButton.this.setIconFromEvent(event);
                FriendsButton.this.refreshMenu();
            }
        });
        this.allFriendsRefreshManager.addBrowseRefreshStatusListener(new BrowseRefreshStatusListener(){

            @Override
            public void statusChanged(BrowseRefreshStatus status) {
                if (status == BrowseRefreshStatus.ADDED || status == BrowseRefreshStatus.CHANGED) {
                    FriendsButton.this.newResultsAvailable = true;
                    SwingUtils.invokeNowOrLater(new Runnable(){

                        @Override
                        public void run() {
                            FriendsButton.this.updateIcons(FriendConnectionEvent.Type.CONNECTED);
                            FriendsButton.this.refreshMenu();
                        }
                    });
                } else if (status == BrowseRefreshStatus.REFRESHED) {
                    FriendsButton.this.newResultsAvailable = false;
                    if (((FriendConnectionEvent)connectBean.getLastEvent()).getType() == FriendConnectionEvent.Type.CONNECTED) {
                        SwingUtils.invokeNowOrLater(new Runnable(){

                            @Override
                            public void run() {
                                FriendsButton.this.updateIcons(FriendConnectionEvent.Type.CONNECTED);
                            }
                        });
                    }
                } else if (status == BrowseRefreshStatus.REMOVED && !FriendsButton.this.allFriendsRefreshManager.hasSharedFiles()) {
                    FriendsButton.this.newResultsAvailable = false;
                    if (((FriendConnectionEvent)connectBean.getLastEvent()).getType() == FriendConnectionEvent.Type.CONNECTED) {
                        SwingUtils.invokeNowOrLater(new Runnable(){

                            @Override
                            public void run() {
                                FriendsButton.this.updateIcons(FriendConnectionEvent.Type.CONNECTED);
                            }
                        });
                    }
                }
            }
        });
    }

    private void startAnimation() {
        if (this.busy != null) {
            this.stopAnimation();
        }
        this.busy = new Timer(100, new ActionListener(){
            int frame;
            {
                this.frame = FriendsButton.this.busyPainter.getPoints();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.frame = (this.frame + 1) % FriendsButton.this.busyPainter.getPoints();
                FriendsButton.this.busyPainter.setFrame(this.frame);
                FriendsButton.this.repaint();
            }
        });
        this.busy.start();
    }

    private void stopAnimation() {
        if (this.busy != null) {
            this.busy.stop();
            this.busyPainter.setFrame(-1);
            this.repaint();
            this.busy = null;
        }
    }

    private void refreshMenu() {
        if (this.menu != null && this.menu.isVisible()) {
            this.menu.setVisible(false);
            this.menu.setVisible(true);
        }
    }
}

