/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;
import org.limewire.ui.swing.settings.SwingUiSettings;

class FramePositioner {
    private WindowState lastState;
    private JFrame frame;

    FramePositioner() {
    }

    void initialize(JFrame frame) {
        assert (this.frame == null) : "already initialized on a frame!";
        this.frame = frame;
        this.listenToWindowPosition();
    }

    void setWindowPosition() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        int appWidth = Math.min(screenSize.width - insets.left - insets.right, SwingUiSettings.APP_WIDTH.getValue());
        int appHeight = Math.min(screenSize.height - insets.top - insets.bottom, SwingUiSettings.APP_HEIGHT.getValue());
        this.frame.setMinimumSize(new Dimension(500, 500));
        this.frame.setSize(new Dimension(appWidth, appHeight));
        if (SwingUiSettings.POSITIONS_SET.getValue()) {
            int locX = Math.max(insets.left, SwingUiSettings.WINDOW_X.getValue());
            int locY = Math.max(insets.top, SwingUiSettings.WINDOW_Y.getValue());
            if (locX + appWidth > screenSize.width) {
                locX = Math.max(insets.left, screenSize.width - insets.left - insets.right - appWidth);
            }
            if (locY + appHeight > screenSize.height) {
                locY = Math.max(insets.top, screenSize.height - insets.top - insets.bottom - appHeight);
            }
            this.frame.setLocation(locX, locY);
        } else {
            this.frame.setLocationRelativeTo(null);
        }
        if (SwingUiSettings.MAXIMIZE_WINDOW.getValue() && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            this.frame.setExtendedState(6);
        }
        this.frame.validate();
    }

    private void listenToWindowPosition() {
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                FramePositioner.this.lastState = new WindowState();
                FramePositioner.this.saveWindowState();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                FramePositioner.this.saveWindowState();
            }
        });
        this.frame.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                FramePositioner.this.saveWindowState();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FramePositioner.this.saveWindowState();
            }
        });
    }

    private void saveWindowState() {
        int state = this.frame.getExtendedState();
        if (state == 0) {
            Dimension dim = this.frame.getSize();
            if (dim.height > 100 && dim.width > 100) {
                Point loc = this.frame.getLocation();
                SwingUiSettings.APP_WIDTH.setValue(dim.width);
                SwingUiSettings.APP_HEIGHT.setValue(dim.height);
                SwingUiSettings.WINDOW_X.setValue(loc.x);
                SwingUiSettings.WINDOW_Y.setValue(loc.y);
                SwingUiSettings.MAXIMIZE_WINDOW.setValue(false);
                SwingUiSettings.POSITIONS_SET.setValue(true);
            }
        } else if ((state & 6) == 6) {
            SwingUiSettings.MAXIMIZE_WINDOW.setValue(true);
            if (this.lastState != null && this.lastState.time == System.currentTimeMillis()) {
                SwingUiSettings.POSITIONS_SET.setValue(true);
                SwingUiSettings.WINDOW_X.setValue(this.lastState.x);
                SwingUiSettings.WINDOW_Y.setValue(this.lastState.y);
                this.lastState = null;
            }
        }
    }

    private static class WindowState {
        private final int x = SwingUiSettings.WINDOW_X.getValue();
        private final int y = SwingUiSettings.WINDOW_Y.getValue();
        private final long time = System.currentTimeMillis();

        WindowState() {
        }
    }
}

