/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jdesktop.application.Resource;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.settings.UploadSettings;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.util.GuiUtils;

@Singleton
public class BottomPanel
extends JPanel {
    @Resource
    private int preferredHeight;
    private final DownloadMediator downloadMediator;
    private final UploadMediator uploadMediator;
    private CardLayout cardLayout;

    @Inject
    public BottomPanel(DownloadMediator downloadMediator, UploadMediator uploadMediator) {
        this.downloadMediator = downloadMediator;
        this.uploadMediator = uploadMediator;
        GuiUtils.assignResources(this);
        this.initializeComponents();
    }

    @Inject
    void register() {
        this.downloadMediator.getDownloadList().addListEventListener(new ListEventListener<DownloadItem>(){

            @Override
            public void listChanged(ListEvent<DownloadItem> listChanges) {
                if (BottomPanel.this.downloadMediator.getDownloadList().size() == 0) {
                    BottomPanel.this.hideWhenNoTransfers();
                }
            }
        });
        this.uploadMediator.getUploadList().addListEventListener(new ListEventListener<UploadItem>(){

            @Override
            public void listChanged(ListEvent<UploadItem> listChanges) {
                if (BottomPanel.this.uploadMediator.getUploadList().size() == 0) {
                    BottomPanel.this.hideWhenNoTransfers();
                }
            }
        });
    }

    private void initializeComponents() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        int savedHeight = SwingUiSettings.BOTTOM_TRAY_SIZE.getValue();
        int height = savedHeight == 0 ? this.preferredHeight : savedHeight;
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, height));
        this.add((Component)this.downloadMediator.getComponent(), TabId.DOWNLOADS.toString());
        this.add((Component)this.uploadMediator.getComponent(), TabId.UPLOADS.toString());
    }

    public int getDefaultPreferredHeight() {
        return this.preferredHeight;
    }

    public void show(TabId tabId) {
        this.cardLayout.show(this, tabId.toString());
    }

    private void hideWhenNoTransfers() {
        if (SwingUiSettings.HIDE_BOTTOM_TRAY_WHEN_NO_TRANSFERS.getValue()) {
            boolean showUploads;
            boolean showDownloads = SwingUiSettings.SHOW_TRANSFERS_TRAY.getValue() && this.downloadMediator.getDownloadList().size() > 0;
            boolean bl = showUploads = SwingUiSettings.SHOW_TRANSFERS_TRAY.getValue() && UploadSettings.SHOW_UPLOADS_IN_TRAY.getValue() && this.uploadMediator.getUploadList().size() > 0;
            if (!showDownloads && !showUploads) {
                SwingUiSettings.SHOW_TRANSFERS_TRAY.setValue(false);
            }
        }
    }

    public static enum TabId {
        DOWNLOADS,
        UPLOADS;

    }
}

