/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.library.table.AbstractLibraryFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;

public class DocumentTableFormat<T extends LocalFileItem>
extends AbstractLibraryFormat<T> {
    static final int NAME_INDEX = 0;
    static final int TYPE_INDEX = 1;
    static final int SIZE_INDEX = 2;
    static final int AUTHOR_INDEX = 3;
    static final int DESCRIPTION_INDEX = 4;
    static final int HIT_INDEX = 5;
    static final int UPLOADS_INDEX = 6;
    static final int UPLOAD_ATTEMPTS_INDEX = 7;
    static final int PATH_INDEX = 8;
    static final int ACTION_INDEX = 9;
    private Provider<IconManager> iconManager;

    @Inject
    public DocumentTableFormat(Provider<IconManager> iconManager) {
        super(9, "LIBRARY_DOCUMENT_TABLE", 0, true, new ColumnStateInfo(0, "LIBRARY_DOCUMENT_NAME", "Name", 480, true, true), new ColumnStateInfo(1, "LIBRARY_DOCUMENT_TYPE", I18n.tr("Type"), 230, true, true), new ColumnStateInfo(2, "LIBRARY_DOCUMENT_SIZE", I18n.tr("Size"), 60, false, true), new ColumnStateInfo(3, "LIBRARY_DOCUMENT_AUTHOR", I18n.tr("Author"), 60, false, true), new ColumnStateInfo(4, "LIBRARY_DOCUMENT_DESCRIPTION", I18n.tr("Description"), 100, false, true), new ColumnStateInfo(5, "LIBRARY_DOCUMENT_HITS", I18n.tr("Hits"), 100, false, true), new ColumnStateInfo(6, "LIBRARY_DOCUMENT_UPLOADS", I18n.tr("Uploads"), 100, false, true), new ColumnStateInfo(7, "LIBRARY_DOCUMENT_UPLOAD_ATTEMPTS", I18n.tr("Upload attempts"), 200, false, true), new ColumnStateInfo(8, "LIBRARY_DOCUMENT_PATH", I18n.tr("Location"), 200, false, true), new ColumnStateInfo(9, "LIBRARY_DOCUMENT_ACTION", I18n.tr(" "), 22, 22, true, false));
        this.iconManager = iconManager;
    }

    @Override
    public Object getColumnValue(T baseObject, int column) {
        switch (column) {
            case 3: {
                return baseObject.getProperty(FilePropertyKey.AUTHOR);
            }
            case 4: {
                return "";
            }
            case 0: {
                return baseObject;
            }
            case 2: {
                return baseObject.getSize();
            }
            case 1: {
                return this.iconManager != null ? this.iconManager.get().getMIMEDescription((PropertiableFile)baseObject) : baseObject.getProperty(FilePropertyKey.DESCRIPTION);
            }
            case 5: {
                return baseObject.getNumHits();
            }
            case 7: {
                return baseObject.getNumUploadAttempts();
            }
            case 6: {
                return baseObject.getNumUploads();
            }
            case 8: {
                return baseObject.getProperty(FilePropertyKey.LOCATION);
            }
            case 9: {
                return baseObject;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + column);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.ASCENDING, 0), new SortKey(SortOrder.ASCENDING, 1), new SortKey(SortOrder.ASCENDING, 2));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        switch (column) {
            case 0: {
                return Arrays.asList(1, 2);
            }
            case 1: {
                return Arrays.asList(0, 2);
            }
            case 2: {
                return Arrays.asList(0, 1);
            }
        }
        return Collections.emptyList();
    }
}

