/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.ui.swing.components.Paintable;
import org.limewire.ui.swing.components.TextFieldClipboardControl;

public class PromptTextField
extends JTextField
implements FocusListener,
Paintable {
    private String promptText;
    private Painter<JTextField> backgroundPainter;
    private Painter<JTextField> promptPainter;
    private Insets paintedInsets;

    public PromptTextField() {
        this.init();
    }

    public PromptTextField(String promptText) {
        this.setPromptText(promptText);
        this.init();
    }

    public PromptTextField(String promptText, int columns) {
        this.promptText = promptText;
        this.setColumns(columns);
        this.init();
    }

    private void init() {
        TextFieldClipboardControl.install(this);
        this.addFocusListener(this);
        this.setMinimumSize(new Dimension(150, 22));
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setPromptText(String text) {
        this.promptText = text;
    }

    public String getPromptText() {
        return this.promptText;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getOppositeComponent() != null && !e.isTemporary()) {
            this.selectAll();
        }
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public Insets getPaintedInsets() {
        return this.backgroundPainter == null ? new Insets(0, 0, 0, 0) : this.paintedInsets;
    }

    public void setBackgroundPainter(Painter<JTextField> painter) {
        this.backgroundPainter = painter;
        if (painter != null) {
            this.paintedInsets = new Insets(1, 1, 1, 1);
        }
    }

    public void setPromptPainter(Painter<JTextField> painter) {
        this.promptPainter = painter;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
        if (this.promptPainter != null && !this.hasFocus() && this.getText().isEmpty() && this.promptText != null) {
            this.promptPainter.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
        }
    }
}

