/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.util.GuiUtils;

public class LimeEditableComboBox
extends JXPanel {
    @Resource
    private int arcWidth;
    @Resource
    private int arcHeight;
    @Resource
    private Color borderColour;
    @Resource
    private Color bevelLeft;
    @Resource
    private Color bevelTop1;
    @Resource
    private Color bevelTop2;
    @Resource
    private Color bevelRight;
    @Resource
    private Color bevelBottom;
    private JTextField inputField;
    private JComboBox comboBox;
    private LimeEditableComboBoxUI comboUI;

    public LimeEditableComboBox() {
        GuiUtils.assignResources(this);
        this.initializeComboBox();
        this.initializePainter();
        this.setOpaque(false);
        this.setLayout(new MigLayout("fill, ins 0 0 0 0 , gap 0! 0!, novisualpadding"));
        this.add((Component)this.comboBox, "gapleft 6, gapright 6, aligny 50%, growx");
    }

    public BasicComboPopup getPopup() {
        return this.comboUI.getPopup();
    }

    public JTextField getTextField() {
        return this.inputField;
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    private void initializeComboBox() {
        this.comboBox = new JComboBox();
        this.initializeInputField();
        this.comboUI = new LimeEditableComboBoxUI();
        this.comboBox.setUI(this.comboUI);
        this.comboBox.setEditor(new ShareComboBoxEditor());
        this.comboBox.setEditable(true);
        this.comboBox.setOpaque(false);
        this.comboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    private void initializeInputField() {
        this.inputField = new JTextField(12);
        this.inputField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.inputField.setOpaque(false);
    }

    private void initializePainter() {
        CompoundPainter compoundPainter = new CompoundPainter();
        RectanglePainter painter = new RectanglePainter();
        painter.setRounded(true);
        painter.setFillPaint(Color.WHITE);
        painter.setRoundWidth(this.arcWidth);
        painter.setRoundHeight(this.arcHeight);
        painter.setInsets(new Insets(2, 2, 2, 2));
        painter.setBorderPaint(null);
        painter.setFillVertical(true);
        painter.setFillHorizontal(true);
        painter.setAntialiasing(true);
        painter.setCacheable(true);
        compoundPainter.setPainters(painter, new BorderPainter(this.arcWidth, this.arcHeight, this.borderColour, this.bevelLeft, this.bevelTop1, this.bevelTop2, this.bevelRight, this.bevelBottom, BorderPainter.AccentType.SHADOW));
        compoundPainter.setCacheable(true);
        this.setBackgroundPainter(compoundPainter);
    }

    private static class LimeEditableComboBoxUI
    extends BasicComboBoxUI {
        @Resource
        private Icon arrowIcon;
        @Resource
        private Icon rolloverArrowIcon;
        @Resource
        private Icon downArrowIcon;
        @Resource
        private Color selectedBackground;
        private final Color selectedForeground = UIManager.getColor("MenuItem.selectionForeground");

        public LimeEditableComboBoxUI() {
            GuiUtils.assignResources(this);
        }

        public BasicComboPopup getPopup() {
            return (BasicComboPopup)this.popup;
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup comboPopup = new BasicComboPopup(this.comboBox);
            comboPopup.getList().setSelectionBackground(this.selectedBackground);
            comboPopup.getList().setSelectionForeground(this.selectedForeground);
            return comboPopup;
        }

        @Override
        protected JButton createArrowButton() {
            IconButton button = new IconButton(this.arrowIcon, this.rolloverArrowIcon, this.downArrowIcon);
            button.setName("ComboBox.arrowButton");
            return button;
        }
    }

    private class ShareComboBoxEditor
    implements ComboBoxEditor {
        private ShareComboBoxEditor() {
        }

        @Override
        public Component getEditorComponent() {
            return LimeEditableComboBox.this.inputField;
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public Object getItem() {
            return null;
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void setItem(Object anObject) {
        }
    }
}

