/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.animate;

import javax.swing.JWindow;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.ui.swing.animate.Animator;
import org.limewire.ui.swing.animate.AnimatorEvent;
import org.limewire.ui.swing.animate.FadeInAnimator;
import org.limewire.ui.swing.animate.FadeOutAnimator;

public class FadeInOutAnimator
implements Animator<JWindow>,
EventListener<AnimatorEvent<JWindow>> {
    private final EventListenerList<AnimatorEvent<JWindow>> eventListenerList;
    private final FadeInAnimator fadeInAnimator;
    private final FadeOutAnimator fadeOutAnimator;
    private final JWindow window;

    public FadeInOutAnimator(JWindow window, int fadeIn, int pauseTime, int fadeOut) {
        this.window = window;
        this.eventListenerList = new EventListenerList();
        this.fadeInAnimator = new FadeInAnimator(window, fadeIn);
        this.fadeInAnimator.addListener((EventListener)this);
        this.fadeOutAnimator = new FadeOutAnimator(window, fadeOut);
        this.fadeOutAnimator.setInitialDelay(pauseTime);
        this.fadeOutAnimator.addListener((EventListener)this);
    }

    @Override
    public int getTotalNumberOfSteps() {
        return 0;
    }

    @Override
    public void setInitialDelay(int initialDelay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start() {
        this.fadeInAnimator.start();
        this.eventListenerList.broadcast(new AnimatorEvent<JWindow>(this, AnimatorEvent.Type.STARTED));
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(EventListener<AnimatorEvent<JWindow>> listener) {
        this.eventListenerList.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<AnimatorEvent<JWindow>> listener) {
        return this.eventListenerList.removeListener(listener);
    }

    @Override
    public void handleEvent(AnimatorEvent<JWindow> event) {
        if (event.getType() == AnimatorEvent.Type.STOPPED && event.getAnimator() == this.fadeInAnimator) {
            this.fadeOutAnimator.start();
        } else if (event.getType() == AnimatorEvent.Type.STOPPED && event.getAnimator() == this.fadeOutAnimator) {
            this.eventListenerList.broadcast(new AnimatorEvent<JWindow>(this, AnimatorEvent.Type.STOPPED));
        }
    }

    @Override
    public JWindow getComponent() {
        return this.window;
    }

    @Override
    public int getCurrentStepNumber() {
        return 0;
    }
}

