/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced.connection;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.io.NetworkUtils;
import org.limewire.ui.swing.components.DropDownListAutoCompleteControl;
import org.limewire.ui.swing.components.NumericTextField;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.util.I18n;

public class AddConnectionPanel
extends JPanel {
    private GnutellaConnectionManager gnutellaConnectionManager;
    private Action addAction = new AddAction();
    private JLabel titleLabel = new JLabel();
    private JLabel hostLabel = new JLabel();
    private JLabel portLabel = new JLabel();
    private JTextField hostTextField = new JTextField(20);
    private NumericTextField portTextField = new NumericTextField(4, 1, 65535);
    private JCheckBox tlsCheckBox = new JCheckBox();
    private JButton addButton = new JButton();

    @Inject
    public AddConnectionPanel(GnutellaConnectionManager gnutellaConnectionManager) {
        this.gnutellaConnectionManager = gnutellaConnectionManager;
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setLayout(new MigLayout("insets 0 0 0 0", "[left][left]", "[top]12[top]6[top][top][bottom]"));
        this.setOpaque(false);
        this.titleLabel.setText(I18n.tr("Add a Connection"));
        this.hostLabel.setText(I18n.tr("Host"));
        this.hostTextField.setMinimumSize(new Dimension(105, 21));
        this.hostTextField.setPreferredSize(new Dimension(105, 21));
        this.hostTextField.addActionListener(this.addAction);
        this.hostTextField.getDocument().addDocumentListener(new HostNameListener());
        this.portLabel.setText(I18n.tr("Port"));
        this.portTextField.setMinimumSize(new Dimension(60, 21));
        this.portTextField.setPreferredSize(new Dimension(60, 21));
        this.portTextField.setValue(6346);
        this.portTextField.addActionListener(this.addAction);
        DropDownListAutoCompleteControl.install(this.hostTextField);
        TextFieldClipboardControl.install(this.hostTextField);
        TextFieldClipboardControl.install(this.portTextField);
        this.tlsCheckBox.setText(I18n.tr("Use TLS"));
        this.tlsCheckBox.setOpaque(false);
        this.addButton.setText(I18n.tr("Add"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(this.addAction);
        this.add((Component)this.titleLabel, "cell 0 0 2 1");
        this.add((Component)this.hostLabel, "cell 0 1,gaptop 3");
        this.add((Component)this.hostTextField, "cell 1 1");
        this.add((Component)this.portLabel, "cell 0 2,gaptop 3");
        this.add((Component)this.portTextField, "cell 1 2");
        this.add((Component)this.tlsCheckBox, "cell 0 3 2 1");
        this.add((Component)this.addButton, "cell 1 4,right");
    }

    public void resetInput() {
        this.hostTextField.setText(null);
        this.portTextField.setText(null);
        this.tlsCheckBox.setSelected(false);
    }

    private class HostNameListener
    implements DocumentListener {
        private HostNameListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AddConnectionPanel.this.addButton.setEnabled(e.getDocument().getLength() > 0);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AddConnectionPanel.this.addButton.setEnabled(e.getDocument().getLength() > 0);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AddConnectionPanel.this.addButton.setEnabled(e.getDocument().getLength() > 0);
        }
    }

    private class AddAction
    extends AbstractAction {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int portnum;
            String hostnamestr = AddConnectionPanel.this.hostTextField.getText();
            int idx = hostnamestr.lastIndexOf(58);
            if (idx != -1) {
                AddConnectionPanel.this.portTextField.setText(hostnamestr.substring(idx + 1));
                AddConnectionPanel.this.hostTextField.setText(hostnamestr.substring(0, idx));
                hostnamestr = AddConnectionPanel.this.hostTextField.getText();
            }
            if (!NetworkUtils.isValidPort(portnum = AddConnectionPanel.this.portTextField.getValue(6346))) {
                portnum = 6346;
            }
            AddConnectionPanel.this.portTextField.setValue(portnum);
            if (hostnamestr.trim().length() > 0) {
                AddConnectionPanel.this.gnutellaConnectionManager.tryConnection(hostnamestr, portnum, AddConnectionPanel.this.tlsCheckBox.isSelected());
                AddConnectionPanel.this.resetInput();
            } else {
                AddConnectionPanel.this.hostTextField.requestFocusInWindow();
            }
        }
    }
}

