/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.action;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.limewire.concurrent.FutureEvent;
import org.limewire.core.api.Application;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.HTMLPane;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.ui.swing.util.ResizeUtils;

public class UrlAction
extends AbstractAction {
    private final LaunchType type;
    private final String url;
    private final String title;
    private final GetParamAppender getParamAppender;

    public UrlAction(String url, LaunchType type, GetParamAppender getParamAppender) {
        this(url, url, null, type, getParamAppender);
    }

    public UrlAction(String url, String title, GetParamAppender getParamAppender) {
        this(url, url, title, LaunchType.POPUP, getParamAppender);
    }

    public UrlAction(String url) {
        this(url, url, null, LaunchType.EXTERNAL_BROWSER, null);
    }

    public UrlAction(String url, Application application) {
        this(url, url, application);
    }

    public UrlAction(String name, String url, final Application application) {
        this(name, url, null, LaunchType.EXTERNAL_BROWSER, new GetParamAppender(){

            @Override
            public String appendParams(String original) {
                return application.addClientInfoToUrl(original);
            }
        });
    }

    public UrlAction(String name, String url) {
        this(name, url, null, LaunchType.EXTERNAL_BROWSER, null);
    }

    public UrlAction(String name, String url, LaunchType type) {
        this(name, url, null, type, null);
    }

    public UrlAction(String name, String url, String title, LaunchType type, GetParamAppender getParamAppender) {
        super(name);
        this.url = url;
        this.type = type;
        this.title = title;
        this.getParamAppender = getParamAppender;
        this.putValue("ShortDescription", url);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String urlToShow = this.url;
        if (this.getParamAppender != null) {
            urlToShow = this.getParamAppender.appendParams(urlToShow);
        }
        if (this.type == LaunchType.EXTERNAL_BROWSER) {
            NativeLaunchUtils.openURL(urlToShow);
        } else {
            UrlAction.showPopup(urlToShow, this.title);
        }
    }

    private static void showPopup(final String urlToShow, final String title) {
        new LimeJDialog(){
            {
                this.getContentPane().setLayout(new BorderLayout());
                HTMLPane browser = new HTMLPane();
                browser.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            NativeLaunchUtils.openURL(e.getURL().toString());
                        }
                    }
                });
                JScrollPane scrollPane = new JScrollPane(browser, 20, 30);
                this.getContentPane().add(scrollPane);
                ResizeUtils.forceSize(this, new Dimension(600, 400));
                this.setTitle(title);
                this.setModal(true);
                this.setResizable(true);
                this.setAlwaysOnTop(true);
                this.getContentPane();
                this.pack();
                this.setLocationRelativeTo(null);
                browser.setPageAsynchronous(urlToShow, null).addFutureListener(new EventListener<FutureEvent<HTMLPane.LoadResult>>(){

                    @Override
                    @SwingEDTEvent
                    public void handleEvent(FutureEvent<HTMLPane.LoadResult> event) {
                        if (event.getResult() != HTMLPane.LoadResult.SERVER_PAGE) {
                            this.dispose();
                            NativeLaunchUtils.openURL(urlToShow);
                        }
                    }
                });
                this.setDefaultCloseOperation(2);
                this.setVisible(true);
            }
        };
    }

    public static interface GetParamAppender {
        public String appendParams(String var1);
    }

    public static enum LaunchType {
        EXTERNAL_BROWSER,
        POPUP;

    }
}

