/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.support;

import javax.swing.SwingUtilities;
import org.limewire.service.ErrorCallback;
import org.limewire.ui.support.BugManager;

public final class ErrorHandler
implements ErrorCallback {
    private final BugManager bugManager;

    public ErrorHandler(BugManager bugManager) {
        this.bugManager = bugManager;
    }

    @Override
    public void error(Throwable problem) {
        this.error(problem, null);
    }

    @Override
    public void error(Throwable problem, String msg) {
        if (problem instanceof ThreadDeath) {
            throw (ThreadDeath)problem;
        }
        SwingUtilities.invokeLater(new Error(problem, msg));
    }

    private class Error
    implements Runnable {
        private final Throwable PROBLEM;
        private final String MESSAGE;
        private final String CURRENT_THREAD_NAME;

        private Error(Throwable problem, String msg) {
            this.PROBLEM = problem;
            this.MESSAGE = msg;
            this.CURRENT_THREAD_NAME = Thread.currentThread().getName();
        }

        @Override
        public void run() {
            try {
                ErrorHandler.this.bugManager.handleBug(this.PROBLEM, this.CURRENT_THREAD_NAME, this.MESSAGE);
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
    }
}

