/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntHashMap;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.RouteTableSettings;
import org.limewire.mojito.util.ContactUtils;

public class ClassfulNetworkCounter
implements Serializable {
    private static final long serialVersionUID = -6603762323364585225L;
    private static final Log LOG = LogFactory.getLog(ClassfulNetworkCounter.class);
    private final IntHashMap<AtomicInteger> nodesPerNetwork = new IntHashMap();
    private final Bucket bucket;

    public ClassfulNetworkCounter(Bucket bucket) {
        this.bucket = bucket;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public synchronized int get(Contact node) {
        if (this.bucket.isLocalNode(node)) {
            return 0;
        }
        if (!ContactUtils.isIPv4Address(node)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(node + " has not an IPv4 Address");
            }
            return 0;
        }
        int masked = ContactUtils.getClassC(node);
        AtomicInteger counter = this.nodesPerNetwork.get(masked);
        if (counter != null) {
            return counter.get();
        }
        return 0;
    }

    public synchronized int incrementAndGet(Contact node) {
        if (this.bucket.isLocalNode(node)) {
            return 0;
        }
        if (!ContactUtils.isIPv4Address(node)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(node + " has not an IPv4 Address");
            }
            return 0;
        }
        int masked = ContactUtils.getClassC(node);
        AtomicInteger counter = this.nodesPerNetwork.get(masked);
        if (counter == null) {
            assert (this.nodesPerNetwork.size() < this.bucket.getMaxActiveSize()) : this.nodesPerNetwork.size() + " < " + this.bucket.getMaxActiveSize() + node + ", " + this.nodesPerNetwork + ", " + this.bucket;
            counter = new AtomicInteger(0);
            this.nodesPerNetwork.put(masked, counter);
        }
        return counter.incrementAndGet();
    }

    public synchronized int decrementAndGet(Contact node) {
        if (this.bucket.isLocalNode(node)) {
            return 0;
        }
        if (!ContactUtils.isIPv4Address(node)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(node + " has not an IPv4 Address");
            }
            return 0;
        }
        int masked = ContactUtils.getClassC(node);
        AtomicInteger counter = this.nodesPerNetwork.get(masked);
        if (counter != null) {
            int count = counter.decrementAndGet();
            if (count <= 0) {
                this.nodesPerNetwork.remove(masked);
                assert (!this.nodesPerNetwork.containsKey(masked));
            }
            return count;
        }
        return 0;
    }

    public synchronized int size() {
        return this.nodesPerNetwork.size();
    }

    public synchronized void clear() {
        this.nodesPerNetwork.clear();
    }

    public synchronized boolean isOkayToAdd(Contact node) {
        float count = this.get(node);
        if (count == 0.0f) {
            return true;
        }
        assert (!this.bucket.isLocalNode(node));
        assert (ContactUtils.isIPv4Address(node));
        float maxRatio = RouteTableSettings.MAX_CONTACTS_PER_NETWORK_CLASS_RATIO.getValue();
        if (maxRatio >= 1.0f) {
            return true;
        }
        float k = this.bucket.getMaxActiveSize();
        float ratio = count / k;
        return ratio < maxRatio;
    }

    public synchronized String toString() {
        return this.nodesPerNetwork.toString();
    }
}

