/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.impl.AbstractResponseMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

public class StatsResponseImpl
extends AbstractResponseMessage
implements StatsResponse {
    private final byte[] statistics;

    public StatsResponseImpl(Context context, Contact contact, MessageID messageId, byte[] statistics) {
        super(context, DHTMessage.OpCode.STATS_RESPONSE, contact, messageId, Version.ZERO);
        this.statistics = statistics;
    }

    public StatsResponseImpl(Context context, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        super(context, DHTMessage.OpCode.STATS_RESPONSE, src, messageId, msgVersion, in);
        byte[] s = in.readStatistics();
        ByteArrayInputStream bais = new ByteArrayInputStream(s);
        GZIPInputStream gz = new GZIPInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(s.length * 2);
        byte[] b = new byte[2048];
        int len = -1;
        while ((len = gz.read(b)) != -1) {
            baos.write(b, 0, len);
        }
        gz.close();
        baos.close();
        this.statistics = baos.toByteArray();
    }

    @Override
    public byte[] getStatistics() {
        return this.statistics;
    }

    @Override
    protected void writeBody(MessageOutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gz = new GZIPOutputStream(baos);
        gz.write(this.statistics);
        gz.close();
        byte[] s = baos.toByteArray();
        out.writeStatistics(s);
    }

    public String toString() {
        try {
            return "StatsResponse: " + new String(this.statistics, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException err) {
            throw new RuntimeException(err);
        }
    }
}

