/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inspection;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.InspectionException;
import org.limewire.inspection.InspectionUtils;
import org.limewire.inspection.Inspector;

@Singleton
public class InspectorImpl
implements Inspector {
    private static Log LOG = LogFactory.getLog(InspectorImpl.class);
    private volatile Properties props;
    private volatile Injector injector;
    private final AtomicBoolean loading = new AtomicBoolean(false);

    @Inject
    InspectorImpl(Injector injector) {
        this.injector = injector;
    }

    @Override
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    @Override
    public Object inspect(String key, boolean collectUsageData) throws InspectionException {
        String target = this.props == null || !this.props.containsKey(key) ? key : this.props.getProperty(key);
        return InspectionUtils.inspectValue(target, this.injector, collectUsageData);
    }

    @Override
    public boolean loaded() {
        return this.props != null && !this.props.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File props) {
        if (this.loading.getAndSet(true)) {
            return;
        }
        BufferedReader in = null;
        Properties p = new Properties();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(props), Charset.forName("UTF-8")));
            String current = null;
            while ((current = in.readLine()) != null) {
                String[] k = current.split("=");
                if (k.length != 2) continue;
                p.setProperty(k[0], k[1]);
            }
            this.props = p;
        }
        catch (IllegalArgumentException ignored) {
            LOG.trace("illegal argument", ignored);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            LOG.trace("index out of bounds", sioobe);
        }
        catch (IOException iox) {
            LOG.trace("IO", iox);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

