/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.concurrent.ManagedThread;
import org.limewire.concurrent.ThreadPoolListeningExecutor;
import org.limewire.util.Objects;

public class ExecutorsHelper {
    public static ListeningExecutorService newProcessingQueue(String name) {
        return ExecutorsHelper.newProcessingQueue(ExecutorsHelper.daemonThreadFactory(name));
    }

    public static ListeningExecutorService newProcessingQueue(ThreadFactory factory) {
        return ExecutorsHelper.unconfigurableExecutorService(ExecutorsHelper.newSingleThreadExecutor(factory));
    }

    public static ThreadPoolListeningExecutor newSingleThreadExecutor(ThreadFactory factory) {
        ThreadPoolListeningExecutor tpe = new ThreadPoolListeningExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    public static ListeningExecutorService newThreadPool(String name) {
        return ExecutorsHelper.unconfigurableExecutorService(new ThreadPoolListeningExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ExecutorsHelper.daemonThreadFactory(name)));
    }

    public static ListeningExecutorService newThreadPool(ThreadFactory factory) {
        return ExecutorsHelper.unconfigurableExecutorService(new ThreadPoolListeningExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory));
    }

    public static ListeningExecutorService newFixedSizeThreadPool(int size, String name) {
        ThreadPoolListeningExecutor tpe = new ThreadPoolListeningExecutor(size, size, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorsHelper.daemonThreadFactory(name));
        tpe.allowCoreThreadTimeOut(true);
        return ExecutorsHelper.unconfigurableExecutorService(tpe);
    }

    public static ListeningExecutorService unconfigurableExecutorService(ListeningExecutorService es) {
        return new DelegatedExecutorService(Objects.nonNull(es, "es"));
    }

    public static ThreadFactory defaultThreadFactory(String name) {
        return new DefaultThreadFactory(name, false);
    }

    public static ThreadFactory daemonThreadFactory(String name) {
        return new DefaultThreadFactory(name, true);
    }

    private static class DelegatedExecutorService
    extends AbstractExecutorService
    implements ListeningExecutorService {
        private final ListeningExecutorService e;

        DelegatedExecutorService(ListeningExecutorService executor) {
            this.e = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.e.execute(command);
        }

        @Override
        public void shutdown() {
            this.e.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.e.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.awaitTermination(timeout, unit);
        }

        @Override
        public ListeningFuture<?> submit(Runnable task) {
            return this.e.submit(task);
        }

        @Override
        public <T> ListeningFuture<T> submit(Callable<T> task) {
            return this.e.submit(task);
        }

        @Override
        public <T> ListeningFuture<T> submit(Runnable task, T result) {
            return this.e.submit(task, result);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.e.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(tasks, timeout, unit);
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final String name;
        private final boolean daemon;

        public DefaultThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            ManagedThread t = new ManagedThread(r, this.name);
            if (this.daemon) {
                t.setDaemon(true);
            }
            return t;
        }
    }
}

