/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.tag;

import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.tag.AsfTagField;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.tag.TagTextField;

public class AsfTagTextField
extends AsfTagField
implements TagTextField {
    public AsfTagTextField(ContentDescriptor source) {
        super(source);
        if (source.getType() == 1) {
            throw new IllegalArgumentException("Cannot interpret binary as string.");
        }
    }

    public AsfTagTextField(String fieldKey, String value) {
        super(new ContentDescriptor(fieldKey, 0));
        this.setContent(value);
    }

    @Override
    public String getContent() {
        return this.getDescriptor().getString();
    }

    @Override
    public String getEncoding() {
        return AsfHeader.ASF_CHARSET.name();
    }

    @Override
    public void setContent(String content) {
        this.getDescriptor().setStringValue(content);
    }

    @Override
    public void setEncoding(String encoding) {
        if (!AsfHeader.ASF_CHARSET.name().equals(encoding)) {
            throw new IllegalArgumentException("Only UTF-16LE is possible with ASF.");
        }
    }

    @Override
    public boolean isEmpty() {
        return Utils.isBlank(this.getContent());
    }
}

