/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.qt.media.content.unknown;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.gui.controlpanelfactory.ControlPanelFactorySingleton;
import net.sf.fmj.qt.media.content.unknown.QTGainControl;
import net.sf.fmj.utility.LoggerSingleton;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTFactory;
import quicktime.app.view.QTJComponent;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.std.StdQTException;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.AudioMediaHandler;
import quicktime.std.movies.media.Media;
import quicktime.std.movies.media.MediaHandler;
import quicktime.std.movies.media.VisualMediaHandler;

public class Handler
extends AbstractPlayer {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private static final boolean TRACE = true;
    private Movie movie;
    private QTJComponent movieComponent = null;

    public void createNewMovieFromURL(String theURL) throws QTException {
        logger.fine(theURL);
        String path = theURL.replace("file:///", "");
        QTFile file = new QTFile(path);
        OpenMovieFile movieFile = OpenMovieFile.asRead((QTFile)file);
        this.movie = Movie.fromFile((OpenMovieFile)movieFile);
        boolean hasAudio = false;
        boolean hasVideo = false;
        for (int i = 1; i <= this.movie.getTrackCount(); ++i) {
            Track track = this.movie.getTrack(i);
            Media media = track.getMedia();
            MediaHandler mediaHandler = media.getHandler();
            if (mediaHandler instanceof AudioMediaHandler) {
                hasAudio = true;
            }
            if (!(mediaHandler instanceof VisualMediaHandler)) continue;
            hasVideo = true;
        }
        if (hasAudio) {
            this.setGainControl(new QTGainControl(this.movie));
        }
        if (!hasVideo) {
            throw new QTException("The video file does not have a readable video part!!!");
        }
        if (this.movieComponent == null) {
            this.movieComponent = QTFactory.makeQTJComponent((MoviePlayer)new MoviePlayer(this.movie));
        } else {
            this.movieComponent.setMoviePlayer(new MoviePlayer(this.movie));
        }
        this.movie.start();
    }

    private void registerStopTriggerNotification() throws QTException {
    }

    public void setSource(DataSource source) throws IncompatibleSourceException {
        logger.fine("DataSource: " + source);
        try {
            QTSession.open();
            this.createNewMovieFromURL(source.getLocator().toExternalForm());
        }
        catch (QTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            throw new IncompatibleSourceException();
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new IncompatibleSourceException();
        }
        super.setSource(source);
    }

    public void doPlayerClose() {
        logger.info("Handler.doPlayerClose");
        try {
            this.movie.stop();
        }
        catch (StdQTException e) {
            // empty catch block
        }
        QTSession.exitMovies();
        try {
            QTSession.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean doPlayerDeallocate() {
        logger.info("Handler.doPlayerDeallocate");
        if (this.movieComponent != null) {
            super.setVisualComponent(null);
            this.movieComponent = null;
        }
        if (this.movie != null) {
            this.movie = null;
        }
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    public boolean doPlayerRealize() {
        return true;
    }

    public void doPlayerSetMediaTime(Time t) {
        logger.info("Handler.doPlayerSetMediaTime (sec): " + t.getSeconds());
        try {
            this.movie.setTime(new TimeRecord(this.movie.getTimeScale(), (long)(t.getSeconds() * (double)this.movie.getTimeScale())));
        }
        catch (StdQTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
        }
        catch (QTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
        }
    }

    public float doPlayerSetRate(float rate) {
        logger.fine("Handler.doPlayerSetRate " + rate);
        try {
            return rate;
        }
        catch (StdQTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            return this.getRate();
        }
    }

    public boolean doPlayerStop() {
        logger.info("Handler.doPlayerStop");
        try {
            if (this.movie != null) {
                this.movie.stop();
            }
        }
        catch (QTException err) {
            logger.log(Level.WARNING, "" + (Object)((Object)err), err);
            return false;
        }
        return true;
    }

    public boolean doPlayerSyncStart(Time t) {
        logger.info("Handler.doPlayerSyncStart (sec): " + t.getSeconds());
        try {
            this.registerStopTriggerNotification();
            this.movie.start();
        }
        catch (QTException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
            return false;
        }
        return true;
    }

    public Time getPlayerDuration() {
        if (this.getState() < 300) {
            return DURATION_UNKNOWN;
        }
        if (this.movie != null) {
            try {
                double totalSeconds = (double)this.movie.getDuration() / (double)this.movie.getTimeScale();
                return new Time(totalSeconds);
            }
            catch (StdQTException e) {
                logger.log(Level.WARNING, "" + (Object)((Object)e), e);
                return DURATION_UNKNOWN;
            }
        }
        return DURATION_UNKNOWN;
    }

    public synchronized Time getMediaTime() {
        if (this.getState() < 300) {
            return super.getMediaTime();
        }
        if (this.movie != null) {
            try {
                double totalSeconds = (double)this.movie.getTime() / (double)this.movie.getTimeScale();
                return new Time(totalSeconds);
            }
            catch (StdQTException e) {
                logger.log(Level.WARNING, "" + (Object)((Object)e), e);
                return super.getMediaTime();
            }
        }
        return super.getMediaTime();
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        assert (this.movieComponent != null);
        return this.movieComponent.asJComponent();
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = ControlPanelFactorySingleton.getInstance().getControlPanelComponent(this);
            this.setControlPanelComponent(c);
        }
        return c;
    }
}

