/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.mf.media.content.unknown;

import java.util.ArrayList;
import java.util.List;
import javax.media.IncompatibleSourceException;
import net.sf.fmj.utility.ExceptionUtils;

class MFPlayer {
    static final int ERROR = -1;
    static final int LOADED = 0;
    static final int STARTED = 1;
    static final int ENDED = 2;
    private volatile boolean statusUpdated = false;
    private final Object lock = new Object();
    private volatile int lastStatus;
    private final List<MFPlayerListener> listeners = new ArrayList<MFPlayerListener>();
    private static MFPlayer instance;

    public static synchronized MFPlayer getInstance() throws IncompatibleSourceException {
        if (instance == null) {
            try {
                System.loadLibrary("JMediaFoundation");
            }
            catch (Throwable e) {
                throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
            }
            instance = new MFPlayer();
            try {
                int hr = instance.initialize();
                if (hr < 0) {
                    instance = null;
                    throw new IncompatibleSourceException("MFPlayer native initialization failed");
                }
            }
            catch (Throwable e) {
                instance = null;
                throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
            }
        }
        return instance;
    }

    private MFPlayer() {
    }

    public native int startPlayer(String var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int synchStartPlayer(String url, long hWnd) {
        Object object = this.lock;
        synchronized (object) {
            this.statusUpdated = false;
            this.lastStatus = -1;
            int hr = this.startPlayer(url, hWnd);
            if (hr < 0) {
                return hr;
            }
            try {
                while (!this.statusUpdated) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.lastStatus == -1) {
                this.killPlayer();
                return -1;
            }
            return 0;
        }
    }

    public native void killPlayer();

    public native int getNativeSize(long[] var1);

    public native void update();

    public native int pause();

    public native int resume();

    public native int setPosition(long var1);

    public native int getPosition(long[] var1);

    public native int getDuration(long[] var1);

    public native int setVolume(float var1);

    public native int getVolume(float[] var1);

    private native int initialize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statusChanged(int status) {
        Object object = this.lock;
        synchronized (object) {
            this.statusUpdated = true;
            this.lastStatus = status;
            this.lock.notifyAll();
        }
        this.fireStatusChanged(status);
    }

    private synchronized void fireStatusChanged(int status) {
        for (MFPlayerListener listener : this.listeners) {
            listener.statusChanged(status);
        }
    }

    public synchronized void addMFPlayerListener(MFPlayerListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeMFPlayerListener(MFPlayerListener listener) {
        this.listeners.remove(listener);
    }

    static interface MFPlayerListener {
        public void statusChanged(int var1);
    }
}

