/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;

public class RawPullStreamParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("raw")};
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    public void start() throws IOException {
        this.source.start();
        PullSourceStream[] streams = this.source.getStreams();
        this.tracks = new PullSourceStreamTrack[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            this.tracks[i] = new PullSourceStreamTrack(streams[i]);
        }
    }

    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    private class PullSourceStreamTrack
    extends AbstractTrack {
        private final PullSourceStream stream;

        public PullSourceStreamTrack(PullSourceStream stream) {
            this.stream = stream;
        }

        public Format getFormat() {
            return this.stream.getContentDescriptor();
        }

        public void readFrame(Buffer buffer) {
            int BUFFER_SIZE = 10000;
            if (buffer.getData() == null) {
                buffer.setData(new byte[10000]);
            }
            byte[] bytes = (byte[])buffer.getData();
            try {
                int result = this.stream.read(bytes, 0, bytes.length);
                if (result < 0) {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    return;
                }
                buffer.setLength(result);
                buffer.setOffset(0);
            }
            catch (IOException e) {
                buffer.setEOM(true);
                buffer.setDiscard(true);
                buffer.setLength(0);
                logger.log(Level.WARNING, "" + e, e);
            }
        }
    }
}

