/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.gsm;

import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractPacketizer;
import net.sf.fmj.utility.LoggerSingleton;

public class Packetizer
extends AbstractPacketizer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final int PACKET_SIZE = 495;
    protected Format[] outputFormats = new Format[]{new AudioFormat("gsm/rtp", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray)};

    public String getName() {
        return "GSM Packetizer";
    }

    public Packetizer() {
        this.inputFormats = new Format[]{new AudioFormat("gsm", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray)};
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat inputCast = (AudioFormat)input;
        if (!inputCast.getEncoding().equals("gsm") || inputCast.getSampleSizeInBits() != 8 && inputCast.getSampleSizeInBits() != -1 || inputCast.getChannels() != 1 && inputCast.getChannels() != -1 || inputCast.getFrameSizeInBits() != 264 && inputCast.getFrameSizeInBits() != -1) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat result = new AudioFormat("gsm/rtp", inputCast.getSampleRate(), 8, 1, inputCast.getEndian(), inputCast.getSigned(), 264, inputCast.getFrameRate(), inputCast.getDataType());
        return new Format[]{result};
    }

    public void open() {
        this.setPacketSize(495);
    }

    public void close() {
    }

    public Format setInputFormat(Format arg0) {
        return super.setInputFormat(arg0);
    }

    public Format setOutputFormat(Format arg0) {
        return super.setOutputFormat(arg0);
    }
}

