/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.fmj.ejmf.toolkit.gui.controls.ProgressBar;

public class ProgressSlider
extends Canvas
implements ProgressBar {
    private static final int DEFAULT_THUMB_WIDTH = 6;
    private static final int DEFAULT_THUMB_HEIGHT = 12;
    private int sliderLen = this.max - this.min;
    private int value = this.sliderLen / 2;
    private int max = 100;
    private int min = 0;
    private Rectangle thumbRect;
    private boolean dragOn = false;
    private boolean isOperational = true;
    private EventListenerList listenerList = null;
    private Object[] listeners;

    public ProgressSlider() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                if (ProgressSlider.this.thumbRect.contains(p)) {
                    ProgressSlider.this.startDrag(p);
                }
            }

            public void mouseReleased(MouseEvent e) {
                ProgressSlider.this.endDrag(e.getPoint());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (!ProgressSlider.this.dragOn) {
                    return;
                }
                Point p = e.getPoint();
                ProgressSlider.this.setValue(p.x);
                ProgressSlider.access$202(ProgressSlider.this, ProgressSlider.this.listenerList.getListenerList());
                for (int i = ProgressSlider.this.listeners.length - 2; i >= 0; i -= 2) {
                    if (ProgressSlider.this.listeners[i] != ChangeListener.class) continue;
                    ((ChangeListener)ProgressSlider.this.listeners[i + 1]).stateChanged(new ChangeEvent(ProgressSlider.this));
                }
            }
        });
    }

    void startDrag(Point p) {
        this.dragOn = true;
    }

    void endDrag(Point p) {
        this.dragOn = false;
    }

    public void paint(Graphics g) {
        this.thumbRect = this.computeThumbRectangle();
        int thumbWidth = this.thumbRect.width;
        int thumbHeight = this.thumbRect.height;
        int offset = thumbWidth / 2;
        int drawAt = this.value + offset;
        Color oldColor = g.getColor();
        g.drawLine(0, 5, this.sliderLen + thumbWidth, 5);
        g.drawLine(0, 6, this.sliderLen + thumbWidth, 6);
        g.setColor(this.getBackground().brighter());
        g.drawLine(0, 7, this.sliderLen + thumbWidth, 7);
        g.drawLine(this.sliderLen + thumbWidth, 5, this.sliderLen + thumbWidth, 7);
        this.thumbRect.setLocation(drawAt - offset, 0);
        g.translate(drawAt - offset, 0);
        this.paintThumb(g);
        g.setColor(oldColor);
        g.translate(-(drawAt - offset), 0);
    }

    public void paintThumb(Graphics g) {
        this.thumbRect = this.computeThumbRectangle();
        int thumbHeight = this.thumbRect.height;
        int thumbWidth = this.thumbRect.width;
        g.setColor(this.getBackground().brighter());
        g.drawLine(0, 0, 0, thumbHeight);
        g.setColor(this.getBackground());
        for (int i = 1; i < thumbWidth; ++i) {
            g.drawLine(i, 0, i, thumbHeight);
        }
        g.setColor(UIManager.getColor("controlDkShadow"));
        g.drawLine(thumbWidth, 0, thumbWidth, thumbHeight);
        g.drawLine(1, thumbHeight - 1, thumbWidth, thumbHeight - 1);
        g.setColor(this.getBackground().brighter());
        g.drawLine(0, 0, thumbWidth - 1, 0);
    }

    public Rectangle getThumbRect() {
        return this.thumbRect;
    }

    public Rectangle computeThumbRectangle() {
        return new Rectangle(new Point(this.value - 3, 0), new Dimension(6, 12));
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.sliderLen + 6 + 1, 12);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max) {
            value = this.max;
        }
        this.value = value;
        this.repaint();
    }

    public void setMaximum(int value) {
        this.max = value;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMinimum(int value) {
        this.min = value;
    }

    public int getMinimum() {
        return this.min;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(ChangeListener.class, l);
    }

    static /* synthetic */ Object[] access$202(ProgressSlider x0, Object[] x1) {
        x0.listeners = x1;
        return x1;
    }
}

