/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ds.media.content.unknown;

import com.sun.jna.Native;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Duration;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.swing.SwingUtilities;
import net.sf.fmj.concurrent.ExecutorServiceManager;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.gui.controlpanelfactory.ControlPanelFactorySingleton;
import net.sf.fmj.media.AbstractGainControl;
import net.sf.fmj.utility.ExceptionUtils;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;
import net.sf.jdshow.Com;
import net.sf.jdshow.ComException;
import net.sf.jdshow.IBasicAudio;
import net.sf.jdshow.IGraphBuilder;
import net.sf.jdshow.IMediaControl;
import net.sf.jdshow.IMediaSeeking;
import net.sf.jdshow.IVideoWindow;
import net.sf.jdshow.WindowedRendering;

public class Handler
extends AbstractPlayer {
    private static final ExecutorService executorService = ExecutorServiceManager.getExecutorService();
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private static final boolean TRACE = true;
    private volatile double aspectRatio;
    private IGraphBuilder graphBuilder;
    private IMediaControl mediaControl;
    private IMediaSeeking mediaSeeking;
    private volatile IBasicAudio basicAudio;
    private final ComponentListener myComponentListener = new MyComponentListener();
    private MyCanvas visualComponent;
    private volatile Dimension videoSize;

    public void setSource(final DataSource source) throws IncompatibleSourceException {
        Future<Void> future = executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.fine("DataSource: " + source);
                if (!source.getLocator().getProtocol().equals("file")) {
                    throw new IncompatibleSourceException("Only file URLs supported: " + source);
                }
                String path = URLUtils.extractValidPathFromFileUrl(source.getLocator().toExternalForm());
                if (path == null) {
                    throw new IncompatibleSourceException("Unable to extract valid file path from URL: " + source.getLocator().toExternalForm());
                }
                try {
                    path = new File(path).getCanonicalPath();
                }
                catch (IOException e1) {
                    String msg = "Unable to get canonical path from " + path + ": " + e1;
                    logger.log(Level.WARNING, msg, e1);
                    throw new IncompatibleSourceException(e1.toString() + " \n" + ExceptionUtils.getStackTrace(e1));
                }
                logger.info("Path: " + path);
                try {
                    System.loadLibrary("jdshow");
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "" + e, e);
                    throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
                }
                try {
                    Com.CoInitialize();
                    long[] p = new long[1];
                    int hr = Com.CoCreateInstance(Com.CLSID_FilterGraph, 0L, 23, Com.IID_IGraphBuilder, p);
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    Handler.this.graphBuilder = new IGraphBuilder(p[0]);
                    hr = Handler.this.graphBuilder.RenderFile(path, "");
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    hr = Handler.this.graphBuilder.QueryInterface(Com.IID_IMediaControl, p, "IID_IMediaControl");
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    Handler.this.mediaControl = new IMediaControl(p[0]);
                    hr = Handler.this.graphBuilder.QueryInterface(Com.IID_IMediaSeeking, p, "IID_IMediaSeeking");
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    Handler.this.mediaSeeking = new IMediaSeeking(p[0]);
                    hr = Handler.this.graphBuilder.QueryInterface(Com.IID_IBasicAudio, p, "IID_IBasicAudio");
                    if (Com.FAILED(hr)) {
                        logger.log(Level.WARNING, "iBasicAudio instantiation failed", new ComException(hr));
                    } else {
                        Handler.this.basicAudio = new IBasicAudio(p[0]);
                        long[] vol = new long[1];
                        hr = Handler.this.basicAudio.get_Volume(vol);
                        if (Com.FAILED(hr)) {
                            logger.log(Level.WARNING, "Audio controlls not supported for file " + new File(path).getName(), new ComException(hr));
                            Handler.this.basicAudio.Release();
                            Handler.this.basicAudio = null;
                        }
                    }
                    hr = Handler.this.graphBuilder.QueryInterface(Com.IID_IVideoWindow, p, "IID_IVideoWindow");
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    IVideoWindow videoWindow = new IVideoWindow(p[0]);
                    long[] width = new long[1];
                    hr = videoWindow.get_Width(width);
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    long[] height = new long[1];
                    hr = videoWindow.get_Height(height);
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    Handler.this.videoSize = new Dimension((int)width[0], (int)height[0]);
                    if (width[0] == 0L || height[0] == 0L) {
                        Handler.this.aspectRatio = 1.0;
                    } else {
                        Handler.this.aspectRatio = (double)width[0] / (double)height[0];
                    }
                    videoWindow.Release();
                }
                catch (ComException e) {
                    logger.log(Level.WARNING, "" + e, e);
                    throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
                }
                Handler.super.setSource(source);
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IncompatibleSourceException) {
                throw (IncompatibleSourceException)e.getCause();
            }
            logger.log(Level.WARNING, "" + e, e);
            throw new IncompatibleSourceException(e.toString());
        }
        if (this.basicAudio != null) {
            this.setGainControl(new DSGainControl());
        }
    }

    public void doPlayerClose() {
        logger.info("Handler.doPlayerClose");
    }

    public boolean doPlayerDeallocate() {
        if (this.visualComponent != null) {
            this.visualComponent.removeComponentListener(this.myComponentListener);
            this.visualComponent = null;
        }
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                Handler.this.graphBuilder.Abort();
                logger.info("Handler.doPlayerDeallocate");
                int result = Handler.this.mediaControl.Stop();
                if (Com.FAILED(result)) {
                    logger.warning("mediaControl.Stop failed");
                } else {
                    logger.info("mediaControl stopped");
                }
                long remaining = Handler.this.mediaControl.Release();
                Handler.this.mediaControl = null;
                logger.info("mediaControl released: " + remaining);
                remaining = Handler.this.graphBuilder.Release();
                Handler.this.graphBuilder = null;
                logger.info("graphBuilder released: " + remaining);
                remaining = Handler.this.mediaSeeking.Release();
                Handler.this.mediaSeeking = null;
                logger.info("mediaSeeking released: " + remaining);
                if (Handler.this.basicAudio != null) {
                    remaining = Handler.this.basicAudio.Release();
                    Handler.this.basicAudio = null;
                    logger.info("basicAudio released: " + remaining);
                } else {
                    logger.info("no basicAudio to release");
                }
                Com.CoUninitialize();
                logger.info("Com coUninitialized");
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return true;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return true;
        }
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    public boolean doPlayerRealize() {
        return true;
    }

    public void doPlayerSetMediaTime(final Time t) {
        logger.info("Handler.doPlayerSetMediaTime");
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                try {
                    long[] current = new long[1];
                    long[] stop = new long[1];
                    int hr = Handler.this.mediaSeeking.GetPositions(current, stop);
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    current[0] = t.getNanoseconds() / 100L;
                    hr = Handler.this.mediaSeeking.SetPositions(current, 1, stop, 0);
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                }
                catch (ComException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
        }
    }

    public float doPlayerSetRate(final float rate) {
        Future<Float> future = executorService.submit(new Callable<Float>(){

            @Override
            public Float call() {
                logger.fine("Handler.doPlayerSetRate " + rate);
                try {
                    int hr = Handler.this.mediaSeeking.SetRate(rate);
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                }
                catch (ComException e) {
                    logger.log(Level.WARNING, "" + e, e);
                    return Float.valueOf(Handler.this.getRate());
                }
                return Float.valueOf(rate);
            }
        });
        try {
            return future.get().floatValue();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return this.getRate();
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return this.getRate();
        }
    }

    public boolean doPlayerStop() {
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                logger.info("Handler.doPlayerStop");
                Handler.this.mediaControl.Stop();
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return false;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return false;
        }
        return true;
    }

    public boolean doPlayerSyncStart(final Time t) {
        Future<Boolean> future = executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                logger.info("Handler.doPlayerSyncStart" + t);
                try {
                    int hr = Handler.this.mediaControl.Run();
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                }
                catch (ComException e) {
                    logger.log(Level.WARNING, "" + e, e);
                    return false;
                }
                return true;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return false;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return false;
        }
    }

    public Time getPlayerDuration() {
        Future<Time> future = executorService.submit(new Callable<Time>(){

            @Override
            public Time call() {
                if (Handler.this.getState() < 300) {
                    return Duration.DURATION_UNKNOWN;
                }
                if (Handler.this.mediaSeeking != null) {
                    try {
                        long[] duration = new long[1];
                        int hr = Handler.this.mediaSeeking.GetDuration(duration);
                        if (Com.FAILED(hr)) {
                            throw new ComException(hr);
                        }
                        return new Time(duration[0] * 100L);
                    }
                    catch (ComException e) {
                        logger.log(Level.WARNING, "" + e, e);
                        return Duration.DURATION_UNKNOWN;
                    }
                }
                return Duration.DURATION_UNKNOWN;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return DURATION_UNKNOWN;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return DURATION_UNKNOWN;
        }
    }

    public Time getMediaTime() {
        Future<Time> future = executorService.submit(new Callable<Time>(){

            @Override
            public Time call() {
                if (Handler.this.mediaSeeking != null) {
                    try {
                        long[] current = new long[1];
                        int hr = Handler.this.mediaSeeking.GetCurrentPosition(current);
                        if (Com.FAILED(hr)) {
                            throw new ComException(hr);
                        }
                        return new Time(current[0] * 100L);
                    }
                    catch (ComException e) {
                        logger.log(Level.WARNING, "" + e, e);
                        return Duration.DURATION_UNKNOWN;
                    }
                }
                return Duration.DURATION_UNKNOWN;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return DURATION_UNKNOWN;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return DURATION_UNKNOWN;
        }
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        if (this.visualComponent == null) {
            this.visualComponent = new MyCanvas();
            this.visualComponent.addComponentListener(this.myComponentListener);
        }
        return this.visualComponent;
    }

    private Dimension calculateSize(int maxWidth, int maxHeight) {
        if (maxWidth < 2 || maxHeight < 2) {
            return new Dimension(2, 2);
        }
        double maxRatio = (double)maxWidth / (double)maxHeight;
        int newWidth = maxWidth;
        int newHeight = maxHeight;
        if (maxRatio > this.aspectRatio) {
            newWidth = (int)(this.aspectRatio * (double)maxHeight);
            if (newWidth > maxWidth) {
                return this.calculateSize(maxWidth, maxHeight - 5);
            }
        } else {
            newHeight = (int)((double)maxWidth / this.aspectRatio);
            if (newHeight > maxHeight) {
                return this.calculateSize(maxWidth - 5, maxHeight);
            }
        }
        return new Dimension(newWidth, newHeight);
    }

    private boolean bindVisualComponent() {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.visualComponent.isDisplayable()) {
            return false;
        }
        final long hwnd = Native.getComponentID(this.visualComponent);
        int width = this.visualComponent.getWidth();
        int height = this.visualComponent.getHeight();
        final Dimension dimension = this.calculateSize(width, height);
        int x = (width - dimension.width) / 2;
        int y = (height - dimension.height) / 2;
        final int xPos = x < 0 ? 0 : x;
        final int yPos = y < 0 ? 0 : y;
        Future<Boolean> future = executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    int hr = WindowedRendering.InitWindowedRendering2(hwnd, Handler.this.graphBuilder, xPos, yPos, dimension.width, dimension.height);
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                }
                catch (ComException e) {
                    logger.log(Level.WARNING, "" + e, e);
                    return false;
                }
                return true;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return false;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return false;
        }
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = ControlPanelFactorySingleton.getInstance().getControlPanelComponent(this);
            this.setControlPanelComponent(c);
        }
        return c;
    }

    private class DSGainControl
    extends AbstractGainControl {
        private static final long DS_MINIMUM_VOLUME = -10000L;

        private DSGainControl() {
        }

        public float getLevel() {
            Future<Float> future = executorService.submit(new Callable<Float>(){

                @Override
                public Float call() throws ComException {
                    long[] volume = new long[1];
                    int hr = Handler.this.basicAudio.get_Volume(volume);
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    return Float.valueOf(DSGainControl.this.dsToJmf(volume[0]));
                }
            });
            try {
                return future.get().floatValue();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "basicAudio.get_Volume failed", e);
                ExceptionUtils.reportOrReturn(e);
                return 0.0f;
            }
            catch (ExecutionException e) {
                logger.log(Level.WARNING, "basicAudio.get_Volume failed", e);
                ExceptionUtils.reportOrReturn(e.getCause());
                return 0.0f;
            }
        }

        public float setLevel(final float level) {
            Future<Float> future = executorService.submit(new Callable<Float>(){

                @Override
                public Float call() throws ComException {
                    int hr = Handler.this.basicAudio.put_Volume(DSGainControl.this.jmfToDS(level));
                    if (Com.FAILED(hr)) {
                        throw new ComException(hr);
                    }
                    return Float.valueOf(level);
                }
            });
            try {
                future.get();
                this.notifyListenersGainChangeEvent();
                return level;
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "basicAudio.put_Volume failed", e);
                ExceptionUtils.reportOrReturn(e);
                return level;
            }
            catch (ExecutionException e) {
                logger.log(Level.WARNING, "basicAudio.put_Volume failed", e);
                ExceptionUtils.reportOrReturn(e.getCause());
                return level;
            }
        }

        private long jmfToDS(float level) {
            long dsVolume = (long)(DSGainControl.levelToDb(level) * 100.0f);
            if (dsVolume < -10000L) {
                dsVolume = -10000L;
            }
            return dsVolume;
        }

        private float dsToJmf(long db) {
            return (float)((double)DSGainControl.dBToLevel(db) / 100.0);
        }
    }

    private class MyCanvas
    extends Canvas {
        private MyCanvas() {
            this.setBackground(Color.BLACK);
        }

        public Dimension getPreferredSize() {
            if (Handler.this.videoSize == null) {
                return new Dimension(0, 0);
            }
            return Handler.this.videoSize;
        }
    }

    private class MyComponentListener
    implements ComponentListener {
        private MyComponentListener() {
        }

        public void componentHidden(ComponentEvent e) {
            logger.fine("componentHidden");
        }

        public void componentMoved(ComponentEvent e) {
            int x = 100;
            logger.fine("componentMoved: " + e.getID());
            Handler.this.bindVisualComponent();
        }

        public void componentResized(ComponentEvent e) {
            logger.fine("componentResized");
            Handler.this.bindVisualComponent();
        }

        public void componentShown(ComponentEvent e) {
            logger.fine("componentShown");
            Handler.this.bindVisualComponent();
        }
    }
}

