/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.jmdns.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class Browser
extends JFrame
implements ServiceListener,
ServiceTypeListener,
ListSelectionListener {
    JmDNS jmdns;
    Vector headers;
    String type;
    DefaultListModel types;
    JList typeList;
    DefaultListModel services;
    JList serviceList;
    JTextArea info;

    Browser(JmDNS jmDNS) throws IOException {
        super("JmDNS Browser");
        this.jmdns = jmDNS;
        Color color = new Color(230, 230, 230);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 3));
        this.types = new DefaultListModel();
        this.typeList = new JList(this.types);
        this.typeList.setBorder(emptyBorder);
        this.typeList.setBackground(color);
        this.typeList.setSelectionMode(0);
        this.typeList.addListSelectionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", new JLabel("Types"));
        jPanel.add("Center", new JScrollPane(this.typeList, 20, 30));
        container.add(jPanel);
        this.services = new DefaultListModel();
        this.serviceList = new JList(this.services);
        this.serviceList.setBorder(emptyBorder);
        this.serviceList.setBackground(color);
        this.serviceList.setSelectionMode(0);
        this.serviceList.addListSelectionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", new JLabel("Services"));
        jPanel2.add("Center", new JScrollPane(this.serviceList, 20, 30));
        container.add(jPanel2);
        this.info = new JTextArea();
        this.info.setBorder(emptyBorder);
        this.info.setBackground(color);
        this.info.setEditable(false);
        this.info.setLineWrap(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", new JLabel("Details"));
        jPanel3.add("Center", new JScrollPane(this.info, 20, 30));
        container.add(jPanel3);
        this.setDefaultCloseOperation(3);
        this.setLocation(100, 100);
        this.setSize(600, 400);
        jmDNS.addServiceTypeListener(this);
        String[] stringArray = new String[]{"_http._tcp.local.", "_ftp._tcp.local.", "_tftp._tcp.local.", "_ssh._tcp.local.", "_smb._tcp.local.", "_printer._tcp.local.", "_airport._tcp.local.", "_afpovertcp._tcp.local.", "_ichat._tcp.local.", "_eppc._tcp.local.", "_presence._tcp.local."};
        int n = 0;
        while (n < stringArray.length) {
            jmDNS.registerServiceType(stringArray[n]);
            ++n;
        }
        this.show();
    }

    public void addService(JmDNS jmDNS, String string, String string2) {
        if (string2.endsWith("." + string)) {
            string2 = string2.substring(0, string2.length() - (string.length() + 1));
        }
        System.out.println("ADD: " + string2);
        this.insertSorted(this.services, string2);
    }

    public void removeService(JmDNS jmDNS, String string, String string2) {
        if (string2.endsWith("." + string)) {
            string2 = string2.substring(0, string2.length() - (string.length() + 1));
        }
        System.out.println("REMOVE: " + string2);
        this.services.removeElement(string2);
    }

    public void addServiceType(JmDNS jmDNS, String string) {
        System.out.println("TYPE: " + string);
        this.insertSorted(this.types, string);
    }

    void insertSorted(DefaultListModel defaultListModel, String string) {
        int n = 0;
        int n2 = defaultListModel.getSize();
        while (n < n2) {
            if (string.compareToIgnoreCase((String)defaultListModel.elementAt(n)) < 0) {
                defaultListModel.insertElementAt(string, n);
                return;
            }
            ++n;
        }
        defaultListModel.addElement(string);
    }

    public void resolveService(JmDNS jmDNS, String string, String string2, ServiceInfo serviceInfo) {
        if (string2.equals(this.serviceList.getSelectedValue() + "." + string)) {
            if (serviceInfo == null) {
                this.info.setText("service not found");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2);
                stringBuffer.append('\n');
                stringBuffer.append(serviceInfo.getServer());
                stringBuffer.append(':');
                stringBuffer.append(serviceInfo.getPort());
                stringBuffer.append('\n');
                stringBuffer.append(serviceInfo.getAddress());
                stringBuffer.append(':');
                stringBuffer.append(serviceInfo.getPort());
                stringBuffer.append('\n');
                Enumeration enumeration = serviceInfo.getPropertyNames();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    stringBuffer.append(string3);
                    stringBuffer.append('=');
                    stringBuffer.append(serviceInfo.getPropertyString(string3));
                    stringBuffer.append('\n');
                }
                this.info.setText(stringBuffer.toString());
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (listSelectionEvent.getSource() == this.typeList) {
                this.type = (String)this.typeList.getSelectedValue();
                this.jmdns.removeServiceListener(this);
                this.services.setSize(0);
                this.info.setText("");
                this.jmdns.addServiceListener(this.type, this);
            } else if (listSelectionEvent.getSource() == this.serviceList) {
                String string = (String)this.serviceList.getSelectedValue();
                if (string == null) {
                    this.info.setText("");
                } else {
                    ServiceInfo serviceInfo;
                    if (!string.endsWith(".")) {
                        string = string + "." + this.type;
                    }
                    if ((serviceInfo = this.jmdns.getServiceInfo(this.type, string)) == null) {
                        this.info.setText("service not found");
                    } else {
                        if (!string.endsWith(".")) {
                            string = string + "." + this.type;
                        }
                        this.jmdns.requestServiceInfo(this.type, string);
                    }
                }
            }
        }
    }

    public String toString() {
        return "RVBROWSER";
    }

    public static void main(String[] stringArray) throws IOException {
        new Browser(new JmDNS());
    }

    class ServiceTableModel
    extends AbstractTableModel {
        ServiceTableModel() {
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "service";
                }
                case 1: {
                    return "address";
                }
                case 2: {
                    return "port";
                }
                case 3: {
                    return "text";
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return Browser.this.services.size();
        }

        public Object getValueAt(int n, int n2) {
            return Browser.this.services.elementAt(n);
        }
    }
}

