/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import com.onionnetworks.io.FilterRAF;
import com.onionnetworks.io.RAF;
import com.onionnetworks.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class LazyRenameRAF
extends FilterRAF {
    File destFile;

    public synchronized void renameTo(File newFile) throws IOException {
        this.destFile = newFile;
        if (this.getMode().equals("r")) {
            this.raf.renameTo(this.destFile);
        } else {
            File newTemp = FileUtil.createTempFile(this.destFile);
            this.raf.renameTo(newTemp);
        }
    }

    public synchronized void setReadOnly() throws IOException {
        this.raf.setReadOnly();
        if (this.destFile != null) {
            this.raf.renameTo(this.destFile);
        }
    }

    public LazyRenameRAF(RAF raf) throws IOException {
        super(raf);
        if (this.getMode().equals("r")) {
            throw new IllegalStateException("LazyRenameRAFs are only useful in read/write mode.");
        }
    }
}

