/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.rudp;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.limegroup.gnutella.rudp.LimeRUDPContext;
import com.limegroup.gnutella.rudp.LimeRUDPSettings;
import com.limegroup.gnutella.rudp.LimeUDPService;
import com.limegroup.gnutella.rudp.messages.LimeWireGnutellaRudpMessageModule;
import java.io.IOException;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.listener.AsynchronousEventBroadcaster;
import org.limewire.listener.AsynchronousMulticasterImpl;
import org.limewire.listener.ListenerSupport;
import org.limewire.nio.NIODispatcher;
import org.limewire.rudp.AbstractNBSocketChannel;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.RUDPSettings;
import org.limewire.rudp.UDPMultiplexor;
import org.limewire.rudp.UDPSelectorProvider;
import org.limewire.rudp.UDPService;
import org.limewire.rudp.UDPSocketChannelConnectionEvent;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.impl.DefaultMessageFactory;

public class LimeWireGnutellaRudpModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.binder().install(new LimeWireGnutellaRudpMessageModule());
        ListeningExecutorService executorService = ExecutorsHelper.newProcessingQueue(UDPSocketChannelConnectionEvent.class.getSimpleName());
        AsynchronousMulticasterImpl connectionEventMulticaster = new AsynchronousMulticasterImpl(executorService);
        this.bind(new TypeLiteral<AsynchronousEventBroadcaster<UDPSocketChannelConnectionEvent>>(){}).toInstance(connectionEventMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<UDPSocketChannelConnectionEvent>>(){}).toInstance(connectionEventMulticaster);
        this.bind(RUDPContext.class).to(LimeRUDPContext.class);
        this.bind(UDPMultiplexor.class).toProvider(UDPMultiplexorProvider.class);
        this.bind(UDPService.class).to(LimeUDPService.class);
        this.bind(RUDPSettings.class).to(LimeRUDPSettings.class);
        this.bind(RUDPMessageFactory.class).annotatedWith(Names.named("delegate")).to(DefaultMessageFactory.class);
    }

    @Singleton
    private static class UDPMultiplexorProvider
    extends AbstractLazySingletonProvider<UDPMultiplexor> {
        private final UDPSelectorProvider provider;
        private final NIODispatcher nioDispatcher;

        @Inject
        public UDPMultiplexorProvider(UDPSelectorProvider provider, NIODispatcher nioDispatcher) {
            this.provider = provider;
            this.nioDispatcher = nioDispatcher;
        }

        @Override
        protected UDPMultiplexor createObject() {
            UDPMultiplexor multiplexor = this.provider.openSelector();
            AbstractNBSocketChannel socketChannel = this.provider.openSocketChannel();
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nioDispatcher.registerSelector(multiplexor, socketChannel.getClass());
            return multiplexor;
        }
    }
}

