/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.auth.UrnValidator;
import com.limegroup.gnutella.auth.ValidationEvent;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.URNFilter;
import com.limegroup.gnutella.library.DiskIo;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileDescChangeEvent;
import com.limegroup.gnutella.library.FileDescFactory;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.FileViewChangeFailedException;
import com.limegroup.gnutella.library.FileViewIterator;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryFileData;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.library.UrnCache;
import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.XmlController;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.limewire.collection.CollectionUtils;
import org.limewire.collection.IntSet;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.concurrent.ListeningFutureTask;
import org.limewire.concurrent.SimpleFuture;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.FileProcessingEvent;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.listener.SourcedEventMulticaster;
import org.limewire.listener.SwingSafePropertyChangeSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

@Singleton
class LibraryImpl
implements Library,
FileCollection {
    private static final Log LOG = LogFactory.getLog(LibraryImpl.class);
    private final SourcedEventMulticaster<FileDescChangeEvent, FileDesc> fileDescMulticaster;
    private final EventMulticaster<LibraryStatusEvent> managedListListenerSupport;
    private final EventMulticaster<FileViewChangeEvent> fileListListenerSupport;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final UrnCache urnCache;
    private final FileDescFactory fileDescFactory;
    private final ListeningExecutorService folderLoader;
    private final ListeningExecutorService diskIoService;
    private final PropertyChangeSupport changeSupport;
    private final DangerousFileChecker dangerousFileChecker;
    private final EventListenerList<FileProcessingEvent> fileProcessingListeners;
    private final XmlController xmlController;
    private final URNFilter urnFilter;
    private final CategoryManager categoryManager;
    private final List<FileDesc> files;
    private final Map<File, FileDesc> fileToFileDescMap;
    private final Map<File, Future> fileToFutures;
    private final Map<URN, IntSet> urnMap;
    private final LibraryFileData fileData;
    private final UrnValidator urnValidator;
    private volatile boolean loadingFinished = false;
    private final AtomicInteger pendingFiles = new AtomicInteger(0);
    private static final Callable<FileDesc> EMPTY_CALLABLE = new Callable<FileDesc>(){

        @Override
        public FileDesc call() {
            return null;
        }
    };

    @Inject
    LibraryImpl(SourcedEventMulticaster<FileDescChangeEvent, FileDesc> fileDescMulticaster, UrnCache urnCache, FileDescFactory fileDescFactory, EventMulticaster<LibraryStatusEvent> managedListSupportMulticaster, UrnValidator urnValidator, DangerousFileChecker dangerousFileChecker, XmlController xmlController, @DiskIo ListeningExecutorService diskIoService, EventListenerList<FileProcessingEvent> processingListenerList, URNFilter urnFilter, CategoryManager categoryManager) {
        this.fileData = new LibraryFileData(categoryManager);
        this.urnCache = urnCache;
        this.fileDescFactory = fileDescFactory;
        this.fileDescMulticaster = fileDescMulticaster;
        this.managedListListenerSupport = managedListSupportMulticaster;
        this.fileListListenerSupport = new EventMulticasterImpl<FileViewChangeEvent>();
        this.folderLoader = ExecutorsHelper.newProcessingQueue("Library Folder Loader");
        this.files = new ArrayList<FileDesc>();
        this.urnMap = new HashMap<URN, IntSet>();
        this.fileToFileDescMap = new HashMap<File, FileDesc>();
        this.fileToFutures = new HashMap<File, Future>();
        this.urnValidator = urnValidator;
        this.changeSupport = new SwingSafePropertyChangeSupport(this);
        this.dangerousFileChecker = dangerousFileChecker;
        this.xmlController = xmlController;
        this.diskIoService = diskIoService;
        this.fileProcessingListeners = processingListenerList;
        this.urnFilter = urnFilter;
        this.categoryManager = categoryManager;
    }

    @Override
    public String getName() {
        return "Library";
    }

    @Override
    public List<FileDesc> getFilesInDirectory(File directory) {
        throw new UnsupportedOperationException("unsupported");
    }

    @Override
    public long getNumBytes() {
        throw new UnsupportedOperationException("unsupported");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    LibraryFileData getLibraryData() {
        if (!this.fileData.isLoaded()) {
            this.fileData.load();
        }
        return this.fileData;
    }

    void initialize() {
        this.urnValidator.addListener(new EventListener<ValidationEvent>(){

            @Override
            public void handleEvent(ValidationEvent event) {
                switch (event.getType()) {
                    case INVALID: {
                        List<FileDesc> fds = LibraryImpl.this.getFileDescsMatching(event.getUrn());
                        for (FileDesc fd : fds) {
                            LibraryImpl.this.remove(fd);
                        }
                        break;
                    }
                }
            }
        });
    }

    private FileViewChangeFailedException createFailureException(File newFile, FileDesc oldFd, FileViewChangeFailedException.Reason reason) {
        if (oldFd != null) {
            return new FileViewChangeFailedException(oldFd.getFile(), FileViewChangeEvent.Type.FILE_CHANGE_FAILED, reason);
        }
        return new FileViewChangeFailedException(newFile, FileViewChangeEvent.Type.FILE_ADD_FAILED, reason);
    }

    private void dispatchFailure(File file, FileDesc oldFileDesc) {
        if (oldFileDesc != null) {
            this.dispatch(new FileViewChangeEvent(this, FileViewChangeEvent.Type.FILE_CHANGE_FAILED, oldFileDesc.getFile(), oldFileDesc, file));
            this.dispatch(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_REMOVED, oldFileDesc));
        } else {
            this.dispatch(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_ADD_FAILED, file));
        }
    }

    void dispatch(FileViewChangeEvent event) {
        this.fileListListenerSupport.broadcast(event);
    }

    void dispatch(LibraryStatusEvent event) {
        this.managedListListenerSupport.broadcast(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileDesc getFileDesc(File file) {
        file = FileUtils.canonicalize(file);
        this.rwLock.readLock().lock();
        try {
            FileDesc fileDesc = this.fileToFileDescMap.get(file);
            return fileDesc;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileDesc getFileDescForIndex(int index) {
        this.rwLock.readLock().lock();
        try {
            if (index < 0 || index >= this.files.size()) {
                FileDesc fileDesc = null;
                return fileDesc;
            }
            FileDesc fileDesc = this.files.get(index);
            return fileDesc;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(File file) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.fileToFileDescMap.containsKey(FileUtils.canonicalize(file));
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(FileDesc fileDesc) {
        return this.getFileDescForIndex(fileDesc.getIndex()) == fileDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIncompleteFile(File incompleteFile, Set<? extends URN> urns, String name, long size, VerifyingFile vf) {
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
        }
        catch (IOException ioe) {
            return;
        }
        IncompleteFileDesc fd = null;
        this.rwLock.writeLock().lock();
        try {
            if (!this.fileToFileDescMap.containsKey(incompleteFile)) {
                fd = this.fileDescFactory.createIncompleteFileDesc(incompleteFile, urns, this.files.size(), name, size, vf);
                this.files.add(fd);
                this.fileToFileDescMap.put(incompleteFile, fd);
                this.updateUrnIndex(fd);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (fd != null) {
            this.dispatch(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_ADDED, fd));
        }
    }

    @Override
    public void addListener(EventListener<FileViewChangeEvent> listener) {
        this.fileListListenerSupport.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<FileViewChangeEvent> listener) {
        return this.fileListListenerSupport.removeListener(listener);
    }

    @Override
    public void addManagedListStatusListener(EventListener<LibraryStatusEvent> listener) {
        this.managedListListenerSupport.addListener(listener);
    }

    @Override
    public void removeManagedListStatusListener(EventListener<LibraryStatusEvent> listener) {
        this.managedListListenerSupport.removeListener(listener);
    }

    @Override
    public void clear() {
        this.clearImpl();
        this.getLibraryData().clearFileData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearImpl() {
        HashMap<File, Future> fileFutures;
        this.rwLock.writeLock().lock();
        try {
            fileFutures = new HashMap<File, Future>(this.fileToFutures);
            this.fileToFutures.clear();
            this.files.clear();
            this.urnMap.clear();
            this.fileToFileDescMap.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        for (Map.Entry entry : fileFutures.entrySet()) {
            if (!((Future)entry.getValue()).cancel(true)) continue;
            this.broadcastFinished((File)entry.getKey());
        }
        this.dispatch(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILES_CLEARED, true));
    }

    @Override
    public FileDesc getFileDesc(URN urn) {
        List<FileDesc> matching = this.getFileDescsMatching(urn);
        if (matching.isEmpty()) {
            return null;
        }
        return matching.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileDesc> getFileDescsMatching(URN urn) {
        this.rwLock.readLock().lock();
        try {
            IntSet urnsMatching = this.urnMap.get(urn);
            if (urnsMatching == null || urnsMatching.size() == 0) {
                List<FileDesc> list = Collections.emptyList();
                return list;
            }
            if (urnsMatching.size() == 1) {
                List<FileDesc> list = Collections.singletonList(this.files.get(urnsMatching.iterator().next()));
                return list;
            }
            List<FileDesc> list = CollectionUtils.listOf(new FileViewIterator(this, urnsMatching));
            return list;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public Lock getReadLock() {
        return this.rwLock.readLock();
    }

    @Override
    public Iterator<FileDesc> iterator() {
        return CollectionUtils.readOnlyIterator(this.fileToFileDescMap.values().iterator());
    }

    @Override
    public Iterable<FileDesc> pausableIterable() {
        return new Iterable<FileDesc>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<FileDesc> iterator() {
                LibraryImpl.this.rwLock.readLock().lock();
                try {
                    ThreadSafeLibraryIterator threadSafeLibraryIterator = new ThreadSafeLibraryIterator();
                    return threadSafeLibraryIterator;
                }
                finally {
                    LibraryImpl.this.rwLock.readLock().unlock();
                }
            }
        };
    }

    @Override
    public boolean remove(FileDesc fileDesc) {
        return this.remove(fileDesc.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.rwLock.readLock().lock();
        try {
            int n = this.fileToFileDescMap.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public boolean add(FileDesc fileDesc) {
        assert (this.contains(fileDesc));
        return true;
    }

    @Override
    public ListeningFuture<FileDesc> add(File file) {
        return this.add(file, LimeXMLDocument.EMPTY_LIST);
    }

    @Override
    public ListeningFuture<FileDesc> add(File file, List<? extends LimeXMLDocument> list) {
        return this.add(file, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListeningFuture<FileDesc> add(File originalFile, List<? extends LimeXMLDocument> metadata, FileDesc oldFileDesc) {
        LOG.debugf("Attempting to load file: {0}", (Object)originalFile);
        File file = null;
        try {
            file = FileUtils.getCanonicalFile(originalFile);
        }
        catch (IOException e) {
            LOG.debugf("Not adding {0} because canonicalize failed", (Object)originalFile);
            this.dispatchFailure(originalFile, null);
            return new SimpleFuture<FileDesc>(this.createFailureException(originalFile, oldFileDesc, FileViewChangeFailedException.Reason.CANT_CANONICALIZE));
        }
        this.rwLock.readLock().lock();
        try {
            if (this.fileToFileDescMap.containsKey(file)) {
                LOG.debugf("Not loading because file already loaded {0}", (Object)file);
                this.dispatchFailure(file, oldFileDesc);
                SimpleFuture<FileDesc> e = new SimpleFuture<FileDesc>(this.createFailureException(file, oldFileDesc, FileViewChangeFailedException.Reason.ALREADY_MANAGED));
                return e;
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (!LibraryUtils.isFilePhysicallyManagable(file)) {
            LOG.debugf("Not adding {0} because file isn't physically manageable", (Object)file);
            this.dispatchFailure(file, oldFileDesc);
            return new SimpleFuture<FileDesc>(this.createFailureException(file, oldFileDesc, FileViewChangeFailedException.Reason.NOT_MANAGEABLE));
        }
        if (!LibraryUtils.isFileAllowedToBeManaged(file, this.categoryManager)) {
            LOG.debugf("Not adding {0} because files of this type are not allowed to be managed", (Object)file);
            this.dispatchFailure(file, oldFileDesc);
            return new SimpleFuture<FileDesc>(this.createFailureException(file, oldFileDesc, FileViewChangeFailedException.Reason.FILE_TYPE_NOT_ALLOWED));
        }
        PendingFuture task = new PendingFuture();
        if (file.getPath().equals(originalFile.getPath())) {
            this.getLibraryData().addManagedFile(originalFile);
            this.startLoadingFileDesc(originalFile, this.urnCache.getUrns(file), metadata, oldFileDesc, task);
        } else {
            file = new File(file.getPath().intern());
            this.getLibraryData().addOrRenameManagedFile(file, originalFile);
            this.startLoadingFileDesc(file, this.urnCache.getUrns(file), metadata, oldFileDesc, task);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFutureForFile(File file, Future future) {
        this.rwLock.writeLock().lock();
        try {
            this.fileToFutures.put(file, future);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFutureForFile(File file) {
        this.rwLock.writeLock().lock();
        try {
            this.fileToFutures.remove(file);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingFileDesc(final File file, Set<URN> urns, final List<? extends LimeXMLDocument> metadata, final FileDesc oldFileDesc, final PendingFuture task) {
        final FileDesc fd = this.createAndAddFileDesc(file, metadata, urns, oldFileDesc, task);
        if (fd != null) {
            if (UrnSet.getSha1(urns) == null) {
                ListeningFuture<Set<URN>> urnFuture = this.urnCache.calculateAndCacheSHA1(file);
                this.setFutureForFile(file, urnFuture);
                LOG.debugf("Submitting URN future for {0}", (Object)file);
                this.broadcastQueued(file);
                urnFuture.addFutureListener(new EventListener<FutureEvent<Set<URN>>>(){

                    @Override
                    public void handleEvent(FutureEvent<Set<URN>> event) {
                        LOG.debugf("Running URN future for {0}", (Object)file);
                        LibraryImpl.this.removeFutureForFile(file);
                        if (LibraryImpl.this.contains(fd)) {
                            LibraryImpl.this.addUrnsToFileDesc(fd, metadata, event, task, oldFileDesc);
                        }
                        if (event.getType() != FutureEvent.Type.CANCELLED) {
                            LibraryImpl.this.broadcastFinished(file);
                        }
                    }
                });
            } else {
                boolean safe = this.getLibraryData().isFileSafe(fd.getSHA1Urn().toString());
                boolean loadedXML = !fd.getLimeXMLDocuments().isEmpty();
                boolean allowsXML = this.xmlController.canConstructXml(fd);
                if (safe && (loadedXML || !allowsXML)) {
                    LOG.debugf("File loaded immediately! {0}", (Object)file);
                    this.removeFutureForFile(file);
                    task.set(fd);
                } else {
                    LOG.debugf("URNs precalculated for {0}, but needs safe-check or XML", (Object)file);
                    this.broadcastQueued(file);
                    this.rwLock.writeLock().lock();
                    try {
                        LOG.debugf("Submitting finish loading FD for {0}", (Object)fd.getFile());
                        this.setFutureForFile(fd.getFile(), this.diskIoService.submit(new Runnable(){

                            @Override
                            public void run() {
                                LibraryImpl.this.broadcastProcessing(fd.getFile());
                                LOG.debugf("Running finish loading FD for {0}", (Object)fd.getFile());
                                LibraryImpl.this.removeFutureForFile(fd.getFile());
                                if (LibraryImpl.this.contains(fd)) {
                                    LibraryImpl.this.finishLoadingFileDesc(fd, metadata, task, false, oldFileDesc);
                                }
                                LibraryImpl.this.broadcastFinished(file);
                            }
                        }));
                    }
                    finally {
                        this.rwLock.writeLock().unlock();
                    }
                }
            }
        } else {
            LOG.debugf("Unable to create FileDesc for {0}", (Object)file);
        }
    }

    private void broadcastProcessing(File file) {
        this.fileProcessingListeners.broadcast(new FileProcessingEvent(FileProcessingEvent.Type.PROCESSING, file));
    }

    private void broadcastQueued(File file) {
        this.fileProcessingListeners.broadcast(new FileProcessingEvent(FileProcessingEvent.Type.QUEUED, file));
    }

    private void broadcastFinished(File file) {
        this.fileProcessingListeners.broadcast(new FileProcessingEvent(FileProcessingEvent.Type.FINISHED, file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUrnsToFileDesc(FileDesc fd, List<? extends LimeXMLDocument> metadata, FutureEvent<Set<URN>> urnEvent, PendingFuture task, FileDesc oldFileDesc) {
        Set<URN> urns = urnEvent.getResult();
        if (urns == null || urns.isEmpty()) {
            this.remove(fd.getFile());
            FileViewChangeFailedException ex = this.createFailureException(fd.getFile(), oldFileDesc, FileViewChangeFailedException.Reason.ERROR_LOADING_URNS);
            ex.initCause(urnEvent.getException());
            task.setException(ex);
        } else if (this.urnValidator.isInvalid(UrnSet.getSha1(urns)) || this.urnFilter.isBlacklisted(UrnSet.getSha1(urns))) {
            this.remove(fd.getFile());
            task.setException(this.createFailureException(fd.getFile(), oldFileDesc, FileViewChangeFailedException.Reason.INVALID_URN));
        } else {
            for (URN urn : urns) {
                fd.addUrn(urn);
            }
            this.rwLock.writeLock().lock();
            try {
                this.updateUrnIndex(fd);
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
            this.xmlController.loadCachedXml(fd, metadata);
            this.finishLoadingFileDesc(fd, metadata, task, true, oldFileDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDesc createAndAddFileDesc(File file, List<? extends LimeXMLDocument> metadata, Set<URN> urns, FileDesc oldFileDesc, PendingFuture task) {
        FileDesc fd = null;
        FileDesc newFD = null;
        boolean failed = false;
        this.rwLock.writeLock().lock();
        try {
            fd = newFD = this.createFileDesc(file, urns, this.files.size());
            if (fd != null) {
                if (this.contains(file)) {
                    failed = true;
                    fd = this.getFileDesc(file);
                } else {
                    this.files.add(fd);
                    this.fileToFileDescMap.put(file, fd);
                    this.updateUrnIndex(fd);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (fd == null) {
            this.dispatchFailure(file, oldFileDesc);
            task.setException(this.createFailureException(file, oldFileDesc, FileViewChangeFailedException.Reason.INVALID_URN));
        } else if (failed) {
            LOG.debugf("Couldn't load FD because FD with file {0} exists already.  FD: {1}", (Object)file, (Object)fd);
            this.dispatchFailure(file, oldFileDesc);
            task.setException(this.createFailureException(file, oldFileDesc, FileViewChangeFailedException.Reason.ALREADY_MANAGED));
        } else {
            assert (newFD != null);
            if (fd.getSHA1Urn() != null) {
                this.xmlController.loadCachedXml(fd, metadata);
            }
            if (oldFileDesc == null) {
                LOG.debugf("Added file: {0}", (Object)file);
                this.dispatch(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_ADDED, fd));
            } else {
                LOG.debugf("Changed to new file: {0}", (Object)file);
                this.dispatch(new FileViewChangeEvent(this, FileViewChangeEvent.Type.FILE_CHANGED, oldFileDesc, fd));
            }
        }
        return newFD;
    }

    private void finishLoadingFileDesc(FileDesc fd, List<? extends LimeXMLDocument> metadata, PendingFuture task, boolean alwaysSendMetaChange, FileDesc oldFileDesc) {
        URN sha1 = fd.getSHA1Urn();
        boolean dangerous = false;
        if (!this.getLibraryData().isFileSafe(sha1.toString())) {
            dangerous = this.dangerousFileChecker.isDangerous(fd.getFile());
            this.getLibraryData().setFileSafe(sha1.toString(), !dangerous);
        }
        if (dangerous) {
            this.remove(fd.getFile());
            task.setException(this.createFailureException(fd.getFile(), oldFileDesc, FileViewChangeFailedException.Reason.DANGEROUS_FILE));
        } else {
            boolean loaded = this.xmlController.loadXml(fd);
            if (alwaysSendMetaChange || loaded) {
                this.dispatch(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_META_CHANGED, fd));
            }
            task.set(fd);
        }
        LOG.debugf("Finished loading FD for {0}", (Object)fd.getFile());
    }

    private FileDesc createFileDesc(File file, Set<? extends URN> urns, int index) {
        if (this.urnValidator.isInvalid(UrnSet.getSha1(urns)) || this.urnFilter.isBlacklisted(UrnSet.getSha1(urns))) {
            return null;
        }
        return this.fileDescFactory.createFileDesc(file, urns, index);
    }

    @Override
    public boolean remove(File file) {
        LOG.debugf("Removing file: {0}", (Object)file);
        file = FileUtils.canonicalize(file);
        FileDesc fd = this.removeInternal(file);
        if (fd != null) {
            this.dispatch(new FileViewChangeEvent((FileView)this, FileViewChangeEvent.Type.FILE_REMOVED, fd));
        }
        return fd != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDesc removeInternal(File file) {
        FileDesc fd;
        boolean cancelled = false;
        this.rwLock.writeLock().lock();
        try {
            Future future;
            fd = this.fileToFileDescMap.get(file);
            if (fd != null) {
                this.removeFileDesc(file, fd);
            }
            if ((future = this.fileToFutures.remove(file)) != null) {
                cancelled = future.cancel(true);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (fd != null) {
            this.getLibraryData().removeManagedFile(file);
        }
        if (cancelled) {
            this.broadcastFinished(file);
        }
        return fd;
    }

    private void removeFileDesc(File file, FileDesc fd) {
        this.removeUrnIndex(fd);
        FileDesc rm = this.files.set(fd.getIndex(), null);
        assert (rm == fd);
        rm = this.fileToFileDescMap.remove(file);
        assert (rm == fd);
        this.fileDescMulticaster.removeListeners(fd);
    }

    private void updateUrnIndex(FileDesc fileDesc) {
        URN sha1 = fileDesc.getSHA1Urn();
        if (sha1 != null) {
            IntSet indices = this.urnMap.get(sha1);
            if (indices == null) {
                indices = new IntSet();
                this.urnMap.put(sha1, indices);
            }
            indices.add(fileDesc.getIndex());
        }
    }

    private void removeUrnIndex(FileDesc fileDesc) {
        URN sha1 = fileDesc.getSHA1Urn();
        if (sha1 != null) {
            IntSet indices = this.urnMap.get(sha1);
            if (indices == null) {
                assert (fileDesc instanceof IncompleteFileDesc);
                return;
            }
            indices.remove(fileDesc.getIndex());
            if (indices.size() == 0) {
                this.urnMap.remove(sha1);
            }
        }
    }

    @Override
    public ListeningFuture<FileDesc> fileRenamed(File oldName, File newName) {
        LOG.debugf("Attempting to rename: {0} to: {1}", (Object)oldName, (Object)newName);
        oldName = FileUtils.canonicalize(oldName);
        FileDesc fd = this.removeInternal(oldName);
        if (fd != null) {
            this.urnCache.addUrns(newName, fd.getUrns());
            ArrayList<LimeXMLDocument> xmlDocs = new ArrayList<LimeXMLDocument>(fd.getLimeXMLDocuments());
            return this.add(newName, xmlDocs, fd);
        }
        return new SimpleFuture<FileDesc>(new FileViewChangeFailedException(oldName, FileViewChangeEvent.Type.FILE_CHANGE_FAILED, FileViewChangeFailedException.Reason.OLD_WASNT_MANAGED));
    }

    @Override
    public ListeningFuture<FileDesc> fileChanged(File file, List<? extends LimeXMLDocument> xmlDocs) {
        LOG.debugf("File Changed: {0}", (Object)file);
        file = FileUtils.canonicalize(file);
        FileDesc fd = this.removeInternal(file);
        if (fd != null) {
            this.urnCache.removeUrns(file);
            return this.add(file, xmlDocs, fd);
        }
        return new SimpleFuture<FileDesc>(new FileViewChangeFailedException(file, FileViewChangeEvent.Type.FILE_CHANGE_FAILED, FileViewChangeFailedException.Reason.OLD_WASNT_MANAGED));
    }

    ListeningFuture<List<ListeningFuture<FileDesc>>> loadManagedFiles() {
        ListeningFuture<List<ListeningFuture<FileDesc>>> future = this.diskIoService.submit(new Callable<List<ListeningFuture<FileDesc>>>(){

            @Override
            public List<ListeningFuture<FileDesc>> call() {
                return LibraryImpl.this.loadSettingsInternal();
            }
        });
        return future;
    }

    private List<ListeningFuture<FileDesc>> loadSettingsInternal() {
        LOG.debugf("Loading Library", new Object[0]);
        this.loadingFinished = false;
        this.clearImpl();
        this.fireLoading();
        List<ListeningFuture<FileDesc>> futures = this.loadManagedFilesInternal();
        this.addLoadingListener(futures);
        return futures;
    }

    void fireLoading() {
        this.changeSupport.firePropertyChange("hasPending", false, true);
    }

    private void addLoadingListener(List<ListeningFuture<FileDesc>> futures) {
        if (futures.isEmpty() && this.pendingFiles.get() == 0) {
            this.loadFinished();
        } else if (!futures.isEmpty()) {
            this.pendingFiles.addAndGet(futures.size());
            EventListener<FutureEvent<FileDesc>> listener = new EventListener<FutureEvent<FileDesc>>(){

                @Override
                public void handleEvent(FutureEvent<FileDesc> event) {
                    if (LibraryImpl.this.pendingFiles.addAndGet(-1) == 0) {
                        LibraryImpl.this.loadFinished();
                    }
                }
            };
            for (ListeningFuture<FileDesc> future : futures) {
                future.addFutureListener(listener);
            }
        }
    }

    private void loadFinished() {
        this.changeSupport.firePropertyChange("hasPending", true, false);
        if (!this.loadingFinished) {
            this.loadingFinished = true;
            LOG.debugf("Finished loading revision", new Object[0]);
            this.dispatch(new LibraryStatusEvent(this, LibraryStatusEvent.Type.LOAD_FINISHING));
            this.save();
            this.dispatch(new LibraryStatusEvent(this, LibraryStatusEvent.Type.LOAD_COMPLETE));
        }
    }

    @Override
    public boolean isLoadFinished() {
        return this.loadingFinished;
    }

    private List<ListeningFuture<FileDesc>> loadManagedFilesInternal() {
        ArrayList<ListeningFuture<FileDesc>> futures = new ArrayList<ListeningFuture<FileDesc>>();
        EventListener<FutureEvent<FileDesc>> indivListeners = new EventListener<FutureEvent<FileDesc>>(){

            @Override
            public void handleEvent(FutureEvent<FileDesc> event) {
                switch (event.getType()) {
                    case EXCEPTION: {
                        if (!(event.getException().getCause() instanceof FileViewChangeFailedException)) break;
                        FileViewChangeFailedException ex = (FileViewChangeFailedException)event.getException().getCause();
                        switch (ex.getReason()) {
                            case CANT_CANONICALIZE: 
                            case INVALID_URN: 
                            case NOT_MANAGEABLE: 
                            case FILE_TYPE_NOT_ALLOWED: {
                                LibraryImpl.this.getLibraryData().removeManagedFile(ex.getFile());
                            }
                        }
                    }
                }
            }
        };
        int i = 0;
        for (File file : this.getLibraryData().getManagedFiles()) {
            if (i % 2 == 0) {
                Thread.yield();
            }
            ListeningFuture<FileDesc> future = this.add(file, LimeXMLDocument.EMPTY_LIST, null);
            future.addFutureListener(indivListeners);
            futures.add(future);
            ++i;
        }
        return futures;
    }

    void save() {
        this.dispatch(new LibraryStatusEvent(this, LibraryStatusEvent.Type.SAVE));
        this.urnCache.persistCache();
        this.getLibraryData().save();
    }

    private boolean isFolderManageable(File folder) {
        if (!(folder = FileUtils.canonicalize(folder)).isDirectory() || !folder.canRead() || !folder.exists() && folder.getParent() != null) {
            return false;
        }
        if (this.getLibraryData().isIncompleteDirectory(folder)) {
            return false;
        }
        if (LibraryUtils.isApplicationSpecialShareDirectory(folder)) {
            return false;
        }
        if (LibraryUtils.isFolderBanned(folder)) {
            return false;
        }
        return !LibraryUtils.isSensitiveDirectory(folder);
    }

    @Override
    public boolean isDirectoryAllowed(File folder) {
        if (!folder.isDirectory()) {
            return false;
        }
        if (!this.isFolderManageable(folder)) {
            return false;
        }
        return this.isProgramManagingAllowed() || !"app".equalsIgnoreCase(FileUtils.getFileExtension(folder));
    }

    @Override
    public boolean isProgramManagingAllowed() {
        return this.getLibraryData().isProgramManagingAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filterIndexes(IntSet indexes, Predicate<FileDesc> filter) {
        ArrayList<Integer> removeList = null;
        this.rwLock.readLock().lock();
        try {
            IntSet.IntSetIterator iter = indexes.iterator();
            while (iter.hasNext()) {
                int i = iter.next();
                FileDesc fd = this.files.get(i);
                if (filter.apply(fd)) continue;
                if (removeList == null) {
                    removeList = new ArrayList<Integer>();
                }
                removeList.add(i);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (removeList != null) {
            for (Integer i : removeList) {
                indexes.remove(i);
            }
        }
    }

    ListeningFuture<List<ListeningFuture<FileDesc>>> scanFolderAndAddToCollection(final File folder, final FileFilter fileFilter, final FileCollection collection) {
        Objects.nonNull(folder, "folder");
        Objects.nonNull(fileFilter, "fileFilter");
        Objects.nonNull(collection, "collection");
        return this.folderLoader.submit(new Callable<List<ListeningFuture<FileDesc>>>(){
            private final List<ListeningFuture<FileDesc>> futures = new ArrayList<ListeningFuture<FileDesc>>();

            @Override
            public List<ListeningFuture<FileDesc>> call() throws Exception {
                File[] files;
                if (LibraryImpl.this.isDirectoryAllowed(folder) && (files = folder.listFiles(fileFilter)) != null) {
                    this.addFiles(new ArrayList<File>(Arrays.asList(files)));
                }
                return this.futures;
            }

            private void addFiles(List<File> accumulator) {
                while (accumulator.size() > 0) {
                    File folderOrFile = accumulator.remove(0);
                    if (LibraryImpl.this.isDirectoryAllowed(folderOrFile)) {
                        File[] files = folderOrFile.listFiles(fileFilter);
                        if (files == null) continue;
                        accumulator.addAll(Arrays.asList(files));
                        continue;
                    }
                    this.futures.add(collection.add(folderOrFile));
                }
            }
        });
    }

    @Override
    public ListeningFuture<List<ListeningFuture<FileDesc>>> addFolder(File folder, FileFilter fileFilter) {
        return this.scanFolderAndAddToCollection(folder, fileFilter, this);
    }

    @Override
    public boolean isFileAllowed(File file) {
        return LibraryUtils.isFileManagable(file, this.categoryManager);
    }

    @Override
    public void addFileProcessingListener(EventListener<FileProcessingEvent> listener) {
        this.fileProcessingListeners.addListener(listener);
    }

    @Override
    public void removeFileProcessingListener(EventListener<FileProcessingEvent> listener) {
        this.fileProcessingListeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelPendingTasks() {
        this.rwLock.readLock().lock();
        ArrayList<File> files = null;
        try {
            files = new ArrayList<File>(this.fileToFutures.keySet());
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        for (File file : files) {
            this.remove(file);
        }
    }

    @Override
    public int peekPublicSharedListCount() {
        return this.fileData.peekPublicSharedListCount();
    }

    private static class PendingFuture
    extends ListeningFutureTask<FileDesc> {
        public PendingFuture() {
            super(EMPTY_CALLABLE);
        }

        @Override
        public void run() {
        }

        @Override
        public void set(FileDesc v) {
            super.set(v);
        }

        @Override
        public void setException(Throwable t) {
            super.setException(t);
        }
    }

    private class ThreadSafeLibraryIterator
    implements Iterator<FileDesc> {
        private int index = 0;
        private FileDesc preview;

        private ThreadSafeLibraryIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean preview() {
            assert (this.preview == null);
            LibraryImpl.this.rwLock.readLock().lock();
            try {
                while (this.index < LibraryImpl.this.files.size()) {
                    this.preview = (FileDesc)LibraryImpl.this.files.get(this.index);
                    ++this.index;
                    if (this.preview == null) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                LibraryImpl.this.rwLock.readLock().unlock();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.preview != null && !LibraryImpl.this.contains(this.preview)) {
                this.preview = null;
            }
            return this.preview != null || this.preview();
        }

        @Override
        public FileDesc next() {
            if (this.hasNext()) {
                FileDesc item = this.preview;
                this.preview = null;
                return item;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @InspectableContainer
    private class LazyInspectableContainer {
        @InspectionPoint(value="managed files", category=DataCategory.USAGE)
        private final Inspectable inspectable = new Inspectable(){

            @Override
            public Object inspect() {
                HashMap<String, Integer> data = new HashMap<String, Integer>();
                data.put("size", LibraryImpl.this.size());
                return data;
            }
        };

        private LazyInspectableContainer() {
        }
    }
}

