/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AltLocUtils;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.http.AltLocTracker;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.limewire.collection.Function;
import org.limewire.http.HeaderInterceptor;

public class AltLocHeaderInterceptor
implements HeaderInterceptor {
    private final HTTPUploader uploader;
    private final AltLocManager altLocManager;
    private final AlternateLocationFactory alternateLocationFactory;

    public AltLocHeaderInterceptor(HTTPUploader uploader, AltLocManager altLocManager, AlternateLocationFactory alternateLocationFactory) {
        this.uploader = uploader;
        this.altLocManager = altLocManager;
        this.alternateLocationFactory = alternateLocationFactory;
    }

    @Override
    public void process(Header header, HttpContext context) throws HttpException, IOException {
        if (HTTPHeaderName.ALT_LOCATION.matches(header)) {
            this.parseAlternateLocations(this.uploader.getAltLocTracker(), header.getValue(), true, true);
        } else if (HTTPHeaderName.NALTS.matches(header)) {
            this.parseAlternateLocations(this.uploader.getAltLocTracker(), header.getValue(), false, false);
        } else if (HTTPHeaderName.FALT_LOCATION.matches(header)) {
            AltLocTracker tracker = this.uploader.getAltLocTracker();
            this.parseAlternateLocations(tracker, header.getValue(), true, false);
            tracker.setWantsFAlts(true);
        } else if (HTTPHeaderName.BFALT_LOCATION.matches(header)) {
            AltLocTracker tracker = this.uploader.getAltLocTracker();
            this.parseAlternateLocations(tracker, header.getValue(), false, false);
            tracker.setWantsFAlts(false);
        }
    }

    private void parseAlternateLocations(final AltLocTracker tracker, String alternateLocations, final boolean isGood, boolean allowTLS) {
        AltLocUtils.parseAlternateLocations(tracker.getUrn(), alternateLocations, allowTLS, this.alternateLocationFactory, new Function<AlternateLocation, Void>(){

            @Override
            public Void apply(AlternateLocation location) {
                if (location instanceof PushAltLoc) {
                    ((PushAltLoc)location).updateProxies(isGood);
                }
                if (isGood) {
                    AltLocHeaderInterceptor.this.altLocManager.add(location, null);
                } else {
                    AltLocHeaderInterceptor.this.altLocManager.remove(location, null);
                }
                tracker.addLocation(location);
                return null;
            }
        });
    }
}

