/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.io;

import com.google.inject.Provider;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.dht.io.MessageParserDelegate;
import com.limegroup.gnutella.dht.messages.FindNodeRequestWireImpl;
import com.limegroup.gnutella.dht.messages.FindNodeResponseWireImpl;
import com.limegroup.gnutella.dht.messages.FindValueRequestWireImpl;
import com.limegroup.gnutella.dht.messages.FindValueResponseWireImpl;
import com.limegroup.gnutella.dht.messages.MessageFactoryWire;
import com.limegroup.gnutella.dht.messages.PingRequestWireImpl;
import com.limegroup.gnutella.dht.messages.PingResponseWireImpl;
import com.limegroup.gnutella.dht.messages.StatsRequestWireImpl;
import com.limegroup.gnutella.dht.messages.StatsResponseWireImpl;
import com.limegroup.gnutella.dht.messages.StoreRequestWireImpl;
import com.limegroup.gnutella.dht.messages.StoreResponseWireImpl;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.Tag;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.routing.impl.RemoteContact;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;

public class LimeMessageDispatcherImpl
extends org.limewire.mojito.io.MessageDispatcher
implements MessageHandler {
    private static final Log LOG = LogFactory.getLog(LimeMessageDispatcherImpl.class);
    private static final Class[] UDP_MESSAGE_TYPES = new Class[]{PingRequestWireImpl.class, PingResponseWireImpl.class, StoreRequestWireImpl.class, StoreResponseWireImpl.class, FindNodeRequestWireImpl.class, FindNodeResponseWireImpl.class, FindValueRequestWireImpl.class, FindValueResponseWireImpl.class, StatsRequestWireImpl.class, StatsResponseWireImpl.class};
    private volatile boolean running = false;
    private volatile boolean bound = false;
    private final Provider<UDPService> udpService;
    private final Provider<SecureMessageVerifier> secureMessageVerifier;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<MessageDispatcher> messageDispatcher;

    public LimeMessageDispatcherImpl(Context context, Provider<UDPService> udpService, Provider<SecureMessageVerifier> secureMessageVerifier, Provider<MessageRouter> messageRouter, Provider<MessageDispatcher> messageDispatcher, MessageFactory messageFactory) {
        super(context);
        this.udpService = udpService;
        this.secureMessageVerifier = secureMessageVerifier;
        this.messageRouter = messageRouter;
        this.messageDispatcher = messageDispatcher;
        context.setMessageFactory(new MessageFactoryWire(context.getMessageFactory()));
        MessageParserDelegate parser = new MessageParserDelegate(context.getMessageFactory());
        messageFactory.setParser((byte)68, parser);
    }

    @Override
    protected boolean allow(DHTMessage message) {
        return true;
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        assert (!this.bound);
        this.bound = true;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public synchronized void start() {
        for (Class clazz : UDP_MESSAGE_TYPES) {
            this.messageRouter.get().setUDPMessageHandler(clazz, this);
        }
        this.running = true;
        super.start();
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        super.stop();
        for (Class clazz : UDP_MESSAGE_TYPES) {
            this.messageRouter.get().setUDPMessageHandler(clazz, null);
        }
    }

    @Override
    public void close() {
        this.bound = false;
        super.close();
    }

    @Override
    protected boolean submit(Tag tag) {
        InetSocketAddress dst = (InetSocketAddress)tag.getSocketAddress();
        ByteBuffer data = tag.getData();
        this.udpService.get().send(data, dst, true);
        this.register(tag);
        if (LOG.isInfoEnabled()) {
            LOG.info("Sent: " + tag);
        }
        return true;
    }

    @Override
    public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Received message from " + addr + ", " + msg);
        }
        if (!this.isRunning()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Dropping message from " + addr + " because DHT is not running");
            }
            return;
        }
        DHTMessage dhtMessage = (DHTMessage)((Object)msg);
        ((RemoteContact)dhtMessage.getContact()).fixSourceAndContactAddress(addr);
        this.handleMessage(dhtMessage);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    protected void process(Runnable runnable) {
        if (this.isRunning()) {
            this.messageDispatcher.get().dispatch(runnable);
        }
    }

    @Override
    protected void verify(SecureMessage secureMessage, SecureMessageCallback smc) {
        PublicKey pubKey = this.context.getPublicKey();
        if (pubKey == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Dropping SecureMessage " + secureMessage + " because PublicKey is not set");
            }
            return;
        }
        this.secureMessageVerifier.get().verify(pubKey, "SHA1withDSA", secureMessage, smc);
    }
}

