/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.google.inject.Inject;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.util.Clock;

@EagerSingleton
public class ConnectionInspections
implements ConnectionLifecycleListener {
    private final Clock clock;
    private final AtomicLong startedConnecting = new AtomicLong(0L);
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private ConnectionManager connectionManager;
    @InspectablePrimitive(value="time to connect")
    private long connectionTime;
    @InspectablePrimitive(value="time to load")
    private long loadTime;

    @Inject
    public ConnectionInspections(Clock clock) {
        this.clock = clock;
    }

    @Inject
    public void register(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.connectionManager.addEventListener(this);
    }

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
        switch (evt.getType()) {
            case CONNECTING: {
                this.startedConnecting.compareAndSet(0L, this.clock.now());
                break;
            }
            case CONNECTION_INITIALIZED: {
                if (this.connected.getAndSet(true)) break;
                this.connectionTime = this.clock.now() - this.startedConnecting.get();
                this.connectionManager.removeEventListener(this);
            }
        }
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }
}

