/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.limewire.collection.MultiIterable;
import org.limewire.core.settings.MessageSettings;
import org.limewire.inspection.Inspectable;
import org.limewire.io.GUID;
import org.limewire.util.Base32;

public final class RouteTable
implements Inspectable {
    private Map<byte[], RouteTableEntry> _newMap = new ExperimentalGUIDMap();
    private Map<byte[], RouteTableEntry> _oldMap = new ExperimentalGUIDMap();
    private int _mseconds;
    private long _nextSwitchTime;
    private int _maxSize;
    private Map<Integer, ReplyHandler> _idMap = new HashMap<Integer, ReplyHandler>();
    private Map<ReplyHandler, Integer> _handlerMap = new HashMap<ReplyHandler, Integer>();
    private int _nextID;

    public RouteTable(int seconds, int maxSize) {
        this._mseconds = seconds * 1000;
        this._nextSwitchTime = System.currentTimeMillis() + (long)this._mseconds;
        this._maxSize = maxSize;
    }

    public synchronized ResultCounter routeReply(byte[] guid, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        if (!replyHandler.isOpen()) {
            return null;
        }
        int id = this.handler2id(replyHandler);
        RouteTableEntry entry = this._newMap.remove(guid);
        if (entry == null) {
            entry = this._oldMap.remove(guid);
        }
        if (entry == null) {
            entry = new RouteTableEntry(id);
        } else {
            entry.handlerID = id;
        }
        this._newMap.put(guid, entry);
        return entry;
    }

    public synchronized ResultCounter tryToRouteReply(byte[] guid, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        assert (replyHandler != null);
        assert (guid != null) : "Null GUID in tryToRouteReply";
        if (!replyHandler.isOpen()) {
            return null;
        }
        if (!this._newMap.containsKey(guid) && !this._oldMap.containsKey(guid)) {
            int id = this.handler2id(replyHandler);
            RouteTableEntry entry = new RouteTableEntry(id);
            this._newMap.put(guid, entry);
            return entry;
        }
        return null;
    }

    public synchronized void setTTL(ResultCounter entry, byte ttl) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry!!");
        }
        if (!(entry instanceof RouteTableEntry)) {
            throw new IllegalArgumentException("entry is not recognized.");
        }
        if (ttl <= 0) {
            throw new IllegalArgumentException("Input TTL too small: " + ttl);
        }
        ((RouteTableEntry)entry).setTTL(ttl);
    }

    public synchronized boolean getAndSetTTL(byte[] guid, byte getTTL, byte setTTL) {
        if (getTTL < 1 || setTTL <= getTTL) {
            throw new IllegalArgumentException("Bad ttl input (get/set): " + getTTL + "/" + setTTL);
        }
        RouteTableEntry entry = this._newMap.get(guid);
        if (entry == null) {
            entry = this._oldMap.get(guid);
        }
        if (entry != null && entry.getTTL() == getTTL) {
            entry.setTTL(setTTL);
            return true;
        }
        return false;
    }

    public synchronized ReplyHandler getReplyHandler(byte[] guid) {
        this.repOk();
        RouteTableEntry entry = this._newMap.get(guid);
        if (entry == null) {
            entry = this._oldMap.get(guid);
        }
        return entry == null ? null : this.id2handler(new Integer(entry.handlerID));
    }

    public synchronized ReplyRoutePair getReplyHandler(byte[] guid, int replyBytes, short numReplies, short partialReplies) {
        return this.getReplyHandler(guid, replyBytes, numReplies, partialReplies, 0, true);
    }

    public synchronized ReplyRoutePair getReplyHandler(byte[] guid, int replyBytes, short numReplies, short partialReplies, int classCNetwork, boolean count) {
        this.repOk();
        RouteTableEntry entry = this._newMap.get(guid);
        if (entry == null) {
            entry = this._oldMap.get(guid);
        }
        if (entry == null) {
            return null;
        }
        ReplyHandler handler = this.id2handler(new Integer(entry.handlerID));
        if (handler == null) {
            return null;
        }
        ReplyRoutePair ret = new ReplyRoutePair(handler, entry.bytesRouted, entry.repliesRouted);
        if (count) {
            entry.bytesRouted += replyBytes;
            entry.repliesRouted += numReplies;
            entry.partialRepliesRouted += partialReplies;
        } else {
            entry.repliesNotCounted += numReplies;
        }
        if (classCNetwork != 0) {
            entry.updateClassCNetworks(classCNetwork, numReplies);
        }
        return ret;
    }

    public synchronized void timeStampResults(QueryReply reply) {
        RouteTableEntry entry = this._newMap.get(reply.getGUID());
        if (entry == null) {
            entry = this._oldMap.get(reply.getGUID());
        }
        if (entry == null) {
            return;
        }
        entry.timeStampResults(reply.getUniqueResultCount());
    }

    public synchronized void countHopsTTLNet(QueryReply reply) {
        RouteTableEntry entry = this._newMap.get(reply.getGUID());
        if (entry == null) {
            entry = this._oldMap.get(reply.getGUID());
        }
        if (entry == null) {
            return;
        }
        entry.countHopsTTLNet(reply.getNetwork(), reply.getHops(), reply.getTTL());
    }

    public synchronized void removeReplyHandler(ReplyHandler replyHandler) {
        this.repOk();
        assert (replyHandler != null) : "Null replyHandler in removeReplyHandler";
        Integer id = this.handler2id(replyHandler);
        this._idMap.remove(id);
        this._handlerMap.remove(replyHandler);
    }

    private Integer handler2id(ReplyHandler handler) {
        Integer id = this._handlerMap.get(handler);
        if (id != null) {
            return id;
        }
        while (this._idMap.get(id = new Integer(this._nextID++)) != null) {
        }
        this._handlerMap.put(handler, id);
        this._idMap.put(id, handler);
        return id;
    }

    private ReplyHandler id2handler(Integer id) {
        return this._idMap.get(id);
    }

    private final boolean purge() {
        long now = System.currentTimeMillis();
        if (now < this._nextSwitchTime && this._newMap.size() < this._maxSize) {
            return false;
        }
        this._oldMap.clear();
        Map<byte[], RouteTableEntry> tmp = this._oldMap;
        this._oldMap = this._newMap;
        this._newMap = tmp;
        this._nextSwitchTime = now + (long)this._mseconds;
        return true;
    }

    public synchronized String toString() {
        StringBuilder buf = new StringBuilder("{");
        TreeMap<byte[], RouteTableEntry> bothMaps = new TreeMap<byte[], RouteTableEntry>(new GUID.GUIDByteComparator());
        bothMaps.putAll(this._oldMap);
        bothMaps.putAll(this._newMap);
        Iterator iter = bothMaps.keySet().iterator();
        while (iter.hasNext()) {
            byte[] key = (byte[])iter.next();
            buf.append(new GUID(key));
            buf.append("->");
            int id = ((RouteTableEntry)bothMaps.get(key)).handlerID;
            ReplyHandler handler = this.id2handler(new Integer(id));
            buf.append(handler == null ? "null" : handler.toString());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private final void repOk() {
    }

    private static final byte[] zeroOOBBytes(byte[] guid) {
        if (!MessageSettings.GUID_ZERO_EXPERIMENT.getValue()) {
            return guid;
        }
        guid = (byte[])guid.clone();
        for (int i : new int[]{0, 1, 2, 3, 13, 14}) {
            guid[i] = 0;
        }
        return guid;
    }

    @Override
    public synchronized Object inspect() {
        HashMap<String, Object> m;
        HashMap ret = new HashMap();
        MultiIterable<Map.Entry<byte[], RouteTableEntry>> bothMaps = new MultiIterable<Map.Entry<byte[], RouteTableEntry>>((Iterable<Map.Entry<byte[], RouteTableEntry>>)this._newMap.entrySet(), (Iterable<Map.Entry<byte[], RouteTableEntry>>)this._oldMap.entrySet());
        for (Map.Entry entry : bothMaps) {
            RouteTableEntry e = (RouteTableEntry)entry.getValue();
            m = new HashMap<String, Object>();
            m.put("br", e.bytesRouted);
            m.put("ttl", e.ttl);
            m.put("rr", e.repliesRouted);
            m.put("rnc", e.repliesNotCounted);
            m.put("prr", e.partialRepliesRouted);
            m.put("cc", e.classCnetworks.getMap());
            m.put("rt", e.resultTimeStamps);
            m.put("rc", e.resultCounts);
            m.put("ct", e.creationTime);
            m.put("id", e.handlerID);
            m.put("nets", this.getBytes(e.networks));
            m.put("hops", this.getBytes(e.hops));
            m.put("ttls", this.getBytes(e.ttls));
            ret.put(Base32.encode((byte[])entry.getKey()), m);
        }
        Iterator<Object> i$ = this._idMap.keySet().iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            ReplyHandler r = this._idMap.get(n);
            m = new HashMap();
            m.put("ip", r.getAddress());
            m.put("port", r.getPort());
            m.put("cguid", r.getClientGUID());
            ret.put(String.valueOf(n), m);
        }
        return ret;
    }

    private byte[] getBytes(int[] ints) {
        ByteBuffer b = ByteBuffer.allocate(ints.length * 4);
        b.asIntBuffer().put(ints);
        return b.array();
    }

    private static class ExperimentalGUIDMap
    extends TreeMap<byte[], RouteTableEntry> {
        ExperimentalGUIDMap() {
            super(GUID.GUID_BYTE_COMPARATOR);
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof byte[]) {
                key = RouteTable.zeroOOBBytes((byte[])key);
            }
            return super.containsKey(key);
        }

        @Override
        public RouteTableEntry get(Object key) {
            if (key instanceof byte[]) {
                key = RouteTable.zeroOOBBytes((byte[])key);
            }
            return (RouteTableEntry)super.get(key);
        }

        @Override
        public RouteTableEntry put(byte[] key, RouteTableEntry value) {
            key = RouteTable.zeroOOBBytes(key);
            return super.put(key, value);
        }

        @Override
        public RouteTableEntry remove(Object key) {
            if (key instanceof byte[]) {
                key = RouteTable.zeroOOBBytes((byte[])key);
            }
            return (RouteTableEntry)super.remove(key);
        }
    }

    public static final class ReplyRoutePair {
        private final ReplyHandler handler;
        private final int volume;
        private final int REPLIES_ROUTED;

        ReplyRoutePair(ReplyHandler handler, int volume, int hits) {
            this.handler = handler;
            this.volume = volume;
            this.REPLIES_ROUTED = hits;
        }

        public ReplyHandler getReplyHandler() {
            return this.handler;
        }

        public int getBytesRouted() {
            return this.volume;
        }

        public int getResultsRouted() {
            return this.REPLIES_ROUTED;
        }
    }

    private static final class RouteTableEntry
    implements ResultCounter {
        private int handlerID;
        private int bytesRouted;
        private int repliesRouted;
        private int partialRepliesRouted;
        private int repliesNotCounted;
        private byte ttl = 0;
        private final ClassCNetworks classCnetworks = new ClassCNetworks();
        private final long creationTime = System.currentTimeMillis();
        private final List<Double> resultTimeStamps = new ArrayList<Double>();
        private final List<Double> resultCounts = new ArrayList<Double>();
        private final int[] networks = new int[4];
        private final int[] hops = new int[5];
        private final int[] ttls = new int[5];

        RouteTableEntry(int handlerID) {
            this.handlerID = handlerID;
            this.bytesRouted = 0;
            this.repliesRouted = 0;
            this.repliesNotCounted = 0;
        }

        public void setTTL(byte ttl) {
            this.ttl = ttl;
        }

        public byte getTTL() {
            return this.ttl;
        }

        @Override
        public int getNumResults() {
            return Math.max(0, this.repliesRouted - this.partialRepliesRouted);
        }

        void updateClassCNetworks(int classCNetwork, int numReplies) {
            this.classCnetworks.add(classCNetwork, numReplies);
        }

        void timeStampResults(int count) {
            this.resultTimeStamps.add(Double.valueOf(System.currentTimeMillis() - this.creationTime));
            this.resultCounts.add(Double.valueOf(count));
        }

        void countHopsTTLNet(Message.Network network, byte hop, byte ttl) {
            int n = Math.max(0, Math.min(network.ordinal(), this.networks.length - 1));
            this.networks[n] = this.networks[n] + 1;
            int n2 = Math.min(this.hops.length - 1, Math.max(0, hop - 1));
            this.hops[n2] = this.hops[n2] + 1;
            int n3 = Math.min(this.ttls.length - 1, Math.max(0, ttl - 1));
            this.ttls[n3] = this.ttls[n3] + 1;
        }
    }
}

