/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import org.limewire.concurrent.ManagedThread;
import org.limewire.core.api.connection.FirewallStatusEvent;
import org.limewire.core.api.connection.FirewallTransferStatus;
import org.limewire.core.api.connection.FirewallTransferStatusEvent;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.core.settings.LimeProps;
import org.limewire.core.settings.SearchSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GUID;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.BroadcastPolicy;
import org.limewire.listener.CachingEventMulticasterImpl;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ProxySettings;
import org.limewire.net.address.AddressEvent;
import org.limewire.net.address.FirewalledAddress;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.ssl.SSLEngineTest;
import org.limewire.nio.ssl.SSLUtils;
import org.limewire.service.ErrorService;
import org.limewire.setting.BooleanSetting;

@EagerSingleton
public class NetworkManagerImpl
implements NetworkManager {
    private static final Log LOG = LogFactory.getLog(NetworkManagerImpl.class);
    private final Provider<UDPService> udpService;
    private final Provider<Acceptor> acceptor;
    private final Provider<DHTManager> dhtManager;
    private final Provider<ConnectionManager> connectionManager;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Provider<CapabilitiesVMFactory> capabilitiesVMFactory;
    private final Provider<ByteBufferCache> bbCache;
    private final Object addressLock = new Object();
    private volatile Connectable directAddress;
    private volatile FirewalledAddress firewalledAddress;
    private volatile boolean tlsSupported = true;
    @InspectablePrimitive(value="reason tls failed")
    private volatile String tlsDisabledReason;
    private final EventMulticaster<AddressEvent> listeners = new CachingEventMulticasterImpl<AddressEvent>(BroadcastPolicy.IF_NOT_EQUALS);
    private final ApplicationServices applicationServices;
    private volatile boolean started;
    private volatile Set<Connectable> cachedProxies;
    private final ProxySettings proxySettings;

    @Inject
    public NetworkManagerImpl(Provider<UDPService> udpService, Provider<Acceptor> acceptor, Provider<DHTManager> dhtManager, Provider<ConnectionManager> connectionManager, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils, Provider<CapabilitiesVMFactory> capabilitiesVMFactory, Provider<ByteBufferCache> bbCache, ApplicationServices applicationServices, ProxySettings proxySettings) {
        this.udpService = udpService;
        this.acceptor = acceptor;
        this.dhtManager = dhtManager;
        this.connectionManager = connectionManager;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.bbCache = bbCache;
        this.applicationServices = applicationServices;
        this.proxySettings = proxySettings;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Inject
    void register(ListenerSupport<FirewallStatusEvent> firewallStatusSupport, ListenerSupport<FirewallTransferStatusEvent> firewallTransferStatusSupport) {
        firewallStatusSupport.addListener(new EventListener<FirewallStatusEvent>(){

            @Override
            public void handleEvent(FirewallStatusEvent event) {
                if (NetworkManagerImpl.this.started) {
                    NetworkManagerImpl.this.maybeFireNewDirectConnectionAddress();
                }
            }
        });
        firewallTransferStatusSupport.addListener(new EventListener<FirewallTransferStatusEvent>(){
            private volatile FirewallTransferStatus lastStatus = null;

            @Override
            public void handleEvent(FirewallTransferStatusEvent event) {
                if (NetworkManagerImpl.this.started && this.lastStatus != event.getData()) {
                    this.lastStatus = (FirewallTransferStatus)((Object)event.getData());
                    NetworkManagerImpl.this.updateCapabilities();
                }
            }
        });
    }

    @Override
    public void start() {
        if (this.isIncomingTLSEnabled() || this.isOutgoingTLSEnabled()) {
            if (this.applicationServices.isNewInstall() || this.applicationServices.isNewJavaVersion() || !SSLSettings.TLS_WORKED_LAST_TIME.getValue()) {
                this.validateTLS();
            } else {
                new ManagedThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkManagerImpl.this.validateTLS();
                    }
                }, "NetworkManagerImpl.testTLS").start();
            }
        }
        this.started = true;
    }

    @Override
    public void validateTLS() {
        if (this.isIncomingTLSEnabled() || this.isOutgoingTLSEnabled()) {
            SSLEngineTest sslTester = new SSLEngineTest(SSLUtils.getTLSContext(), SSLUtils.getTLSCipherSuites(), this.bbCache.get());
            if (!sslTester.go()) {
                Throwable t = sslTester.getLastFailureCause();
                this.setTLSNotSupported(t);
                if (!SSLSettings.IGNORE_SSL_EXCEPTIONS.getValue() && !sslTester.isIgnorable(t)) {
                    ErrorService.error(t);
                }
            }
            SSLSettings.TLS_WORKED_LAST_TIME.setValue(this.tlsSupported);
        }
    }

    @Override
    public void stop() {
        this.started = false;
        ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(this.acceptedIncomingConnection());
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Network Management");
    }

    @Override
    public boolean isIpPortValid() {
        return NetworkUtils.isValidAddress(this.getAddress()) && NetworkUtils.isValidPort(this.getPort());
    }

    @Override
    public GUID getUDPConnectBackGUID() {
        return this.udpService.get().getConnectBackGUID();
    }

    @Override
    public boolean isOOBCapable() {
        if (SearchSettings.FORCE_OOB.getValue()) {
            return true;
        }
        return this.isGUESSCapable() && this.outOfBandStatistics.isSuccessRateGood() && !this.networkInstanceUtils.isPrivate() && SearchSettings.OOB_ENABLED.getValue() && this.acceptor.get().isAddressExternal() && this.isIpPortValid();
    }

    @Override
    public boolean isGUESSCapable() {
        return this.udpService.get().isGUESSCapable() && !this.isProxyEnabled();
    }

    @Override
    public int getNonForcedPort() {
        return this.acceptor.get().getPort(false);
    }

    @Override
    public int getPort() {
        return this.acceptor.get().getPort(true);
    }

    @Override
    public byte[] getNonForcedAddress() {
        return this.acceptor.get().getAddress(false);
    }

    @Override
    public byte[] getAddress() {
        return this.acceptor.get().getAddress(true);
    }

    @Override
    public byte[] getExternalAddress() {
        return this.acceptor.get().getExternalAddress();
    }

    @Override
    public boolean incomingStatusChanged() {
        this.updateCapabilities();
        byte[] addr = this.getAddress();
        int port = this.getPort();
        if (!NetworkUtils.isValidAddress(addr)) {
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(addr)) {
            return false;
        }
        return NetworkUtils.isValidPort(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCapabilities() {
        this.capabilitiesVMFactory.get().updateCapabilities();
        if (this.connectionManager.get().isShieldedLeaf()) {
            this.connectionManager.get().sendUpdatedCapabilities();
        }
        Object object = this.addressLock;
        synchronized (object) {
            FirewalledAddress address = this.firewalledAddress;
            if (address != null) {
                this.newPushProxies(address.getPushProxies());
            }
        }
    }

    @Override
    public boolean addressChanged() {
        byte[] addr = this.getAddress();
        int port = this.getPort();
        if (!NetworkUtils.isValidAddress(addr)) {
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(addr)) {
            return false;
        }
        if (!NetworkUtils.isValidPort(port)) {
            return false;
        }
        this.acceptor.get().resetLastConnectBackTime();
        this.dhtManager.get().addressChanged();
        Properties props = new Properties();
        props.put("Listen-IP", NetworkUtils.ip2string(addr) + ":" + port);
        HeaderUpdateVendorMessage huvm = new HeaderUpdateVendorMessage(props);
        for (RoutedConnection c : this.connectionManager.get().getInitializedConnections()) {
            if (c.getConnectionCapabilities().remoteHostSupportsHeaderUpdate() < 1) continue;
            c.send(huvm);
        }
        for (RoutedConnection c : this.connectionManager.get().getInitializedClientConnections()) {
            if (c.getConnectionCapabilities().remoteHostSupportsHeaderUpdate() < 1) continue;
            c.send(huvm);
        }
        return true;
    }

    @Override
    public void externalAddressChanged() {
        this.maybeFireNewDirectConnectionAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeFireNewDirectConnectionAddress() {
        Connectable newDirectAddress = null;
        boolean fireEvent = false;
        Set<Connectable> proxies = null;
        Object object = this.addressLock;
        synchronized (object) {
            if (this.isDirectConnectionCapable()) {
                newDirectAddress = this.getPublicAddress(false);
                if (this.directAddress == null || ConnectableImpl.COMPARATOR.compare(this.directAddress, newDirectAddress) != 0) {
                    this.directAddress = newDirectAddress;
                    fireEvent = true;
                    assert (NetworkUtils.isValidIpPort(newDirectAddress));
                }
            } else {
                this.directAddress = null;
                proxies = this.cachedProxies;
                this.cachedProxies = null;
            }
        }
        if (fireEvent) {
            this.fireAddressChange(newDirectAddress);
        } else if (proxies != null) {
            this.newPushProxies(proxies);
        }
    }

    private boolean isDirectConnectionCapable() {
        return NetworkUtils.isValidAddress(this.getExternalAddress()) && this.acceptedIncomingConnection() && NetworkUtils.isValidPort(this.getPort());
    }

    @Override
    public void portChanged() {
        this.maybeFireNewDirectConnectionAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newPushProxies(Set<Connectable> pushProxies) {
        Connectable publicAddress = this.getPublicAddress(this.canDoFWT());
        if (!NetworkUtils.isValidIpPort(publicAddress)) {
            this.cachedProxies = pushProxies;
            return;
        }
        FirewalledAddress newAddress = new FirewalledAddress(publicAddress, this.getPrivateAddress(), new GUID(this.applicationServices.getMyGUID()), pushProxies, this.supportsFWTVersion());
        boolean changed = false;
        Object object = this.addressLock;
        synchronized (object) {
            if (!newAddress.equals(this.firewalledAddress) && this.directAddress == null) {
                this.firewalledAddress = newAddress;
                assert (this.firewalledAddress.getFwtVersion() == 0 || NetworkUtils.isValidIpPort(this.firewalledAddress.getPublicAddress()));
                changed = true;
            }
        }
        if (changed) {
            this.fireAddressChange(newAddress);
        }
    }

    private Connectable getPublicAddress(boolean udpPort) {
        try {
            return new ConnectableImpl(NetworkUtils.ip2string(this.getExternalAddress()), udpPort ? this.getStableUDPPort() : this.getPort(), this.isIncomingTLSEnabled());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Connectable getPublicAddress() {
        return this.getPublicAddress(!this.acceptedIncomingConnection());
    }

    private Connectable getPrivateAddress() {
        byte[] privateAddress = this.getNonForcedAddress();
        try {
            return new ConnectableImpl(new InetSocketAddress(InetAddress.getByAddress(privateAddress), this.getNonForcedPort()), this.isIncomingTLSEnabled());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean acceptedIncomingConnection() {
        return this.acceptor.get().acceptedIncoming();
    }

    @Override
    public void setListeningPort(int port) throws IOException {
        this.acceptor.get().setListeningPort(port);
    }

    @Override
    public boolean canReceiveUnsolicited() {
        return this.udpService.get().canReceiveUnsolicited() && !this.isProxyEnabled();
    }

    private boolean isProxyEnabled() {
        return this.proxySettings.getCurrentProxyType() != ProxySettings.ProxyType.NONE;
    }

    @Override
    public boolean canReceiveSolicited() {
        return this.udpService.get().canReceiveSolicited() && !this.isProxyEnabled();
    }

    @Override
    public boolean canDoFWT() {
        return this.udpService.get().canDoFWT() && !this.isProxyEnabled();
    }

    @Override
    public int getStableUDPPort() {
        return this.udpService.get().getStableUDPPort();
    }

    @Override
    public GUID getSolicitedGUID() {
        return this.udpService.get().getSolicitedGUID();
    }

    @Override
    public int supportsFWTVersion() {
        return this.canDoFWT() ? 1 : 0;
    }

    public boolean isPrivateAddress(byte[] addr) {
        return this.networkInstanceUtils.isPrivateAddress(addr);
    }

    private void setTLSNotSupported(Throwable reason) {
        this.tlsSupported = false;
        if (reason != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            reason.printStackTrace(pw);
            pw.flush();
            this.tlsDisabledReason = writer.getBuffer().toString();
        } else {
            this.tlsDisabledReason = null;
        }
    }

    @Override
    public boolean isTLSSupported() {
        return this.tlsSupported && !this.isProxyEnabled();
    }

    @Override
    public boolean isIncomingTLSEnabled() {
        return this.isTLSSupported() && SSLSettings.TLS_INCOMING.getValue();
    }

    @Override
    public void setIncomingTLSEnabled(boolean enabled) {
        SSLSettings.TLS_INCOMING.setValue(enabled);
    }

    @Override
    public boolean isOutgoingTLSEnabled() {
        return this.isTLSSupported() && SSLSettings.TLS_OUTGOING.getValue();
    }

    @Override
    public void setOutgoingTLSEnabled(boolean enabled) {
        SSLSettings.TLS_OUTGOING.setValue(enabled);
    }

    @Override
    public void addListener(EventListener<AddressEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<AddressEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    private void fireAddressChange(Address newAddress) {
        LOG.debugf("firing new address: {0}", (Object)newAddress);
        this.listeners.broadcast(new AddressEvent(newAddress, AddressEvent.Type.ADDRESS_CHANGED));
    }

    private static class SSLSettings
    extends LimeProps {
        public static final BooleanSetting TLS_WORKED_LAST_TIME = FACTORY.createBooleanSetting("TLS_WORKED_LAST_TIME", false);
        public static final BooleanSetting TLS_INCOMING = FACTORY.createBooleanSetting("TLS_INCOMING", true);
        public static final BooleanSetting TLS_OUTGOING = FACTORY.createBooleanSetting("TLS_OUTGOING", true);
        public static final BooleanSetting IGNORE_SSL_EXCEPTIONS = FACTORY.createRemoteBooleanSetting("IGNORE_SSL_EXCEPTIONS", true, "TLS.ignoreException");

        private SSLSettings() {
        }
    }
}

