/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class Logger {
    private String name;
    private static boolean use_trace;
    private static boolean use_throw;

    private static Location getLocation(int depth) {
        StackTraceElement[] e = new Exception("Stack trace").getStackTrace();
        if (e != null && e.length > 1) {
            for (int i = depth; i < e.length; ++i) {
                if (e[i].getClassName().startsWith("org.videolan.Logger")) continue;
                return new Location(e[i]);
            }
        }
        return new Location();
    }

    private static PrintStream createCapture(PrintStream printStream, final boolean error) throws UnsupportedEncodingException {
        return new PrintStream(printStream, false, "UTF-8"){

            @Override
            public void print(String string) {
                Logger.log(error, string);
            }

            @Override
            public void println(String string) {
                Logger.log(error, string);
            }
        };
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    private Logger(String name) {
        this.name = name;
    }

    private static native void logN(boolean var0, String var1, int var2, String var3);

    private static void log(boolean error, String cls, String msg) {
        Logger.logN(error, cls, 0, msg);
    }

    private static void log(boolean error, String msg) {
        Location l = Logger.getLocation(3);
        Logger.logN(error, l.file + ":" + l.cls + "." + l.func, l.line, msg);
    }

    public void trace(String msg) {
        if (use_trace) {
            Logger.log(false, this.name, msg);
        }
    }

    public void info(String msg) {
        Logger.log(false, this.name, "INFO: " + msg);
    }

    public void warning(String msg) {
        Logger.log(false, this.name, "WARNING: " + msg);
    }

    public void error(String msg) {
        Logger.log(true, this.name, "ERROR: " + msg);
    }

    public void unimplemented() {
        this.unimplemented(null);
    }

    private static String printStackTrace(StackTraceElement[] e, int offset) {
        if (e != null && e.length > 1) {
            StringBuffer dump = new StringBuffer();
            dump.append("\t");
            dump.append(e[offset].toString());
            for (int i = offset + 1; i < e.length; ++i) {
                dump.append("\n\t");
                dump.append(e[i].toString());
            }
            return dump.toString();
        }
        return "";
    }

    public static String dumpStack() {
        StackTraceElement[] e = new Exception("Stack trace").getStackTrace();
        return Logger.printStackTrace(e, 2);
    }

    public static String dumpStack(Throwable t) {
        StackTraceElement[] e = t.getStackTrace();
        return Logger.printStackTrace(e, 0);
    }

    public void unimplemented(String func) {
        String location = this.name;
        if (func != null) {
            location = location + "." + func + "()";
        }
        Logger.log(true, "UNIMPLEMENTED: " + location + "\n" + Logger.dumpStack());
        if (use_throw) {
            throw new Error("Not implemented: " + location);
        }
    }

    public static void unimplemented(String cls, String func) {
        if (cls == null) {
            cls = "<?>";
        }
        func = func == null ? "" : "." + func + "()";
        String location = cls + func;
        Logger.log(true, "UNIMPLEMENTED: " + location + "\n" + Logger.dumpStack());
        if (use_throw) {
            throw new Error("Not implemented: " + location);
        }
    }

    static {
        use_throw = false;
        use_trace = false;
        try {
            System.setOut(Logger.createCapture(System.out, false));
            System.setErr(Logger.createCapture(System.err, true));
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println("Error capturing stdout/stderr: " + uee);
        }
        String prop = System.getProperty("debug.unimplemented.throw");
        if (prop != null && prop.equalsIgnoreCase("YES")) {
            use_throw = true;
        }
        if ((prop = System.getProperty("debug.trace")) == null || !prop.equalsIgnoreCase("NO")) {
            use_trace = true;
        }
    }

    private static class Location {
        public int line = 0;
        public String file = "?";
        public String cls = "?";
        public String func = "?";

        Location() {
        }

        Location(StackTraceElement e) {
            this.line = e.getLineNumber();
            this.file = e.getFileName();
            this.cls = e.getClassName();
            this.func = e.getMethodName();
            if (this.file == null) {
                this.file = "<unknown.java>";
            }
        }
    }
}

