# N.B. THIS IS NOT DIRECTLY RUN BY KODI - IS JUST AN AID FOR DEVELOPMENT
# Gives python and JS ready lists of BOM radar locations, run by:
# python3 bom_radar_scrape_latest.py

import re
import requests
# noinspection PyUnresolvedReferences
from pprint import pprint
from bs4 import BeautifulSoup

# The master page for the BOM radars
radar_page = "http://www.bom.gov.au/australia/radar/about/radar_site_info.shtml"
# Needed to bypass the BOM's stupid web scraping filter
headers = {'User-Agent':'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:88.0) Gecko/20100101 Firefox/88.0'}

r = requests.get(radar_page, headers=headers)
soup = BeautifulSoup(r.text, 'html.parser')

content = soup.find(id="content")
anchors = content.find_all("a")

# pprint(anchors)

python_var = ""
javascript_var = ""

# The last anchor is not a list of anchors, but loop through the rest to scrape the actual radars...
for anchor in anchors[:-1]:
    href = anchor.get('href')

    radar_page = "http://www.bom.gov.au" + href
    python_var += f'    # {radar_page}\n'
    javascript_var += f'    // {radar_page}\n'

    r = requests.get(radar_page, headers=headers)
    soup = BeautifulSoup(r.text, 'html.parser')

    site_infos = soup.find_all('div', class_='site-info')

    for site_info in site_infos:

        # Get the radar name
        name_element = site_info.find("h2")
        if not name_element:
            print(f"Warning: No h2 element found in site-info, skipping...")
            continue

        name = name_element.text.strip()

        # Get the radar code like IDR023
        link_item = site_info.find('li', class_='link')
        if not link_item:
            print(f"Warning: No li with class='link' found for {name}, skipping...")
            continue

        anchor = link_item.find('a')
        if not anchor:
            print(f"Warning: No anchor found in link li for {name}, skipping...")
            continue

        href_attr = anchor.get('href')
        if not href_attr:
            print(f"Warning: No href attribute found for {name}, skipping...")
            continue

        radar_code_matches = re.search(r'IDR\d+', href_attr)
        if not radar_code_matches:
            print(f"Warning: No IDR code found in href for {name}, skipping...")
            continue

        radar_code = radar_code_matches.group(0)

        # Get the latitude and longitude
        lat_lon_li = site_info.find('li')
        if not lat_lon_li:
            print(f"Warning: No li element found for coordinates for {name}, skipping...")
            continue

        text = lat_lon_li.text
        text = text.replace("\n", "")
        lat_lon_matches = re.findall(r'([+-]?[0-9]+\.[0-9]+)', lat_lon_li.text)

        if len(lat_lon_matches) < 2:
            print(f"Warning: Could not extract lat/lon coordinates for {name}, skipping...")
            continue

        # bizarrely Mildura is the only one that has the '-' in the latitude, the rest all say 'south'
        lat = lat_lon_matches[0]
        if lat.startswith('-'):
            lat = lat[1:]  # Remove the leading minus sign

        lon = lat_lon_matches[1]

        python_var += f'    (-{lat}, {lon}, "{name}", "{radar_code}"),\n'
        javascript_var += f'    [-{lat}, {lon}, "{name}", "{radar_code}"],\n'

# Remove the final newline for neatness
python_var = python_var.rstrip('\n,')
javascript_var = javascript_var.rstrip('\n,')

# Finally, print the Python
print(f"\n\n# (Python) Automatically generated by bom_radar_scraper_latest.py from {radar_page}")
print("BOM_RADAR_LOCATIONS = [")
print(python_var)
print("]\n\n")

# & print the Javascript version
print(f"// (Javascript) Automatically generated by bom_radar_scraper_latest.py from {radar_page}")
print("const bomRadarLocations = [")
print(javascript_var)
print("]\n\n")
