/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.kawa.io.BinaryInPort;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.U8Vector;
import java.nio.charset.Charset;

public class Blob
extends U8Vector
implements Consumable,
CharSequence {
    private String stringValue;
    Charset charset;

    public Blob(byte[] data) {
        super(data);
    }

    public Blob(byte[] data, Charset charset) {
        super(data);
        this.charset = charset;
    }

    public static Blob wrap(byte[] data, int size) {
        Blob blob = new Blob(data);
        blob.size = size;
        return blob;
    }

    public U8Vector asPlainBytevector() {
        U8Vector vec = new U8Vector(this.data);
        vec.size = this.size;
        return vec;
    }

    @Override
    public void consume(Consumer out) {
        out.write(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Blob blob = this;
        synchronized (blob) {
            if (this.stringValue == null) {
                BinaryInPort in = new BinaryInPort(this.data, this.size, null);
                StringBuilder buf = new StringBuilder();
                try {
                    int ch;
                    boolean bomSeen = false;
                    if (this.charset != null) {
                        bomSeen = in.setFromByteOrderMark();
                    }
                    if (!bomSeen) {
                        in.setCharset(this.charset != null ? this.charset : Charset.defaultCharset());
                    }
                    while ((ch = in.read()) >= 0) {
                        buf.append((char)ch);
                    }
                }
                catch (Exception ex) {
                    buf.append("[unexpected exception: ");
                    buf.append(ex);
                    buf.append(']');
                }
                this.stringValue = buf.toString();
            }
            return this.stringValue;
        }
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }
}

