/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.expr.Keyword;
import gnu.kawa.xml.XmlNamespace;
import gnu.lists.AbstractSequence;
import gnu.lists.Consumable;
import gnu.lists.PositionConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.UnescapedData;
import gnu.lists.XConsumer;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.math.DFloNum;
import gnu.math.RealNum;
import gnu.text.Char;
import gnu.text.Path;
import gnu.xml.NamespaceBinding;
import gnu.xml.NodeTree;
import gnu.xml.XName;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;

public class XMLPrinter
extends OutPort
implements PositionConsumer,
XConsumer {
    public int printIndent = -1;
    public boolean indentAttributes;
    boolean printXMLdecl = false;
    boolean inDocument;
    boolean inAttribute = false;
    boolean inStartTag = false;
    int inComment;
    boolean needXMLdecl = false;
    boolean canonicalize = true;
    public boolean canonicalizeCDATA;
    public int useEmptyElementTag = 2;
    public boolean escapeText = true;
    public boolean escapeNonAscii = true;
    boolean isHtml = false;
    boolean undeclareNamespaces = false;
    Object style;
    public static final ThreadLocation doctypeSystem = new ThreadLocation("doctype-system");
    public static final ThreadLocation doctypePublic = new ThreadLocation("doctype-public");
    public static final ThreadLocation indentLoc = new ThreadLocation("xml-indent");
    public boolean strict;
    NamespaceBinding namespaceBindings = NamespaceBinding.predefinedXML;
    NamespaceBinding[] namespaceSaveStack = new NamespaceBinding[20];
    Object[] elementNameStack = new Object[20];
    int elementNesting;
    private static final int WORD = -2;
    private static final int ELEMENT_START = -3;
    private static final int ELEMENT_END = -4;
    private static final int COMMENT = -5;
    private static final int KEYWORD = -6;
    int prev = 32;
    char savedHighSurrogate;
    static final String HtmlEmptyTags = "/area/base/basefont/br/col/frame/hr/img/input/isindex/link/meta/para/";

    public void setPrintXMLdecl(boolean bl) {
        this.printXMLdecl = bl;
    }

    public XMLPrinter(OutPort outPort, boolean bl) {
        super(outPort, bl);
    }

    public XMLPrinter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public XMLPrinter(OutputStream outputStream, boolean bl) {
        super((Writer)new OutputStreamWriter(outputStream), true, bl);
    }

    public XMLPrinter(Writer writer) {
        super(writer);
    }

    public XMLPrinter(OutputStream outputStream) {
        super((Writer)new OutputStreamWriter(outputStream), false, false);
    }

    public XMLPrinter(OutputStream outputStream, Path path) {
        super(new OutputStreamWriter(outputStream), true, false, path);
    }

    public static XMLPrinter make(OutPort outPort, Object object2) {
        XMLPrinter xMLPrinter = new XMLPrinter(outPort, true);
        xMLPrinter.setStyle(object2);
        return xMLPrinter;
    }

    public static String toString(Object object2) {
        StringWriter stringWriter = new StringWriter();
        new XMLPrinter(stringWriter).writeObject(object2);
        return stringWriter.toString();
    }

    public void setStyle(Object object2) {
        this.style = object2;
        int n = this.useEmptyElementTag = this.canonicalize ? 0 : 1;
        if ("html".equals(object2)) {
            this.isHtml = true;
            this.useEmptyElementTag = 2;
            if (this.namespaceBindings == NamespaceBinding.predefinedXML) {
                this.namespaceBindings = XmlNamespace.HTML_BINDINGS;
            }
        } else if (this.namespaceBindings == XmlNamespace.HTML_BINDINGS) {
            this.namespaceBindings = NamespaceBinding.predefinedXML;
        }
        if ("xhtml".equals(object2)) {
            this.useEmptyElementTag = 2;
        }
        if ("plain".equals(object2)) {
            this.escapeText = false;
        }
    }

    boolean mustHexEscape(int n) {
        return n >= 127 && (n <= 159 || this.escapeNonAscii) || n == 8232 || n < 32 && (this.inAttribute || n != 9 && n != 10);
    }

    public void write(int n) {
        this.closeTag();
        if (this.printIndent >= 0 && (n == 13 || n == 10)) {
            if (n != 10 || this.prev != 13) {
                this.writeBreak(82);
            }
            if (this.inComment > 0) {
                this.inComment = 1;
            }
            return;
        }
        if (!this.escapeText) {
            this.bout.write(n);
            this.prev = n;
        } else if (this.inComment > 0) {
            if (n == 45) {
                if (this.inComment == 1) {
                    this.inComment = 2;
                } else {
                    this.bout.write(32);
                }
            } else {
                this.inComment = 1;
            }
            super.write(n);
        } else {
            this.prev = 59;
            if (!(n != 60 || this.isHtml && this.inAttribute)) {
                this.bout.write("&lt;");
            } else if (n == 62) {
                this.bout.write("&gt;");
            } else if (n == 38) {
                this.bout.write("&amp;");
            } else if (n == 34 && this.inAttribute) {
                this.bout.write("&quot;");
            } else if (this.mustHexEscape(n)) {
                int n2 = n;
                if (n >= 55296) {
                    if (n < 56320) {
                        this.savedHighSurrogate = (char)n;
                        return;
                    }
                    if (n < 57344) {
                        n2 = (this.savedHighSurrogate - 55296) * 1024 + (n2 - 56320) + 65536;
                        this.savedHighSurrogate = '\u0000';
                    }
                }
                this.bout.write("&#x" + Integer.toHexString(n2).toUpperCase() + ";");
            } else {
                this.bout.write(n);
                this.prev = n;
            }
        }
    }

    private void startWord() {
        this.closeTag();
        this.writeWordStart();
    }

    public void writeBoolean(boolean bl) {
        this.startWord();
        super.print(bl);
        this.writeWordEnd();
    }

    protected void startNumber() {
        this.startWord();
    }

    protected void endNumber() {
        this.writeWordEnd();
    }

    public void closeTag() {
        if (this.inStartTag && !this.inAttribute) {
            if (this.printIndent >= 0 && this.indentAttributes) {
                this.endLogicalBlock("");
            }
            this.bout.write(62);
            this.inStartTag = false;
            this.prev = -3;
        } else if (this.needXMLdecl) {
            this.bout.write("<?xml version=\"1.0\"?>\n");
            if (this.printIndent >= 0) {
                this.startLogicalBlock("", "", 2);
            }
            this.needXMLdecl = false;
        }
    }

    void setIndentMode() {
        String string;
        Object object2 = indentLoc.get(null);
        String string2 = string = object2 == null ? null : object2.toString();
        this.printIndent = string == null ? -1 : (string.equals("pretty") ? 0 : (string.equals("always") || string.equals("yes") ? 1 : -1));
    }

    public void startDocument() {
        if (this.printXMLdecl) {
            this.needXMLdecl = true;
        }
        this.setIndentMode();
        this.inDocument = true;
        if (this.printIndent >= 0 && !this.needXMLdecl) {
            this.startLogicalBlock("", "", 2);
        }
    }

    public void endDocument() {
        this.inDocument = false;
        if (this.printIndent >= 0) {
            this.endLogicalBlock("");
        }
        this.freshLine();
    }

    public void beginEntity(Object object2) {
    }

    public void endEntity() {
    }

    protected void writeQName(Object object2) {
        if (object2 instanceof Symbol) {
            Symbol symbol = (Symbol)object2;
            String string = symbol.getPrefix();
            if (string != null && string.length() > 0) {
                this.bout.write(string);
                this.bout.write(58);
            }
            this.bout.write(symbol.getLocalPart());
        } else {
            this.bout.write(object2 == null ? "{null name}" : (String)object2);
        }
    }

    public void startElement(Object object2) {
        NamespaceBinding[] namespaceBindingArray;
        Object[] objectArray;
        Object object3;
        Object object4;
        this.closeTag();
        if (this.elementNesting == 0) {
            if (!this.inDocument) {
                this.setIndentMode();
            }
            if ((object4 = doctypeSystem.get(null)) != null && (object3 = object4.toString()).length() > 0) {
                objectArray = doctypePublic.get(null);
                this.bout.write("<!DOCTYPE ");
                this.bout.write(object2.toString());
                NamespaceBinding[] namespaceBindingArray2 = namespaceBindingArray = objectArray == null ? null : objectArray.toString();
                if (namespaceBindingArray != null && namespaceBindingArray.length() > 0) {
                    this.bout.write(" PUBLIC \"");
                    this.bout.write((String)namespaceBindingArray);
                    this.bout.write("\" \"");
                } else {
                    this.bout.write(" SYSTEM \"");
                }
                this.bout.write((String)object3);
                this.bout.write("\">");
                this.println();
            }
        }
        if (this.printIndent >= 0) {
            if (this.prev == -3 || this.prev == -4 || this.prev == -5) {
                this.writeBreak(this.printIndent > 0 ? 82 : 78);
            }
            this.startLogicalBlock("", "", 2);
        }
        this.bout.write(60);
        this.writeQName(object2);
        if (this.printIndent >= 0 && this.indentAttributes) {
            this.startLogicalBlock("", "", 2);
        }
        this.elementNameStack[this.elementNesting] = object2;
        object4 = null;
        this.namespaceSaveStack[this.elementNesting++] = this.namespaceBindings;
        if (object2 instanceof XName) {
            object4 = ((XName)object2).namespaceNodes;
            object3 = NamespaceBinding.commonAncestor((NamespaceBinding)object4, this.namespaceBindings);
            int n = object4 == null ? 0 : ((NamespaceBinding)object4).count((NamespaceBinding)object3);
            namespaceBindingArray = new NamespaceBinding[n];
            int n2 = 0;
            boolean bl = this.canonicalize;
            Object object5 = object4;
            while (object5 != object3) {
                block24: {
                    int n3 = n2;
                    boolean bl2 = false;
                    String string = ((NamespaceBinding)object5).getUri();
                    String string2 = ((NamespaceBinding)object5).getPrefix();
                    while (--n3 >= 0) {
                        NamespaceBinding namespaceBinding = namespaceBindingArray[n3];
                        String string3 = namespaceBinding.getPrefix();
                        if (string2 != string3) {
                            if (!bl) continue;
                            if (string2 == null || string3 != null && string2.compareTo(string3) <= 0) break;
                            namespaceBindingArray[n3 + 1] = namespaceBinding;
                            continue;
                        }
                        break block24;
                    }
                    n3 = bl ? ++n3 : n2;
                    namespaceBindingArray[n3] = object5;
                    ++n2;
                }
                object5 = ((NamespaceBinding)object5).next;
            }
            n2 = n = n2;
            while (--n2 >= 0) {
                object5 = namespaceBindingArray[n2];
                String string = ((NamespaceBinding)object5).uri;
                String string4 = ((NamespaceBinding)object5).prefix;
                if (string == this.namespaceBindings.resolve(string4) || string == null && string4 != null && !this.undeclareNamespaces) continue;
                this.bout.write(32);
                if (string4 == null) {
                    this.bout.write("xmlns");
                } else {
                    this.bout.write("xmlns:");
                    this.bout.write(string4);
                }
                this.bout.write("=\"");
                this.inAttribute = true;
                if (string != null) {
                    this.write(string);
                }
                this.inAttribute = false;
                this.bout.write(34);
            }
            if (this.undeclareNamespaces) {
                object5 = this.namespaceBindings;
                while (object5 != object3) {
                    String string = ((NamespaceBinding)object5).prefix;
                    if (((NamespaceBinding)object5).uri != null && ((NamespaceBinding)object4).resolve(string) == null) {
                        this.bout.write(32);
                        if (string == null) {
                            this.bout.write("xmlns");
                        } else {
                            this.bout.write("xmlns:");
                            this.bout.write(string);
                        }
                        this.bout.write("=\"\"");
                    }
                    object5 = ((NamespaceBinding)object5).next;
                }
            }
            this.namespaceBindings = object4;
        }
        if (this.elementNesting >= this.namespaceSaveStack.length) {
            object3 = new NamespaceBinding[2 * this.elementNesting];
            System.arraycopy(this.namespaceSaveStack, 0, object3, 0, this.elementNesting);
            this.namespaceSaveStack = object3;
            objectArray = new Object[2 * this.elementNesting];
            System.arraycopy(this.elementNameStack, 0, objectArray, 0, this.elementNesting);
            this.elementNameStack = objectArray;
        }
        this.inStartTag = true;
        if (this.isHtml) {
            Object object6 = object3 = object2 instanceof Symbol ? ((Symbol)object2).getLocalPart() : object2.toString();
            if ("script".equals(object3) || "style".equals(object3)) {
                this.escapeText = false;
            }
        }
    }

    public static boolean isHtmlEmptyElementTag(String string) {
        int n = HtmlEmptyTags.indexOf(string);
        return n > 0 && HtmlEmptyTags.charAt(n - 1) == '/' && HtmlEmptyTags.charAt(n + string.length()) == '/';
    }

    public void endElement() {
        String string;
        if (this.useEmptyElementTag == 0) {
            this.closeTag();
        }
        Object object2 = this.elementNameStack[this.elementNesting - 1];
        String string2 = !this.isHtml ? null : (string = object2 instanceof Symbol ? ((Symbol)object2).getLocalPart() : object2.toString());
        if (this.inStartTag) {
            if (this.printIndent >= 0 && this.indentAttributes) {
                this.endLogicalBlock("");
            }
            this.bout.write(this.isHtml ? (XMLPrinter.isHtmlEmptyElementTag(string) ? ">" : "></" + string + ">") : (this.useEmptyElementTag == 2 ? " />" : "/>"));
            this.inStartTag = false;
        } else {
            if (this.printIndent >= 0) {
                this.setIndentation(0, false);
                if (this.prev == -4) {
                    this.writeBreak(this.printIndent > 0 ? 82 : 78);
                }
            }
            this.bout.write("</");
            this.writeQName(object2);
            this.bout.write(">");
        }
        if (this.printIndent >= 0) {
            this.endLogicalBlock("");
        }
        this.prev = -4;
        if (this.isHtml && !this.escapeText && ("script".equals(string) || "style".equals(string))) {
            this.escapeText = true;
        }
        this.namespaceBindings = this.namespaceSaveStack[--this.elementNesting];
        this.namespaceSaveStack[this.elementNesting] = null;
        this.elementNameStack[this.elementNesting] = null;
    }

    public void startAttribute(Object object2) {
        if (!this.inStartTag && this.strict) {
            this.error("attribute not in element", "SENR0001");
        }
        if (this.inAttribute) {
            this.bout.write(34);
        }
        this.inAttribute = true;
        this.bout.write(32);
        if (this.printIndent >= 0) {
            this.writeBreakFill();
        }
        this.bout.write(object2.toString());
        this.bout.write("=\"");
        this.prev = 32;
    }

    public void endAttribute() {
        if (this.inAttribute) {
            if (this.prev != -6) {
                this.bout.write(34);
                this.inAttribute = false;
            }
            this.prev = 32;
        }
    }

    public void writeDouble(double d) {
        this.startWord();
        this.bout.write(XMLPrinter.formatDouble(d));
    }

    public void writeFloat(float f) {
        this.startWord();
        this.bout.write(XMLPrinter.formatFloat(f));
    }

    public static String formatDouble(double d) {
        boolean bl;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        boolean bl2 = bl = d < 0.0;
        if (Double.isInfinite(d)) {
            return bl ? "-INF" : "INF";
        }
        double d2 = bl ? -d : d;
        String string = Double.toString(d);
        if ((d2 >= 1000000.0 || d2 < 1.0E-6) && d2 != 0.0) {
            return RealNum.toStringScientific(string);
        }
        return XMLPrinter.formatDecimal(RealNum.toStringDecimal(string));
    }

    public static String formatFloat(float f) {
        boolean bl;
        if (Float.isNaN(f)) {
            return "NaN";
        }
        boolean bl2 = bl = f < 0.0f;
        if (Float.isInfinite(f)) {
            return bl ? "-INF" : "INF";
        }
        float f2 = bl ? -f : f;
        String string = Float.toString(f);
        if ((f2 >= 1000000.0f || (double)f2 < 1.0E-6) && (double)f2 != 0.0) {
            return RealNum.toStringScientific(string);
        }
        return XMLPrinter.formatDecimal(RealNum.toStringDecimal(string));
    }

    public static String formatDecimal(BigDecimal bigDecimal) {
        return XMLPrinter.formatDecimal(bigDecimal.toPlainString());
    }

    static String formatDecimal(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            char c;
            int n2;
            int n3 = n2 = string.length();
            while ((c = string.charAt(--n3)) == '0') {
            }
            if (c != '.') {
                ++n3;
            }
            return n3 == n2 ? string : string.substring(0, n3);
        }
        return string;
    }

    public void print(Object object2) {
        if (object2 instanceof BigDecimal) {
            object2 = XMLPrinter.formatDecimal((BigDecimal)object2);
        } else if (object2 instanceof Double || object2 instanceof DFloNum) {
            object2 = XMLPrinter.formatDouble(((Number)object2).doubleValue());
        } else if (object2 instanceof Float) {
            object2 = XMLPrinter.formatFloat(((Float)object2).floatValue());
        }
        this.write(object2 == null ? "(null)" : object2.toString());
    }

    public void writeObject(Object object2) {
        if (object2 instanceof SeqPosition) {
            this.bout.clearWordEnd();
            SeqPosition seqPosition = (SeqPosition)object2;
            seqPosition.sequence.consumeNext(seqPosition.ipos, this);
            if (seqPosition.sequence instanceof NodeTree) {
                this.prev = 45;
            }
            return;
        }
        if (object2 instanceof Consumable && !(object2 instanceof UnescapedData)) {
            ((Consumable)object2).consume(this);
            return;
        }
        if (object2 instanceof Keyword) {
            this.startAttribute(((Keyword)object2).getName());
            this.prev = -6;
            return;
        }
        this.closeTag();
        if (object2 instanceof UnescapedData) {
            this.bout.clearWordEnd();
            this.bout.write(((UnescapedData)object2).getData());
            this.prev = 45;
        } else if (object2 instanceof Char) {
            Char.print(((Char)object2).intValue(), this);
        } else {
            this.startWord();
            this.prev = 32;
            this.print(object2);
            this.writeWordEnd();
            this.prev = -2;
        }
    }

    public boolean ignoring() {
        return false;
    }

    public void write(String string, int n, int n2) {
        if (n2 > 0) {
            this.closeTag();
            int n3 = n + n2;
            int n4 = 0;
            while (n < n3) {
                char c;
                if (this.mustHexEscape(c = string.charAt(n++)) || (this.inComment > 0 ? c == '-' || this.inComment == 2 : c == '<' || c == '>' || c == '&' || this.inAttribute && (c == '\"' || c < ' '))) {
                    if (n4 > 0) {
                        this.bout.write(string, n - 1 - n4, n4);
                    }
                    this.write(c);
                    n4 = 0;
                    continue;
                }
                ++n4;
            }
            if (n4 > 0) {
                this.bout.write(string, n3 - n4, n4);
            }
        }
        this.prev = 45;
    }

    public void write(char[] cArray, int n, int n2) {
        if (n2 > 0) {
            this.closeTag();
            int n3 = n + n2;
            int n4 = 0;
            while (n < n3) {
                char c;
                if (this.mustHexEscape(c = cArray[n++]) || (this.inComment > 0 ? c == '-' || this.inComment == 2 : c == '<' || c == '>' || c == '&' || this.inAttribute && (c == '\"' || c < ' '))) {
                    if (n4 > 0) {
                        this.bout.write(cArray, n - 1 - n4, n4);
                    }
                    this.write(c);
                    n4 = 0;
                    continue;
                }
                ++n4;
            }
            if (n4 > 0) {
                this.bout.write(cArray, n3 - n4, n4);
            }
        }
        this.prev = 45;
    }

    public void writePosition(AbstractSequence abstractSequence, int n) {
        abstractSequence.consumeNext(n, this);
    }

    public void writeBaseUri(Object object2) {
    }

    public void beginComment() {
        this.closeTag();
        if (this.printIndent >= 0 && (this.prev == -3 || this.prev == -4 || this.prev == -5)) {
            this.writeBreak(this.printIndent > 0 ? 82 : 78);
        }
        this.bout.write("<!--");
        this.inComment = 1;
    }

    public void endComment() {
        this.bout.write("-->");
        this.prev = -5;
        this.inComment = 0;
    }

    public void writeComment(String string) {
        this.beginComment();
        this.write(string);
        this.endComment();
    }

    public void writeComment(char[] cArray, int n, int n2) {
        this.beginComment();
        this.write(cArray, n, n2);
        this.endComment();
    }

    public void writeCDATA(char[] cArray, int n, int n2) {
        if (this.canonicalizeCDATA) {
            this.write(cArray, n, n2);
            return;
        }
        this.closeTag();
        this.bout.write("<![CDATA[");
        int n3 = n + n2;
        for (int i = n; i < n3 - 2; ++i) {
            if (cArray[i] != ']' || cArray[i + 1] != ']' || cArray[i + 2] != '>') continue;
            if (i > n) {
                this.bout.write(cArray, n, i - n);
            }
            this.print("]]]><![CDATA[]>");
            n = i + 3;
            n2 = n3 - n;
            i += 2;
        }
        this.bout.write(cArray, n, n2);
        this.bout.write("]]>");
        this.prev = 62;
    }

    public void writeProcessingInstruction(String string, char[] cArray, int n, int n2) {
        if ("xml".equals(string)) {
            this.needXMLdecl = false;
        }
        this.closeTag();
        this.bout.write("<?");
        this.print(string);
        this.print(' ');
        this.bout.write(cArray, n, n2);
        this.bout.write("?>");
        this.prev = 62;
    }

    public void consume(SeqPosition seqPosition) {
        seqPosition.sequence.consumeNext(seqPosition.ipos, this);
    }

    public void error(String string, String string2) {
        throw new RuntimeException("serialization error: " + string + " [" + string2 + ']');
    }
}

