/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.sax;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.SeqPosition;
import gnu.mapping.Symbol;
import gnu.text.Char;
import gnu.xml.XName;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentConsumer
implements Consumer {
    ContentHandler out;
    int nesting = 0;
    String[] names = new String[15];
    String attrQName;
    String attrURI;
    String attrLocalName;
    AttributesImpl attributes = new AttributesImpl();
    char[] chBuffer;
    StringBuilder strBuffer = new StringBuilder(200);
    int inStartTag;

    public ContentConsumer() {
    }

    public ContentConsumer(ContentHandler contentHandler) {
        this.out = contentHandler;
    }

    public void error(String string, SAXException sAXException) {
        throw new RuntimeException("caught " + sAXException + " in " + string);
    }

    public void endStartTag() {
        if (this.inStartTag != 1) {
            return;
        }
        int n = 3 * (this.nesting - 1);
        try {
            this.out.startElement(this.names[n], this.names[n + 1], this.names[n + 2], this.attributes);
        }
        catch (SAXException sAXException) {
            this.error("startElement", sAXException);
        }
        this.attributes.clear();
        this.inStartTag = 0;
    }

    public void startElement(Object object2) {
        String string;
        Object object3;
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.flushStrBuffer();
        int n = 3 * this.nesting;
        if (n >= this.names.length) {
            object3 = new String[2 * n];
            System.arraycopy(this.names, 0, object3, 0, n);
            this.names = object3;
        }
        if (object2 instanceof Symbol) {
            Symbol symbol = (Symbol)object2;
            object3 = symbol.getNamespaceURI();
            string = symbol.getLocalName();
        } else if (object2 instanceof XName) {
            XName xName = (XName)object2;
            object3 = xName.getNamespaceURI();
            string = xName.getLocalName();
        } else {
            object3 = "";
            string = object2.toString();
        }
        this.names[n] = object3;
        this.names[n + 1] = string;
        this.names[n + 2] = object2.toString();
        this.inStartTag = 1;
        ++this.nesting;
    }

    public void startAttribute(Object object2) {
        this.attrURI = ((Symbol)object2).getNamespaceURI();
        this.attrLocalName = ((Symbol)object2).getLocalName();
        this.attrQName = object2.toString();
        this.inStartTag = 2;
    }

    public void endAttribute() {
        this.attributes.addAttribute(this.attrURI, this.attrLocalName, this.attrQName, "CDATA", this.strBuffer.toString());
        this.strBuffer.setLength(0);
        this.inStartTag = 1;
    }

    public void startDocument() {
        try {
            this.out.startDocument();
        }
        catch (SAXException sAXException) {
            this.error("startDocument", sAXException);
        }
    }

    public void endDocument() {
        try {
            this.out.endDocument();
        }
        catch (SAXException sAXException) {
            this.error("endDocument", sAXException);
        }
    }

    public void endElement() {
        this.endStartTag();
        this.flushStrBuffer();
        --this.nesting;
        int n = 3 * this.nesting;
        try {
            this.out.endElement(this.names[n], this.names[n + 1], this.names[n + 2]);
        }
        catch (SAXException sAXException) {
            this.error("endElement", sAXException);
        }
        this.names[n] = null;
        this.names[n + 1] = null;
        this.names[n + 2] = null;
    }

    void flushStrBuffer() {
        if (this.strBuffer.length() > 0) {
            if (this.chBuffer == null) {
                this.chBuffer = new char[200];
            }
            try {
                int n;
                int n2 = this.strBuffer.length();
                int n3 = 0;
                while ((n = n2 - n3) > 0) {
                    if (n > this.chBuffer.length) {
                        n = this.chBuffer.length;
                    }
                    this.strBuffer.getChars(n3, n3 + n, this.chBuffer, n3);
                    this.out.characters(this.chBuffer, 0, n);
                    n3 += n;
                }
                this.strBuffer.setLength(0);
            }
            catch (SAXException sAXException) {
                this.error("characters", sAXException);
            }
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        if (this.inStartTag == 2) {
            this.strBuffer.append(cArray, n, n2);
        } else {
            this.flushStrBuffer();
            try {
                this.out.characters(cArray, n, n2);
            }
            catch (SAXException sAXException) {
                this.error("characters", sAXException);
            }
        }
    }

    public void write(int n) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        if (n >= 65536) {
            this.strBuffer.append((char)((n - 65536 >> 10) + 55296));
            n = (n & 0x3FF) + 56320;
        }
        this.strBuffer.append((char)n);
    }

    public void write(String string) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(string);
    }

    public void write(CharSequence charSequence, int n, int n2) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(charSequence, n, n2);
    }

    public ContentConsumer append(char c) {
        this.write(c);
        return this;
    }

    public ContentConsumer append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        this.write(charSequence, 0, charSequence.length());
        return this;
    }

    public ContentConsumer append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        this.write(charSequence, n, n2);
        return this;
    }

    public void writeObject(Object object2) {
        if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(this);
        } else if (object2 instanceof SeqPosition) {
            SeqPosition seqPosition = (SeqPosition)object2;
            seqPosition.sequence.consumeNext(seqPosition.ipos, this);
        } else if (object2 instanceof Char) {
            ((Char)object2).print(this);
        } else {
            this.write(object2 == null ? "(null)" : object2.toString());
        }
    }

    public void writeBoolean(boolean bl) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(bl);
    }

    public void writeLong(long l) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(l);
    }

    public void writeInt(int n) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(n);
    }

    public void writeFloat(float f) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(f);
    }

    public void writeDouble(double d) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(d);
    }

    public void finalize() {
        this.flushStrBuffer();
    }

    public boolean ignoring() {
        return false;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.out = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.out;
    }
}

