/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.swingviews;

import gnu.kawa.swingviews.GapPosition;
import gnu.kawa.swingviews.GapUndoableEdit;
import gnu.lists.CharBuffer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;

public class SwingContent
implements AbstractDocument.Content {
    public final CharBuffer buffer;

    public SwingContent(CharBuffer charBuffer) {
        this.buffer = charBuffer;
    }

    public SwingContent(int n) {
        CharBuffer charBuffer = new CharBuffer(n);
        charBuffer.gapEnd = n - 1;
        charBuffer.getArray()[charBuffer.gapEnd] = 10;
        this.buffer = charBuffer;
    }

    public SwingContent() {
        this(100);
    }

    public int length() {
        return this.buffer.length();
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        CharBuffer charBuffer = this.buffer;
        int n3 = charBuffer.getSegment(n, n2);
        if (n3 < 0) {
            throw new BadLocationException("invalid offset", n);
        }
        segment.offset = n3;
        segment.array = charBuffer.getArray();
        segment.count = n2;
    }

    public String getString(int n, int n2) throws BadLocationException {
        CharBuffer charBuffer = this.buffer;
        int n3 = charBuffer.getSegment(n, n2);
        if (n3 < 0) {
            throw new BadLocationException("invalid offset", n);
        }
        return new String(charBuffer.getArray(), n3, n2);
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        CharBuffer charBuffer = this.buffer;
        if (n2 < 0 || n < 0 || n + n2 > charBuffer.length()) {
            throw new BadLocationException("invalid remove", n);
        }
        charBuffer.delete(n, n2);
        GapUndoableEdit gapUndoableEdit = new GapUndoableEdit(n);
        gapUndoableEdit.content = this;
        gapUndoableEdit.data = new String(charBuffer.getArray(), charBuffer.gapEnd - n2, n2);
        gapUndoableEdit.nitems = n2;
        gapUndoableEdit.isInsertion = false;
        return gapUndoableEdit;
    }

    public UndoableEdit insertString(int n, String string, boolean bl) throws BadLocationException {
        CharBuffer charBuffer = this.buffer;
        if (n < 0 || n > charBuffer.length()) {
            throw new BadLocationException("bad insert", n);
        }
        charBuffer.insert(n, string, bl);
        GapUndoableEdit gapUndoableEdit = new GapUndoableEdit(n);
        gapUndoableEdit.content = this;
        gapUndoableEdit.data = string;
        gapUndoableEdit.nitems = string.length();
        gapUndoableEdit.isInsertion = true;
        return gapUndoableEdit;
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        return this.insertString(n, string, false);
    }

    public Position createPosition(int n) throws BadLocationException {
        CharBuffer charBuffer = this.buffer;
        if (n < 0 || n > charBuffer.length()) {
            throw new BadLocationException("bad offset to createPosition", n);
        }
        return new GapPosition(charBuffer, n);
    }
}

