/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.mapping.AliasConstraint;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.Symbol;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundSymbol;
import gnu.mapping.WrappedException;
import java.lang.reflect.Field;

public class ClassMemberConstraint
extends Constraint {
    ClassType type;
    String name;
    Field rfield;

    public ClassMemberConstraint(ClassType classType, String string) {
        this.type = classType;
        this.name = string;
    }

    public ClassMemberConstraint(Class clazz, String string) {
        this.type = (ClassType)Type.make(clazz);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public ClassType getDeclaringClass() {
        return this.type;
    }

    public ClassMemberConstraint(Field field) {
        this.rfield = field;
        this.name = field.getName();
    }

    void setup(Symbol symbol) {
        if (this.rfield == null) {
            Class clazz;
            try {
                clazz = this.type.getReflectClass();
            }
            catch (RuntimeException runtimeException) {
                String string = symbol.getName();
                throw new UnboundSymbol(string, "Unbound symbol " + string + " - " + runtimeException.toString());
            }
            try {
                this.rfield = clazz.getField(this.name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string = symbol.getName();
                throw new UnboundSymbol(string, "Unbound symbol " + string + " - no field " + this.name + " in " + this.type.getName());
            }
        }
    }

    public Object get(Symbol symbol, Object object2) {
        this.setup(symbol);
        try {
            return this.rfield.get(Constraint.getValue(symbol));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WrappedException(illegalAccessException);
        }
    }

    public void set(Symbol symbol, Object object2) {
        this.setup(symbol);
        try {
            this.rfield.set(Constraint.getValue(symbol), object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Constraint.setConstraint(symbol, new TrivialConstraint(this.getEnvironment(symbol)));
            Constraint.setValue(symbol, object2);
            return;
        }
    }

    public static void define(String string, Object object2, String string2) {
        ClassMemberConstraint.define(string, object2, string2, Environment.getCurrent());
    }

    public static void define(String string, Object object2, String string2, Environment environment) {
        Symbol symbol;
        Symbol symbol2 = symbol = environment.getSymbol(string);
        synchronized (symbol2) {
            Constraint.setValue(symbol, object2);
            Constraint.setConstraint(symbol, new ClassMemberConstraint(object2.getClass(), string2));
        }
    }

    public static void define(String string, Object object2, Field field, Environment environment) {
        if ((field.getModifiers() & 0x10) != 0) {
            try {
                Object object3 = field.get(object2);
                if (field.getType().getName() == "gnu.mapping.Location") {
                    string = Compilation.demangleName(string, true).intern();
                    Symbol symbol = environment.getSymbol(string);
                    AliasConstraint.define(symbol, (Location)object3);
                    return;
                }
                if (object3 instanceof Symbol) {
                    environment.addSymbol((Symbol)object3);
                    return;
                }
                String string2 = object3 instanceof Named ? ((Named)object3).getName() : null;
                string = string2 != null ? string2 : Compilation.demangleName(string, true);
                string = string.intern();
                environment.define(string, object3);
                return;
            }
            catch (Exception exception) {
                throw new WrappedException("error accessing field " + field, exception);
            }
        }
        string = string.intern();
        Symbol symbol = new Symbol(string);
        Constraint.setValue(symbol, object2);
        Constraint.setConstraint(symbol, new ClassMemberConstraint(field));
        environment.addSymbol(symbol);
    }

    public static void defineAll(Object object2, Environment environment) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            ClassMemberConstraint.define(field.getName(), object2, field, environment);
        }
    }
}

