/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.commonlisp.lang.CommonLisp;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Symbol;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class defvar
extends Syntax {
    boolean force;

    public defvar(boolean bl) {
        this.force = bl;
    }

    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        if (!(pair.cdr instanceof Pair)) {
            return super.scanForDefinitions(pair, vector, scopeExp, translator);
        }
        Pair pair2 = (Pair)pair.cdr;
        Object object2 = pair2.car;
        if (object2 instanceof String || object2 instanceof Symbol) {
            Declaration declaration = scopeExp.lookup(object2);
            if (declaration == null) {
                declaration = new Declaration(object2);
                scopeExp.addDeclaration(declaration);
            } else {
                translator.error('w', "duplicate declaration for `" + object2 + "'");
            }
            pair2 = Translator.makePair(pair2, declaration, pair2.cdr);
            pair = Translator.makePair(pair, this, pair2);
            if (scopeExp instanceof ModuleExp) {
                declaration.setCanRead(true);
                declaration.setCanWrite(true);
            }
        }
        vector.addElement(pair);
        return true;
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        Object object2;
        Object object3 = pair.cdr;
        Object object4 = null;
        Expression expression = null;
        Declaration declaration = null;
        if (object3 instanceof Pair) {
            object2 = (Pair)object3;
            if (((Pair)object2).car instanceof Declaration) {
                declaration = (Declaration)((Pair)object2).car;
                object4 = declaration.getSymbol();
                if (((Pair)object2).cdr instanceof Pair) {
                    Pair pair2 = (Pair)((Pair)object2).cdr;
                    expression = translator.rewrite(pair2.car);
                    if (pair2.cdr != LList.Empty) {
                        // empty if block
                    }
                } else if (((Pair)object2).cdr != LList.Empty) {
                    object4 = null;
                }
            }
        }
        if (object4 == null) {
            return translator.syntaxError("invalid syntax for " + this.getName());
        }
        if (expression == null) {
            if (this.force) {
                expression = CommonLisp.nilExpr;
            } else {
                return new QuoteExp(object4);
            }
        }
        object2 = new SetExp(object4, expression);
        if (!this.force) {
            ((SetExp)object2).setSetIfUnbound(true);
        }
        ((SetExp)object2).setDefining(true);
        if (declaration != null) {
            ((SetExp)object2).binding = declaration;
            if (declaration.context instanceof ModuleExp && declaration.getCanWrite()) {
                expression = null;
            }
            declaration.noteValue(expression);
        }
        return object2;
    }
}

