/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.CompileHandler;
import com.izforge.izpack.installer.CompileResult;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileWorker
implements Runnable {
    private ArrayList<CompilationJob> jobs;
    private static final String SPEC_RESOURCE_NAME = "CompilePanel.Spec.xml";
    private static final String ECLIPSE_COMPILER_NAME = "Integrated Eclipse JDT Compiler";
    private static final String ECLIPSE_COMPILER_CLASS = "org.eclipse.jdt.internal.compiler.batch.Main";
    private VariableSubstitutor vs;
    private IXMLElement spec;
    private AutomatedInstallData idata;
    private CompileHandler handler;
    private IXMLElement compilerSpec;
    private ArrayList<String> compilerList;
    private String compilerToUse;
    private IXMLElement compilerArgumentsSpec;
    private ArrayList<String> compilerArgumentsList;
    private String compilerArgumentsToUse;
    private CompileResult result = null;

    public CompileWorker(AutomatedInstallData automatedInstallData, CompileHandler compileHandler) throws IOException {
        this.idata = automatedInstallData;
        this.handler = compileHandler;
        this.vs = new VariableSubstitutor(automatedInstallData.getVariables());
        if (!this.readSpec()) {
            throw new IOException("Error reading compilation specification");
        }
    }

    public ArrayList<String> getAvailableCompilers() {
        this.readChoices(this.compilerSpec, this.compilerList);
        return this.compilerList;
    }

    public void setCompiler(String string) {
        this.compilerToUse = string;
    }

    public String getCompiler() {
        return this.compilerToUse;
    }

    public ArrayList<String> getAvailableArguments() {
        this.readChoices(this.compilerArgumentsSpec, this.compilerArgumentsList);
        return this.compilerArgumentsList;
    }

    public void setCompilerArguments(String string) {
        this.compilerArgumentsToUse = string;
    }

    public String getCompilerArguments() {
        return this.compilerArgumentsToUse;
    }

    public CompileResult getResult() {
        return this.result;
    }

    public void startThread() {
        Thread thread = new Thread((Runnable)this, "compilation thread");
        thread.start();
    }

    @Override
    public void run() {
        try {
            if (!this.collectJobs()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("nothing to do");
                this.result = new CompileResult(this.idata.langpack.getString("CompilePanel.worker.nofiles"), arrayList, "", "");
            } else {
                this.result = this.compileJobs();
            }
        }
        catch (Exception exception) {
            this.result = new CompileResult(exception);
        }
        this.handler.stopAction();
    }

    private boolean readSpec() {
        InputStream inputStream;
        try {
            inputStream = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        XMLParser xMLParser = new XMLParser();
        try {
            this.spec = xMLParser.parse(inputStream);
        }
        catch (Exception exception) {
            System.out.println("Error parsing XML specification for compilation.");
            exception.printStackTrace();
            return false;
        }
        if (!this.spec.hasChildren()) {
            return false;
        }
        this.compilerArgumentsList = new ArrayList();
        this.compilerList = new ArrayList();
        IXMLElement iXMLElement = this.spec.getFirstChildNamed("global");
        if (iXMLElement != null) {
            this.compilerSpec = iXMLElement.getFirstChildNamed("compiler");
            if (this.compilerSpec != null) {
                this.readChoices(this.compilerSpec, this.compilerList);
            }
            this.compilerArgumentsSpec = iXMLElement.getFirstChildNamed("arguments");
            if (this.compilerArgumentsSpec != null) {
                this.readChoices(this.compilerArgumentsSpec, this.compilerArgumentsList);
            }
        }
        if (this.compilerList.size() == 0) {
            this.compilerList.add("javac");
            this.compilerList.add("jikes");
        }
        if (this.compilerArgumentsList.size() == 0) {
            this.compilerArgumentsList.add("-O -g:none");
            this.compilerArgumentsList.add("-O");
            this.compilerArgumentsList.add("-g");
            this.compilerArgumentsList.add("");
        }
        return true;
    }

    private void readChoices(IXMLElement iXMLElement, ArrayList<String> arrayList) {
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed("choice");
        if (vector == null) {
            return;
        }
        arrayList.clear();
        for (IXMLElement iXMLElement2 : vector) {
            List<OsConstraint> list;
            String string = iXMLElement2.getAttribute("value");
            if (string == null || !OsConstraint.oneMatchesCurrentSystem(list = OsConstraint.getOsList(iXMLElement2))) continue;
            if (string.equalsIgnoreCase(ECLIPSE_COMPILER_NAME)) {
                try {
                    Class.forName(ECLIPSE_COMPILER_CLASS);
                    arrayList.add(string);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            arrayList.add(this.vs.substitute(string, "plain"));
        }
    }

    private boolean collectJobs() throws Exception {
        IXMLElement iXMLElement = this.spec.getFirstChildNamed("jobs");
        if (iXMLElement == null) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        this.jobs = new ArrayList();
        this.collectJobsRecursive(iXMLElement, arrayList);
        return true;
    }

    private CompileResult compileJobs() {
        CompilationJob compilationJob;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.compilerArgumentsToUse);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        Iterator<CompilationJob> iterator = this.jobs.iterator();
        this.handler.startAction("Compilation", this.jobs.size());
        if (iterator.hasNext() && !((CompileResult)(object = (compilationJob = this.jobs.get(0)).checkCompiler(this.compilerToUse, arrayList))).isContinue()) {
            return object;
        }
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            this.handler.nextStep(((CompilationJob)object).getName(), ((CompilationJob)object).getSize(), n++);
            CompileResult compileResult = ((CompilationJob)object).perform(this.compilerToUse, arrayList);
            if (compileResult.isContinue()) continue;
            return compileResult;
        }
        Debug.trace("compilation finished.");
        return new CompileResult();
    }

    private CompilationJob collectJobsRecursive(IXMLElement iXMLElement, ArrayList arrayList) throws Exception {
        Vector<IXMLElement> vector = iXMLElement.getChildren();
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object object2;
            IXMLElement iXMLElement2 = vector.elementAt(i);
            if ("classpath".equals(iXMLElement2.getName())) {
                this.changeClassPath(arrayList2, iXMLElement2);
                continue;
            }
            if ("job".equals(iXMLElement2.getName())) {
                object2 = this.collectJobsRecursive(iXMLElement2, arrayList2);
                if (object2 == null) continue;
                this.jobs.add((CompilationJob)object2);
                continue;
            }
            if ("directory".equals(iXMLElement2.getName())) {
                object2 = iXMLElement2.getAttribute("name");
                if (object2 == null) continue;
                object = this.vs.substitute((String)object2, "plain");
                arrayList3.addAll(this.scanDirectory(new File((String)object)));
                continue;
            }
            if ("file".equals(iXMLElement2.getName())) {
                object2 = iXMLElement2.getAttribute("name");
                if (object2 == null) continue;
                object = this.vs.substitute((String)object2, "plain");
                arrayList3.add(new File((String)object));
                continue;
            }
            if (!"packdepency".equals(iXMLElement2.getName())) continue;
            object2 = iXMLElement2.getAttribute("name");
            if (object2 == null) {
                System.out.println("invalid compilation spec: <packdepency> without name attribute");
                return null;
            }
            object = this.idata.selectedPacks.iterator();
            boolean bl = false;
            while (object.hasNext()) {
                Pack pack = (Pack)object.next();
                if (!pack.name.equals(object2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Debug.trace("skipping job because pack " + (String)object2 + " was not selected.");
            return null;
        }
        if (arrayList3.size() > 0) {
            return new CompilationJob(this.handler, this.idata, iXMLElement.getAttribute("name"), arrayList3, arrayList2);
        }
        return null;
    }

    private void changeClassPath(ArrayList arrayList, IXMLElement iXMLElement) throws Exception {
        String string;
        String string2 = iXMLElement.getAttribute("add");
        if (string2 != null) {
            if (!new File(string2 = this.vs.substitute(string2, "plain")).exists()) {
                if (!this.handler.emitWarning("Invalid classpath", "The path " + string2 + " could not be found.\nCompilation may fail.")) {
                    throw new Exception("Classpath " + string2 + " does not exist.");
                }
            } else {
                arrayList.add(this.vs.substitute(string2, "plain"));
            }
        }
        if ((string = iXMLElement.getAttribute("sub")) != null) {
            int n = -1;
            string = this.vs.substitute(string, "plain");
            do {
                n = arrayList.indexOf(string);
                arrayList.remove(n);
            } while (n >= 0);
        }
    }

    private ArrayList<File> scanDirectory(File file) {
        File[] fileArray;
        Debug.trace("scanning directory " + file.getAbsolutePath());
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            return arrayList;
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (file2 == null) continue;
            if (file2.isDirectory()) {
                arrayList.addAll(this.scanDirectory(file2));
                continue;
            }
            if (!file2.isFile() || !file2.getName().toLowerCase().endsWith(".java")) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    private static class StdErrParser
    extends StreamParser {
        int errorCount;

        private StdErrParser() {
        }

        int parse(byte[] byArray, int n, int n2) {
            super.init(byArray, n, n2);
            this.errorCount = 0;
            while (this.findString(". ERROR in ")) {
                ++this.errorCount;
            }
            return this.errorCount;
        }

        int getErrorCount() {
            return this.errorCount;
        }
    }

    private static class StdOutParser
    extends StreamParser {
        int fileno;
        int jobSize;
        String lastFilename;

        private StdOutParser() {
        }

        int parse(byte[] byArray, int n, int n2) {
            super.init(byArray, n, n2);
            this.fileno = -1;
            this.jobSize = -1;
            this.lastFilename = null;
            while (this.findString("[completed ") && this.skipSpaces() && this.readIdentifier()) {
                String string = new String(this.lastIdentifier);
                if (!this.skipSpaces()) continue;
                int n3 = this.getNext();
                if (n3 == Integer.MIN_VALUE) {
                    return this.fileno;
                }
                if (n3 != 45 || !this.skipSpaces()) continue;
                n3 = this.getNext();
                if (n3 == Integer.MIN_VALUE) {
                    return this.fileno;
                }
                if (n3 != 35) continue;
                if (!this.readNumber()) {
                    return this.fileno;
                }
                int n4 = this.lastDigit;
                n3 = this.getNext();
                if (n3 == Integer.MIN_VALUE) {
                    return this.fileno;
                }
                if (n3 != 47) continue;
                if (!this.readNumber()) {
                    return this.fileno;
                }
                n3 = this.getNext();
                if (n3 == Integer.MIN_VALUE) {
                    return this.fileno;
                }
                if (n3 != 93) continue;
                this.lastFilename = string;
                this.fileno = n4;
                this.jobSize = this.lastDigit;
            }
            return this.fileno;
        }

        String getLastFilename() {
            return this.lastFilename;
        }

        int getJobSize() {
            return this.jobSize;
        }
    }

    private static abstract class StreamParser {
        int idx;
        byte[] buffer;
        int offset;
        int length;
        byte[] lastIdentifier;
        int lastDigit;

        private StreamParser() {
        }

        abstract int parse(byte[] var1, int var2, int var3);

        void init(byte[] byArray, int n, int n2) {
            this.buffer = byArray;
            this.offset = n;
            this.length = n2;
            this.idx = 0;
            this.lastIdentifier = null;
            this.lastDigit = -1;
        }

        int getNext() {
            if (this.offset + this.idx == this.length) {
                return Integer.MIN_VALUE;
            }
            return this.buffer[this.offset + this.idx++];
        }

        boolean findString(String string) {
            byte[] byArray = string.getBytes();
            int n = 0;
            do {
                int n2;
                if ((n2 = this.getNext()) == Integer.MIN_VALUE) {
                    return false;
                }
                if (n2 == byArray[n]) {
                    ++n;
                    continue;
                }
                n = 0;
                if (n2 != byArray[n]) continue;
                ++n;
            } while (n < byArray.length);
            return true;
        }

        boolean readIdentifier() {
            int n;
            int n2 = this.idx;
            do {
                if ((n = this.getNext()) != Integer.MIN_VALUE) continue;
                return false;
            } while (!Character.isWhitespace((char)n));
            --this.idx;
            this.lastIdentifier = new byte[this.idx - n2];
            System.arraycopy(this.buffer, n2, this.lastIdentifier, 0, this.idx - n2);
            return true;
        }

        boolean readNumber() {
            int n;
            int n2 = this.idx;
            do {
                if ((n = this.getNext()) != Integer.MIN_VALUE) continue;
                return false;
            } while (Character.isDigit((char)n));
            --this.idx;
            String string = new String(this.buffer, n2, this.idx - n2);
            try {
                this.lastDigit = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }

        boolean skipSpaces() {
            int n;
            do {
                if ((n = this.getNext()) != Integer.MIN_VALUE) continue;
                return false;
            } while (Character.isWhitespace((char)n));
            --this.idx;
            return true;
        }
    }

    private static class EclipseStdErrHandler
    extends PrintStream {
        private int errorCount = 0;
        private StdErrParser parser = new StdErrParser();

        public EclipseStdErrHandler(OutputStream outputStream, CompileHandler compileHandler) {
            super(outputStream);
        }

        public void println(String string) {
            if (string.indexOf(". ERROR in ") > 0) {
                ++this.errorCount;
            }
            super.println(string);
        }

        public void write(byte[] byArray, int n, int n2) {
            super.write(byArray, n, n2);
            int n3 = this.parser.parse(byArray, n, n2);
            if (n3 > 0) {
                this.errorCount += n3;
            }
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }

    private static class EclipseStdOutHandler
    extends PrintStream {
        private CompileHandler listener;
        private StdOutParser parser;

        public EclipseStdOutHandler(OutputStream outputStream, CompileHandler compileHandler) {
            super(outputStream);
            this.listener = compileHandler;
            this.parser = new StdOutParser();
        }

        public void println(String string) {
            if (string.startsWith("[completed ")) {
                int n = string.lastIndexOf("#");
                int n2 = string.lastIndexOf("/");
                String string2 = string.substring(n + 1, n2 - n - 1);
                try {
                    int n3 = Integer.parseInt(string2);
                    this.listener.progress(n3, string);
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.log("could not parse eclipse compiler output: '" + string + "': " + numberFormatException.getMessage());
                }
            }
            super.println(string);
        }

        public void write(byte[] byArray, int n, int n2) {
            super.write(byArray, n, n2);
            int n3 = this.parser.parse(byArray, n, n2);
            if (n3 > -1) {
                this.listener.setSubStepNo(this.parser.getJobSize());
                this.listener.progress(n3, this.parser.getLastFilename());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilationJob {
        private CompileHandler listener;
        private String name;
        private ArrayList<File> files;
        private ArrayList classpath;
        private LocaleDatabase langpack;
        private AutomatedInstallData idata;
        private static final int MAX_CMDLINE_SIZE = 4096;

        public CompilationJob(CompileHandler compileHandler, AutomatedInstallData automatedInstallData, String string, ArrayList<File> arrayList, ArrayList arrayList2) {
            this.listener = compileHandler;
            this.idata = automatedInstallData;
            this.langpack = automatedInstallData.langpack;
            this.name = string;
            this.files = arrayList;
            this.classpath = arrayList2;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return "";
        }

        public int getSize() {
            return this.files.size();
        }

        public CompileResult perform(String string, ArrayList<String> arrayList) {
            Object object;
            Object object2;
            String string22;
            Debug.trace("starting job " + this.name);
            int n = 0;
            LinkedList<String> linkedList = new LinkedList<String>(arrayList);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                n += ((String)iterator.next()).length() + 1;
            }
            boolean bl = string.equalsIgnoreCase(CompileWorker.ECLIPSE_COMPILER_NAME);
            linkedList.add(0, string);
            n += string.length() + 1;
            StringBuffer stringBuffer = new StringBuffer();
            for (String string22 : this.classpath) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(File.pathSeparatorChar);
                }
                stringBuffer.append(new File(string22).getAbsolutePath());
            }
            string22 = stringBuffer.toString();
            if (string22.length() > 0) {
                linkedList.add("-classpath");
                n += 11;
                linkedList.add(string22);
                n += string22.length() + 1;
            }
            int n2 = linkedList.size();
            int n3 = n;
            FileExecutor fileExecutor = new FileExecutor();
            String[] stringArray = new String[2];
            String string3 = "";
            int n4 = 0;
            int n5 = 0;
            for (File file : this.files) {
                Object object3;
                object2 = file.getAbsolutePath();
                Debug.trace("processing " + (String)object2);
                ++n4;
                string3 = string3 + file.getName() + " ";
                linkedList.add((String)object2);
                if (bl || (n += ((String)object2).length()) < 4096) continue;
                Debug.trace("compiling " + string3);
                this.listener.progress(n5, string3);
                n5 = n4;
                int n6 = this.runCompiler(fileExecutor, stringArray, linkedList);
                this.listener.progress(n4, string3);
                if (n6 != 0) {
                    object3 = new CompileResult(this.langpack.getString("CompilePanel.error"), linkedList, stringArray[0], stringArray[1]);
                    this.listener.handleCompileError((CompileResult)object3);
                    if (!((CompileResult)object3).isContinue()) {
                        return object3;
                    }
                } else {
                    object3 = linkedList.listIterator(n2);
                    while (object3.hasNext()) {
                        File file2 = new File((String)object3.next());
                        object = file2.getName();
                        int n7 = ((String)object).lastIndexOf(46);
                        object = ((String)object).substring(0, n7) + ".class";
                        File file3 = new File(file2.getParentFile(), (String)object);
                        if (file3.exists()) continue;
                        CompileResult compileResult = new CompileResult(this.langpack.getString("CompilePanel.error.noclassfile") + file2.getAbsolutePath(), linkedList, stringArray[0], stringArray[1]);
                        this.listener.handleCompileError(compileResult);
                        if (compileResult.isContinue()) break;
                        return compileResult;
                    }
                }
                for (int i = linkedList.size() - 1; i >= n2; --i) {
                    linkedList.removeLast();
                }
                n = n3;
                string3 = "";
            }
            if (n > n3) {
                this.listener.progress(n5, string3);
                int n8 = this.runCompiler(fileExecutor, stringArray, linkedList);
                if (!bl) {
                    this.listener.progress(n4, string3);
                }
                if (n8 != 0) {
                    object2 = new CompileResult(this.langpack.getString("CompilePanel.error"), linkedList, stringArray[0], stringArray[1]);
                    this.listener.handleCompileError((CompileResult)object2);
                    if (!((CompileResult)object2).isContinue()) {
                        return object2;
                    }
                } else {
                    object2 = linkedList.listIterator(n2);
                    while (object2.hasNext()) {
                        File file = new File((String)object2.next());
                        String string4 = file.getName();
                        int n9 = string4.lastIndexOf(46);
                        string4 = string4.substring(0, n9) + ".class";
                        object = new File(file.getParentFile(), string4);
                        if (((File)object).exists()) continue;
                        CompileResult compileResult = new CompileResult(this.langpack.getString("CompilePanel.error.noclassfile") + file.getAbsolutePath(), linkedList, stringArray[0], stringArray[1]);
                        this.listener.handleCompileError(compileResult);
                        if (compileResult.isContinue()) break;
                        return compileResult;
                    }
                }
            }
            Debug.trace("job " + this.name + " done (" + n4 + " files compiled)");
            return new CompileResult();
        }

        private int runCompiler(FileExecutor fileExecutor, String[] stringArray, List<String> list) {
            if (list.get(0).equals(CompileWorker.ECLIPSE_COMPILER_NAME)) {
                return this.runEclipseCompiler(stringArray, list);
            }
            return fileExecutor.executeCommand(list.toArray(new String[list.size()]), stringArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int runEclipseCompiler(String[] stringArray, List<String> list) {
            try {
                LinkedList<String> linkedList = new LinkedList<String>(list);
                linkedList.remove(0);
                Class<?> clazz = Class.forName(CompileWorker.ECLIPSE_COMPILER_CLASS);
                Method method = clazz.getMethod("main", String[].class);
                linkedList.add(0, "-noExit");
                linkedList.add(0, "-progress");
                linkedList.add(0, "-verbose");
                File file = new File(this.idata.getInstallPath(), "compile-" + this.getName() + ".log");
                if (Debug.isTRACE()) {
                    linkedList.add(0, file.getPath());
                    linkedList.add(0, "-log");
                }
                try {
                    PrintStream printStream = System.out;
                    PrintStream printStream2 = System.err;
                    int n = 0;
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        EclipseStdOutHandler eclipseStdOutHandler = new EclipseStdOutHandler((OutputStream)byteArrayOutputStream, this.listener);
                        System.setOut(eclipseStdOutHandler);
                        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                        EclipseStdErrHandler eclipseStdErrHandler = new EclipseStdErrHandler((OutputStream)byteArrayOutputStream2, this.listener);
                        System.setErr(eclipseStdErrHandler);
                        method.invoke(null, new Object[]{linkedList.toArray(new String[linkedList.size()])});
                        stringArray[0] = byteArrayOutputStream.toString();
                        stringArray[1] = byteArrayOutputStream2.toString();
                        n = eclipseStdErrHandler.getErrorCount();
                        if (n > 0 || Debug.isTRACE()) {
                            File file2 = new File(file.getPath() + ".stdout");
                            FileOutputStream fileOutputStream = new FileOutputStream(file2);
                            fileOutputStream.write(byteArrayOutputStream.toByteArray());
                            fileOutputStream.close();
                            file2 = new File(file.getPath() + ".stderr");
                            fileOutputStream = new FileOutputStream(file2);
                            fileOutputStream.write(byteArrayOutputStream2.toByteArray());
                            fileOutputStream.close();
                        }
                    }
                    finally {
                        System.setOut(printStream);
                        System.setErr(printStream2);
                    }
                    if (n == 0) {
                        return 0;
                    }
                    this.listener.emitNotification("Compiler reported " + n + " errors");
                    return 1;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.listener.emitError("error compiling", fileNotFoundException.getMessage());
                    return -1;
                }
                catch (IOException iOException) {
                    this.listener.emitError("error compiling", iOException.getMessage());
                    return -1;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                stringArray[0] = "error getting eclipse compiler";
                stringArray[1] = classNotFoundException.getMessage();
                return -1;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                stringArray[0] = "error getting eclipse compiler method";
                stringArray[1] = noSuchMethodException.getMessage();
                return -1;
            }
            catch (IllegalAccessException illegalAccessException) {
                stringArray[0] = "error calling eclipse compiler";
                stringArray[1] = illegalAccessException.getMessage();
                return -1;
            }
            catch (InvocationTargetException invocationTargetException) {
                stringArray[0] = "error calling eclipse compiler";
                stringArray[1] = invocationTargetException.getMessage();
                return -1;
            }
        }

        public CompileResult checkCompiler(String string, ArrayList<String> arrayList) {
            String string22;
            Object object;
            if (string.equalsIgnoreCase(CompileWorker.ECLIPSE_COMPILER_NAME)) {
                return new CompileResult();
            }
            int n = 0;
            FileExecutor fileExecutor = new FileExecutor();
            String[] stringArray = new String[2];
            Debug.trace("checking whether \"" + string + " -help\" works");
            AbstractList abstractList = new ArrayList<String>();
            abstractList.add(string);
            abstractList.add("-help");
            n = this.runCompiler(fileExecutor, stringArray, abstractList);
            if (n != 0) {
                object = new CompileResult(this.langpack.getString("CompilePanel.error.compilernotfound"), abstractList, stringArray[0], stringArray[1]);
                this.listener.handleCompileError((CompileResult)object);
                if (!((CompileResult)object).isContinue()) {
                    return object;
                }
            }
            Debug.trace("checking whether \"" + string + " -help +arguments\" works");
            abstractList = new LinkedList<String>(arrayList);
            ((LinkedList)abstractList).add(0, (String)"-help");
            ((LinkedList)abstractList).add(0, string);
            object = new StringBuffer();
            for (String string22 : this.classpath) {
                if (((StringBuffer)object).length() > 0) {
                    ((StringBuffer)object).append(File.pathSeparatorChar);
                }
                ((StringBuffer)object).append(new File(string22).getAbsolutePath());
            }
            string22 = ((StringBuffer)object).toString();
            if (string22.length() > 0) {
                ((LinkedList)abstractList).add("-classpath");
                ((LinkedList)abstractList).add(string22);
            }
            if ((n = this.runCompiler(fileExecutor, stringArray, abstractList)) != 0) {
                CompileResult compileResult = new CompileResult(this.langpack.getString("CompilePanel.error.invalidarguments"), abstractList, stringArray[0], stringArray[1]);
                this.listener.handleCompileError(compileResult);
                if (!compileResult.isContinue()) {
                    return compileResult;
                }
            }
            return new CompileResult();
        }
    }
}

