/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool.keytool;

import gnu.crypto.tool.keytool.Command;
import gnu.crypto.util.Util;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;

class List
extends Command {
    public void run() throws Exception {
        KeyStore store = null;
        store = this.provider != null ? KeyStore.getInstance(this.storeType, this.provider) : KeyStore.getInstance(this.storeType);
        PasswordCallback pass = new PasswordCallback("keystore password: ", false);
        this.handler.handle(new Callback[]{pass});
        store.load(new FileInputStream(this.storeFile), pass.getPassword());
        this.list(store);
    }

    private final void list(KeyStore store) throws Exception {
        Enumeration<String> aliases = store.aliases();
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            out.print(alias);
            out.print(": ");
            out.print(store.getCreationDate(alias));
            out.print(", ");
            if (store.isCertificateEntry(alias)) {
                out.println("certificate entry");
                if (this.verbose == 1) {
                    Certificate cert = store.getCertificate(alias);
                    out.print("  Type: ");
                    out.println(cert.getType());
                    if (cert instanceof X509Certificate) {
                        out.print("  Issuer: ");
                        out.println(((X509Certificate)cert).getIssuerDN());
                        out.print("  Subject: ");
                        out.println(((X509Certificate)cert).getSubjectDN());
                        out.print("  Valid at ");
                        out.print(this.date);
                        try {
                            ((X509Certificate)cert).checkValidity(this.date);
                            out.println("? yes");
                        }
                        catch (Throwable t) {
                            out.println("? no");
                        }
                    }
                    try {
                        MessageDigest md = MessageDigest.getInstance("SHA-160");
                        byte[] digest = md.digest(cert.getPublicKey().getEncoded());
                        out.print("  Public key fingerprint (SHA-160): ");
                        out.println(Util.toString(digest));
                    }
                    catch (Throwable t) {}
                    continue;
                }
                if (this.verbose < 2) continue;
                out.println(store.getCertificate(alias));
                continue;
            }
            out.println("key entry");
        }
        this.print(str.toString());
    }

    public String toString() {
        return "list";
    }

    List(Command previous) {
        super(previous);
    }
}

