/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.sc.SilComp;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SiliconCompilerTab
extends PreferencePanel {
    private JTextField feedThruSize;
    private JComboBox horizRoutingArc;
    private JTextField horizWireWidth;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JComboBox mainPowerArc;
    private JTextField mainPowerWidth;
    private JTextField minActiveDist;
    private JTextField minMetalSpacing;
    private JTextField minPortDist;
    private JTextField nWellHeight;
    private JTextField nWellOffset;
    private JTextField numRows;
    private JTextField pWellHeight;
    private JTextField pWellOffset;
    private JTextField powerWidth;
    private JPanel siliconCompiler;
    private JComboBox vertRoutingArc;
    private JTextField vertWireWidth;
    private JTextField viaSize;

    public SiliconCompilerTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.numRows);
        EDialog.makeTextFieldSelectAllOnTab(this.horizWireWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.vertWireWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.powerWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.mainPowerWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.pWellHeight);
        EDialog.makeTextFieldSelectAllOnTab(this.pWellOffset);
        EDialog.makeTextFieldSelectAllOnTab(this.nWellHeight);
        EDialog.makeTextFieldSelectAllOnTab(this.nWellOffset);
        EDialog.makeTextFieldSelectAllOnTab(this.viaSize);
        EDialog.makeTextFieldSelectAllOnTab(this.minMetalSpacing);
        EDialog.makeTextFieldSelectAllOnTab(this.feedThruSize);
        EDialog.makeTextFieldSelectAllOnTab(this.minPortDist);
        EDialog.makeTextFieldSelectAllOnTab(this.minActiveDist);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.siliconCompiler;
    }

    @Override
    public String getName() {
        return "Silicon Compiler";
    }

    @Override
    public void init() {
        SilComp.SilCompPrefs scp = new SilComp.SilCompPrefs(false);
        this.numRows.setText(Integer.toString(scp.numRows));
        Iterator<ArcProto> it = Technology.getCurrent().getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            this.horizRoutingArc.addItem(ap.getName());
            this.vertRoutingArc.addItem(ap.getName());
            this.mainPowerArc.addItem(ap.getName());
        }
        this.horizRoutingArc.setSelectedItem(scp.horizRoutingArc);
        this.horizWireWidth.setText(TextUtils.formatDistance(scp.horizArcWidth));
        this.vertRoutingArc.setSelectedItem(scp.vertRoutingArc);
        this.vertWireWidth.setText(TextUtils.formatDistance(scp.vertArcWidth));
        this.powerWidth.setText(TextUtils.formatDistance(scp.powerWireWidth));
        this.mainPowerWidth.setText(TextUtils.formatDistance(scp.mainPowerWireWidth));
        this.mainPowerArc.setSelectedItem(scp.mainPowerArc);
        this.pWellHeight.setText(TextUtils.formatDistance(scp.pWellHeight));
        this.pWellOffset.setText(TextUtils.formatDistance(scp.pWellOffset));
        this.nWellHeight.setText(TextUtils.formatDistance(scp.nWellHeight));
        this.nWellOffset.setText(TextUtils.formatDistance(scp.nWellOffset));
        this.viaSize.setText(TextUtils.formatDistance(scp.viaSize));
        this.minMetalSpacing.setText(TextUtils.formatDistance(scp.minMetalSpacing));
        this.feedThruSize.setText(TextUtils.formatDistance(scp.feedThruSize));
        this.minPortDist.setText(TextUtils.formatDistance(scp.minPortDistance));
        this.minActiveDist.setText(TextUtils.formatDistance(scp.minActiveDistance));
    }

    @Override
    public void term() {
        SilComp.SilCompPrefs scp = new SilComp.SilCompPrefs(false);
        scp.numRows = TextUtils.atoi(this.numRows.getText());
        scp.horizRoutingArc = (String)this.horizRoutingArc.getSelectedItem();
        scp.horizArcWidth = TextUtils.atofDistance(this.horizWireWidth.getText());
        scp.vertRoutingArc = (String)this.vertRoutingArc.getSelectedItem();
        scp.vertArcWidth = TextUtils.atofDistance(this.vertWireWidth.getText());
        scp.powerWireWidth = TextUtils.atofDistance(this.powerWidth.getText());
        scp.mainPowerWireWidth = TextUtils.atofDistance(this.mainPowerWidth.getText());
        scp.mainPowerArc = (String)this.mainPowerArc.getSelectedItem();
        scp.pWellHeight = TextUtils.atofDistance(this.pWellHeight.getText());
        scp.pWellOffset = TextUtils.atofDistance(this.pWellOffset.getText());
        scp.nWellHeight = TextUtils.atofDistance(this.nWellHeight.getText());
        scp.nWellOffset = TextUtils.atofDistance(this.nWellOffset.getText());
        scp.viaSize = TextUtils.atofDistance(this.viaSize.getText());
        scp.minMetalSpacing = TextUtils.atofDistance(this.minMetalSpacing.getText());
        scp.feedThruSize = TextUtils.atofDistance(this.feedThruSize.getText());
        scp.minPortDistance = TextUtils.atofDistance(this.minPortDist.getText());
        scp.minActiveDistance = TextUtils.atofDistance(this.minActiveDist.getText());
        this.putPrefs(scp);
    }

    @Override
    public void reset() {
        this.putPrefs(new SilComp.SilCompPrefs(true));
    }

    private void initComponents() {
        this.siliconCompiler = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel11 = new JLabel();
        this.numRows = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.horizRoutingArc = new JComboBox();
        this.jLabel1 = new JLabel();
        this.horizWireWidth = new JTextField();
        this.jLabel3 = new JLabel();
        this.vertWireWidth = new JTextField();
        this.jLabel4 = new JLabel();
        this.vertRoutingArc = new JComboBox();
        this.jLabel5 = new JLabel();
        this.powerWidth = new JTextField();
        this.jLabel9 = new JLabel();
        this.mainPowerWidth = new JTextField();
        this.jLabel10 = new JLabel();
        this.mainPowerArc = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel20 = new JLabel();
        this.pWellHeight = new JTextField();
        this.jLabel6 = new JLabel();
        this.pWellOffset = new JTextField();
        this.jLabel7 = new JLabel();
        this.nWellHeight = new JTextField();
        this.jLabel8 = new JLabel();
        this.nWellOffset = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabel12 = new JLabel();
        this.viaSize = new JTextField();
        this.jLabel13 = new JLabel();
        this.minMetalSpacing = new JTextField();
        this.jLabel14 = new JLabel();
        this.feedThruSize = new JTextField();
        this.jLabel15 = new JLabel();
        this.minPortDist = new JTextField();
        this.jLabel16 = new JLabel();
        this.minActiveDist = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Silicon Compiler Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SiliconCompilerTab.this.closeDialog(evt);
            }
        });
        this.siliconCompiler.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 1));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(new TitledBorder("Layout"));
        this.jLabel11.setText("Number of rows of cells:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabel11, gridBagConstraints);
        this.numRows.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.numRows, gridBagConstraints);
        this.jPanel5.add(this.jPanel3);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Arcs"));
        this.jLabel2.setText("Horizontal routing arc:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.horizRoutingArc, gridBagConstraints);
        this.jLabel1.setText("Horizontal wire width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.horizWireWidth.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.horizWireWidth, gridBagConstraints);
        this.jLabel3.setText("Vertical routing arc:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.vertWireWidth.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.vertWireWidth, gridBagConstraints);
        this.jLabel4.setText("Vertical wire width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel1.add((Component)this.vertRoutingArc, gridBagConstraints);
        this.jLabel5.setText("Power wire width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.powerWidth.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.powerWidth, gridBagConstraints);
        this.jLabel9.setText("Main power wire width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.mainPowerWidth.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.mainPowerWidth, gridBagConstraints);
        this.jLabel10.setText("Main power arc:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.mainPowerArc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel5.add(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.siliconCompiler.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 1));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("Well"));
        this.jLabel20.setText("P-Well height (0 for none):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.jLabel20, gridBagConstraints);
        this.pWellHeight.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.pWellHeight, gridBagConstraints);
        this.jLabel6.setText("P-Well offset from bottom:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.pWellOffset.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.pWellOffset, gridBagConstraints);
        this.jLabel7.setText("N-Well height (0 for none):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.nWellHeight.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel2.add((Component)this.nWellHeight, gridBagConstraints);
        this.jLabel8.setText("N-Well offset from top:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        this.nWellOffset.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel2.add((Component)this.nWellOffset, gridBagConstraints);
        this.jPanel6.add(this.jPanel2);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("Design Rules"));
        this.jLabel12.setText("Via size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel12, gridBagConstraints);
        this.viaSize.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.viaSize, gridBagConstraints);
        this.jLabel13.setText("Minimum metal spacing:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel13, gridBagConstraints);
        this.minMetalSpacing.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.minMetalSpacing, gridBagConstraints);
        this.jLabel14.setText("Routing feed-through size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel14, gridBagConstraints);
        this.feedThruSize.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.feedThruSize, gridBagConstraints);
        this.jLabel15.setText("Routing min. port distance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel15, gridBagConstraints);
        this.minPortDist.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.minPortDist, gridBagConstraints);
        this.jLabel16.setText("Routing min. active distance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel16, gridBagConstraints);
        this.minActiveDist.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.minActiveDist, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel6.add(this.jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.siliconCompiler.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.siliconCompiler, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

